/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.mapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class MappingAdmin {
    protected HBaseConnection m_admin;
    protected HBaseBytesUtilShim m_bytesUtil;
    protected String m_mappingTableName = "pentaho_mappings";
    public static final String COLUMNS_FAMILY_NAME = "columns";
    public static final String KEY_FAMILY_NAME = "key";

    public MappingAdmin() {
        try {
            HadoopConfiguration active = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
            HBaseShim hbaseShim = active.getHBaseShim();
            this.m_bytesUtil = hbaseShim.getHBaseConnection().getBytesUtil();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public MappingAdmin(HBaseConnection conn) {
        this();
        this.setConnection(conn);
    }

    public MappingAdmin(HBaseConnection conn, HBaseBytesUtilShim bytesUtil) {
        this.m_bytesUtil = bytesUtil;
        this.setConnection(conn);
    }

    public void setConnection(HBaseConnection conn) {
        this.m_admin = conn;
    }

    public HBaseConnection getConnection() {
        return this.m_admin;
    }

    public void setMappingTableName(String tableName) {
        this.m_mappingTableName = tableName;
    }

    public String getMappingTableName() {
        return this.m_mappingTableName;
    }

    public void createTestMapping() throws Exception {
        String keyName = "MyKey";
        String tableName = "MarksTestTable";
        String mappingName = "MarksTestMapping";
        Mapping.KeyType keyType = Mapping.KeyType.LONG;
        Mapping testMapping = new Mapping(tableName, mappingName, keyName, keyType);
        String family1 = "Family1";
        String colA = "first_string_column";
        String combined = family1 + "," + colA + "," + colA;
        HBaseValueMeta vm = new HBaseValueMeta(combined, 2, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colB = "first_unsigned_int_column";
        combined = family1 + "," + colB + "," + colB;
        vm = new HBaseValueMeta(combined, 5, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String family2 = "Family2";
        String colC = "first_indexed_column";
        combined = family2 + "," + colC + "," + colC;
        vm = new HBaseValueMeta(combined, 2, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        vm.setStorageType(2);
        Object[] vals = new Object[]{"nomVal1", "nomVal2", "nomVal3"};
        vm.setIndex(vals);
        testMapping.addMappedColumn(vm, false);
        String colD = "first_binary_column";
        combined = family1 + "," + colD + "," + colD;
        vm = new HBaseValueMeta(combined, 8, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colE = "first_boolean_column";
        combined = family1 + "," + colE + "," + colE;
        vm = new HBaseValueMeta(combined, 4, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colF = "first_signed_date_column";
        combined = family1 + "," + colF + "," + colF;
        vm = new HBaseValueMeta(combined, 3, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colG = "first_signed_double_column";
        combined = family2 + "," + colG + "," + colG;
        vm = new HBaseValueMeta(combined, 1, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colH = "first_signed_float_column";
        combined = family2 + "," + colH + "," + colH;
        vm = new HBaseValueMeta(combined, 1, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colI = "first_signed_int_column";
        combined = family2 + "," + colI + "," + colI;
        vm = new HBaseValueMeta(combined, 5, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colJ = "first_signed_long_column";
        combined = family2 + "," + colJ + "," + colJ;
        vm = new HBaseValueMeta(combined, 5, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colK = "first_unsigned_date_column";
        combined = family2 + "," + colK + "," + colK;
        vm = new HBaseValueMeta(combined, 3, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colL = "first_unsigned_double_column";
        combined = family2 + "," + colL + "," + colL;
        vm = new HBaseValueMeta(combined, 1, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colM = "first_unsigned_float_column";
        combined = family2 + "," + colM + "," + colM;
        vm = new HBaseValueMeta(combined, 1, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colN = "first_unsigned_long_column";
        combined = family2 + "," + colN + "," + colN;
        vm = new HBaseValueMeta(combined, 5, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        this.putMapping(testMapping, false);
    }

    public void createTestTupleMapping() throws Exception {
        String keyName = "KEY";
        String tableName = "MarksTestTupleTable";
        String mappingName = "MarksTestTupleMapping";
        Mapping.KeyType keyType = Mapping.KeyType.UNSIGNED_LONG;
        Mapping testMapping = new Mapping(tableName, mappingName, keyName, keyType);
        testMapping.setTupleMapping(true);
        String family = "";
        String colName = "";
        String combined = family + "," + colName;
        HBaseValueMeta vm = new HBaseValueMeta(combined + "," + "Family", 2, -1, -1);
        testMapping.addMappedColumn(vm, true);
        vm = new HBaseValueMeta(combined + "," + "Column", 2, -1, -1);
        testMapping.addMappedColumn(vm, true);
        vm = new HBaseValueMeta(combined + "," + "Value", 2, -1, -1);
        testMapping.addMappedColumn(vm, true);
        vm = new HBaseValueMeta(combined + "," + "Timestamp", 5, -1, -1);
        vm.setIsLongOrDouble(true);
        testMapping.addMappedColumn(vm, true);
        this.putMapping(testMapping, false);
    }

    public void createTupleTestTable() throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        if (this.m_admin.tableExists("MarksTestTupleTable")) {
            this.m_admin.disableTable("MarksTestTupleTable");
            this.m_admin.deleteTable("MarksTestTupleTable");
        }
        ArrayList<String> colFamilies = new ArrayList<String>();
        colFamilies.add("Family1");
        colFamilies.add("Family2");
        this.m_admin.createTable("MarksTestTupleTable", colFamilies, null);
        Properties props = new Properties();
        props.setProperty("htable.writeBufferSize", "12582912");
        this.m_admin.newTargetTable("MarksTestTupleTable", props);
        for (long key = 1L; key < 500L; ++key) {
            this.m_admin.newTargetTablePut(HBaseValueMeta.encodeKeyValue((Object)new Long(key), (Mapping.KeyType)Mapping.KeyType.UNSIGNED_LONG, (HBaseBytesUtilShim)this.m_bytesUtil), false);
            int i = 0;
            while ((long)i < 10L * (key % 2L + 1L)) {
                if (i < 10) {
                    this.m_admin.addColumnToTargetPut("Family1", "string_col" + i, false, this.m_bytesUtil.toBytes("StringValue_" + key));
                } else {
                    this.m_admin.addColumnToTargetPut("Family2", "string_col" + i, false, this.m_bytesUtil.toBytes("StringValue_" + key));
                }
                this.m_admin.executeTargetTablePut();
                ++i;
            }
        }
        this.m_admin.flushCommitsTargetTable();
        this.m_admin.closeTargetTable();
    }

    public void createTestTable() throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        if (this.m_admin.tableExists("MarksTestTable")) {
            this.m_admin.disableTable("MarksTestTable");
            this.m_admin.deleteTable("MarksTestTable");
        }
        ArrayList<String> colFamilies = new ArrayList<String>();
        colFamilies.add("Family1");
        colFamilies.add("Family2");
        this.m_admin.createTable("MarksTestTable", colFamilies, null);
        Properties props = new Properties();
        props.setProperty("htable.writeBufferSize", "12582912");
        this.m_admin.newTargetTable("MarksTestTable", props);
        Random r = new Random();
        String[] nomVals = new String[]{"nomVal1", "nomVal2", "nomVal3"};
        Date date = new Date();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.set(1970, 2, 1);
        for (long key = -500L; key < 20000L; ++key) {
            this.m_admin.newTargetTablePut(HBaseValueMeta.encodeKeyValue((Object)new Long(key), (Mapping.KeyType)Mapping.KeyType.LONG, (HBaseBytesUtilShim)this.m_bytesUtil), false);
            this.m_admin.addColumnToTargetPut("Family1", "first_unsigned_int_column", false, this.m_bytesUtil.toBytes((key < 0L ? (long)((int)(-key)) : key) / 10L));
            this.m_admin.addColumnToTargetPut("Family1", "first_string_column", false, this.m_bytesUtil.toBytes("StringValue_" + key));
            if (key % 10L > 0L) {
                int index = r.nextInt(3);
                String nomVal = nomVals[index];
                this.m_admin.addColumnToTargetPut("Family2", "first_indexed_column", false, this.m_bytesUtil.toBytes(nomVal));
            }
            double d = r.nextDouble();
            int signedInt = r.nextInt(100);
            if (d < 0.5) {
                signedInt = -signedInt;
            }
            this.m_admin.addColumnToTargetPut("Family2", "first_signed_int_column", false, this.m_bytesUtil.toBytes(signedInt));
            float f = r.nextFloat() * 1000.0f;
            this.m_admin.addColumnToTargetPut("Family2", "first_unsigned_float_column", false, this.m_bytesUtil.toBytes(f));
            if (d > 0.5) {
                f = -f;
            }
            this.m_admin.addColumnToTargetPut("Family2", "first_signed_float_column", false, this.m_bytesUtil.toBytes(f));
            double dd = d * 10000.0 * r.nextDouble();
            this.m_admin.addColumnToTargetPut("Family2", "first_unsigned_double_column", false, this.m_bytesUtil.toBytes(dd));
            if (d > 0.5) {
                dd = -dd;
            }
            this.m_admin.addColumnToTargetPut("Family2", "first_signed_double_column", false, this.m_bytesUtil.toBytes(dd));
            long l = r.nextInt(300);
            this.m_admin.addColumnToTargetPut("Family2", "first_unsigned_long_column", false, this.m_bytesUtil.toBytes(l));
            if (d < 0.5) {
                l = -l;
            }
            this.m_admin.addColumnToTargetPut("Family2", "first_signed_long_column", false, this.m_bytesUtil.toBytes(l));
            ((Calendar)c).add(6, 1);
            long longd = c.getTimeInMillis();
            this.m_admin.addColumnToTargetPut("Family1", "first_unsigned_date_column", false, this.m_bytesUtil.toBytes(longd));
            ((Calendar)c2).add(6, -1);
            longd = c2.getTimeInMillis();
            this.m_admin.addColumnToTargetPut("Family1", "first_signed_date_column", false, this.m_bytesUtil.toBytes(longd));
            String bVal = "";
            bVal = d < 0.5 ? "N" : "Y";
            this.m_admin.addColumnToTargetPut("Family1", "first_boolean_column", false, this.m_bytesUtil.toBytes(bVal));
            byte[] serialized = HBaseValueMeta.encodeObject((Object)new Double(d));
            this.m_admin.addColumnToTargetPut("Family1", "first_serialized_column", false, serialized);
            byte[] rawStuff = this.m_bytesUtil.toBytes(5034555);
            this.m_admin.addColumnToTargetPut("Family1", "first_binary_column", false, rawStuff);
            this.m_admin.executeTargetTablePut();
        }
        this.m_admin.flushCommitsTargetTable();
        this.m_admin.closeTargetTable();
    }

    public void createMappingTable() throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        if (this.m_admin.tableExists(this.m_mappingTableName)) {
            throw new IOException("Mapping table already exists!");
        }
        ArrayList<String> colFamNames = new ArrayList<String>();
        colFamNames.add(COLUMNS_FAMILY_NAME);
        colFamNames.add(KEY_FAMILY_NAME);
        this.m_admin.createTable(this.m_mappingTableName, colFamNames, null);
    }

    public boolean mappingExists(String tableName, String mappingName) throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        if (this.m_admin.tableExists(this.m_mappingTableName)) {
            this.m_admin.newSourceTable(this.m_mappingTableName);
            String compoundKey = tableName + "," + mappingName;
            boolean result = this.m_admin.sourceTableRowExists(this.m_bytesUtil.toBytes(compoundKey));
            this.m_admin.closeSourceTable();
            return result;
        }
        return false;
    }

    public Set<String> getMappedTables() throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        HashSet<String> tableNames = new HashSet<String>();
        if (this.m_admin.tableExists(this.m_mappingTableName)) {
            this.m_admin.newSourceTable(this.m_mappingTableName);
            this.m_admin.newSourceTableScan(null, null, 10);
            this.m_admin.executeSourceTableScan();
            while (this.m_admin.resultSetNextRow()) {
                byte[] rawKey = this.m_admin.getResultSetCurrentRowKey();
                String decodedKey = this.m_bytesUtil.toString(rawKey);
                String tableName = decodedKey.substring(0, decodedKey.indexOf(","));
                tableNames.add(tableName.trim());
            }
            this.m_admin.closeSourceTable();
        }
        return tableNames;
    }

    public List<String> getMappingNames(String tableName) throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        ArrayList<String> mappingsForTable = new ArrayList<String>();
        if (this.m_admin.tableExists(this.m_mappingTableName)) {
            this.m_admin.newSourceTable(this.m_mappingTableName);
            this.m_admin.newSourceTableScan(null, null, 10);
            this.m_admin.executeSourceTableScan();
            while (this.m_admin.resultSetNextRow()) {
                byte[] rowKey = this.m_admin.getResultSetCurrentRowKey();
                String decodedKey = this.m_bytesUtil.toString(rowKey);
                String tableN = decodedKey.substring(0, decodedKey.indexOf(",")).trim();
                if (!tableName.equals(tableN)) continue;
                String mappingName = decodedKey.substring(decodedKey.indexOf(",") + 1, decodedKey.length());
                mappingsForTable.add(mappingName);
            }
            this.m_admin.closeSourceTable();
        }
        return mappingsForTable;
    }

    public boolean deleteMapping(String tableName, String mappingName) throws Exception {
        boolean mappingExists;
        String compoundKey = tableName + "," + mappingName;
        if (!this.m_admin.tableExists(this.m_mappingTableName)) {
            this.createMappingTable();
            return false;
        }
        if (this.m_admin.isTableDisabled(this.m_mappingTableName)) {
            this.m_admin.enableTable(this.m_mappingTableName);
        }
        if (!(mappingExists = this.mappingExists(tableName, mappingName))) {
            return false;
        }
        this.m_admin.newTargetTable(this.m_mappingTableName, null);
        byte[] key = this.m_bytesUtil.toBytes(compoundKey);
        this.m_admin.executeTargetTableDelete(key);
        return true;
    }

    public boolean deleteMapping(Mapping theMapping) throws Exception {
        String tableName = theMapping.getTableName();
        String mappingName = theMapping.getMappingName();
        return this.deleteMapping(tableName, mappingName);
    }

    public void putMapping(Mapping theMapping, boolean overwrite) throws Exception {
        boolean mappingExists;
        String tableName = theMapping.getTableName();
        String mappingName = theMapping.getMappingName();
        Map mapping = theMapping.getMappedColumns();
        String keyName = theMapping.getKeyName();
        Mapping.KeyType keyType = theMapping.getKeyType();
        boolean isTupleMapping = theMapping.isTupleMapping();
        String tupleFamilies = theMapping.getTupleFamilies();
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        String compoundKey = tableName + "," + mappingName;
        if (!this.m_admin.tableExists(this.m_mappingTableName)) {
            this.createMappingTable();
        }
        this.m_admin.newTargetTable(this.m_mappingTableName, null);
        if (this.m_admin.isTableDisabled(this.m_mappingTableName)) {
            this.m_admin.enableTable(this.m_mappingTableName);
        }
        if ((mappingExists = this.mappingExists(tableName, mappingName)) && !overwrite) {
            throw new IOException("The mapping \"" + mappingName + "\" already exists " + "for table \"" + tableName + "\"");
        }
        if (mappingExists) {
            this.m_admin.executeTargetTableDelete(this.m_bytesUtil.toBytes(compoundKey));
        }
        this.m_admin.newTargetTablePut(this.m_bytesUtil.toBytes(compoundKey), true);
        String family = COLUMNS_FAMILY_NAME;
        Set aliases = mapping.keySet();
        for (String alias : aliases) {
            HBaseValueMeta vm = (HBaseValueMeta)mapping.get(alias);
            String qualifier = vm.getColumnFamily() + "," + vm.getColumnName() + "," + alias;
            String valueType = ValueMetaInterface.typeCodes[vm.getType()];
            if (vm.isInteger() && vm.getIsLongOrDouble()) {
                valueType = "Long";
            }
            if (vm.isNumber()) {
                valueType = vm.getIsLongOrDouble() ? "Double" : "Float";
            }
            if (vm.getStorageType() == 2 && vm.isString()) {
                Object[] labels = vm.getIndex();
                StringBuffer vals = new StringBuffer();
                vals.append("{");
                for (int i = 0; i < labels.length; ++i) {
                    if (i != labels.length - 1) {
                        vals.append(labels[i].toString().trim()).append(",");
                        continue;
                    }
                    vals.append(labels[i].toString().trim()).append("}");
                }
                valueType = vals.toString();
            }
            this.m_admin.addColumnToTargetPut(family, qualifier, false, this.m_bytesUtil.toBytes(valueType));
        }
        family = KEY_FAMILY_NAME;
        String qualifier = keyName;
        if (isTupleMapping) {
            qualifier = qualifier + ",";
            if (!Const.isEmpty((String)tupleFamilies)) {
                qualifier = qualifier + tupleFamilies;
            }
        }
        String valueType = keyType.toString();
        this.m_admin.addColumnToTargetPut(family, qualifier, false, this.m_bytesUtil.toBytes(valueType));
        this.m_admin.executeTargetTablePut();
        this.m_admin.flushCommitsTargetTable();
        this.m_admin.closeTargetTable();
    }

    public String describeMapping(String tableName, String mappingName) throws Exception {
        return this.describeMapping(this.getMapping(tableName, mappingName));
    }

    public String describeMapping(Mapping aMapping) throws IOException {
        return aMapping.toString();
    }

    public Mapping getMapping(String tableName, String mappingName) throws Exception {
        if (this.m_admin == null) {
            throw new IOException("No connection exists yet!");
        }
        String compoundKey = tableName + "," + mappingName;
        if (!this.m_admin.tableExists(this.m_mappingTableName)) {
            this.createMappingTable();
            throw new IOException("Mapping \"" + compoundKey + "\" does not exist!");
        }
        this.m_admin.newSourceTable(this.m_mappingTableName);
        this.m_admin.newSourceTableScan(this.m_bytesUtil.toBytes(compoundKey), this.m_bytesUtil.toBytes(compoundKey), 10);
        this.m_admin.executeSourceTableScan();
        if (!this.m_admin.resultSetNextRow()) {
            throw new IOException("Mapping \"" + compoundKey + "\" does not exist!");
        }
        NavigableMap colsInKeyFamily = this.m_admin.getResultSetCurrentRowFamilyMap(KEY_FAMILY_NAME);
        Set keyCols = colsInKeyFamily.keySet();
        if (keyCols.size() != 1) {
            throw new IOException("Mapping \"" + compoundKey + "\" has more than one key defined!");
        }
        byte[] keyNameB = (byte[])keyCols.iterator().next();
        String decodedKeyName = this.m_bytesUtil.toString(keyNameB);
        byte[] keyTypeB = (byte[])colsInKeyFamily.get(keyNameB);
        String decodedKeyType = this.m_bytesUtil.toString(keyTypeB);
        Mapping.KeyType keyType = null;
        for (Mapping.KeyType t : Mapping.KeyType.values()) {
            if (!decodedKeyType.equalsIgnoreCase(t.toString())) continue;
            keyType = t;
            break;
        }
        if (keyType == null) {
            throw new IOException("Unrecognized type for the key column in \"" + compoundKey + "\"");
        }
        String tupleFamilies = "";
        boolean isTupleMapping = false;
        if (decodedKeyName.indexOf(44) > 0) {
            isTupleMapping = true;
            if (decodedKeyName.indexOf(44) != decodedKeyName.length() - 1) {
                tupleFamilies = decodedKeyName.substring(decodedKeyName.indexOf(44) + 1, decodedKeyName.length());
            }
            decodedKeyName = decodedKeyName.substring(0, decodedKeyName.indexOf(44));
        }
        Mapping resultMapping = new Mapping(tableName, mappingName, decodedKeyName, keyType);
        resultMapping.setTupleMapping(isTupleMapping);
        if (!Const.isEmpty((String)tupleFamilies)) {
            resultMapping.setTupleFamilies(tupleFamilies);
        }
        TreeMap<String, HBaseValueMeta> resultCols = new TreeMap<String, HBaseValueMeta>();
        NavigableMap colsInMapping = this.m_admin.getResultSetCurrentRowFamilyMap(COLUMNS_FAMILY_NAME);
        Set colNames = colsInMapping.keySet();
        for (byte[] b : colNames) {
            String decodedName = this.m_bytesUtil.toString(b);
            byte[] c = (byte[])colsInMapping.get(b);
            if (c == null) {
                throw new IOException("No type declaration for column \"" + decodedName + "\"");
            }
            String decodedType = this.m_bytesUtil.toString(c);
            HBaseValueMeta newMeta = null;
            if (decodedType.equalsIgnoreCase("Float")) {
                newMeta = new HBaseValueMeta(decodedName, 1, -1, -1);
                newMeta.setIsLongOrDouble(false);
            } else if (decodedType.equalsIgnoreCase("Double")) {
                newMeta = new HBaseValueMeta(decodedName, 1, -1, -1);
            } else if (decodedType.equalsIgnoreCase("String")) {
                newMeta = new HBaseValueMeta(decodedName, 2, -1, -1);
            } else if (decodedType.toLowerCase().startsWith("date")) {
                newMeta = new HBaseValueMeta(decodedName, 3, -1, -1);
            } else if (decodedType.equalsIgnoreCase("Boolean")) {
                newMeta = new HBaseValueMeta(decodedName, 4, -1, -1);
            } else if (decodedType.equalsIgnoreCase("Integer")) {
                newMeta = new HBaseValueMeta(decodedName, 5, -1, -1);
                newMeta.setIsLongOrDouble(false);
            } else if (decodedType.equalsIgnoreCase("Long")) {
                newMeta = new HBaseValueMeta(decodedName, 5, -1, -1);
            } else if (decodedType.equalsIgnoreCase("BigNumber")) {
                newMeta = new HBaseValueMeta(decodedName, 6, -1, -1);
            } else if (decodedType.equalsIgnoreCase("Serializable")) {
                newMeta = new HBaseValueMeta(decodedName, 7, -1, -1);
            } else if (decodedType.equalsIgnoreCase("Binary")) {
                newMeta = new HBaseValueMeta(decodedName, 8, -1, -1);
            } else if (decodedType.startsWith("{") && decodedType.endsWith("}")) {
                newMeta = new HBaseValueMeta(decodedName, 2, -1, -1);
                Object[] labels = null;
                try {
                    labels = HBaseValueMeta.stringIndexListToObjects((String)decodedType);
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException("Indexed/nominal type must have at least one label declared");
                }
                newMeta.setIndex(labels);
                newMeta.setStorageType(2);
            } else {
                throw new IOException("Unknown column type : \"" + decodedType + "\"");
            }
            newMeta.setTableName(tableName);
            newMeta.setMappingName(mappingName);
            if (resultMapping.getKeyName().equals(newMeta.getAlias())) {
                throw new IOException("Error in mapping. Column \"" + newMeta.getAlias() + "\" has the same name as the table key (" + resultMapping.getKeyName() + ")");
            }
            resultCols.put(newMeta.getAlias(), newMeta);
        }
        resultMapping.setMappedColumns(resultCols);
        this.m_admin.closeSourceTable();
        return resultMapping;
    }

    public static void main(String[] args) {
        try {
            String tableName = "MarksTestTable";
            String mappingName = "MarksTestMapping";
            HadoopConfiguration active = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
            HBaseShim hbaseShim = active.getHBaseShim();
            HBaseConnection conn = hbaseShim.getHBaseConnection();
            Properties connProps = new Properties();
            connProps.setProperty("hbase.zookeeper.quorum", "localhost");
            conn.configureConnection(connProps, null);
            MappingAdmin admin = new MappingAdmin();
            admin.setConnection(conn);
            if (args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].endsWith("help")) {
                System.err.println("Commands:\n");
                System.err.println("\tlist tables - lists all tables with one or more mappings defined");
                System.err.println("\tlist mappings for table <tableName> - list all mappings for table <tableName>");
                System.err.println("\tdescribe mapping <mappingName> on table <tableName> - print out meta data for mapping <mapping name> on table <tableName");
                System.exit(0);
            }
            if (args[0].equalsIgnoreCase("create")) {
                if (args.length > 1 && args[1].equalsIgnoreCase("test")) {
                    System.out.println("Creating a test table...");
                    admin.createTestTable();
                    return;
                }
                String keyName = "MyKey";
                Mapping.KeyType keyType = Mapping.KeyType.LONG;
                Mapping testMapping = new Mapping(tableName, mappingName, keyName, keyType);
                String family1 = "Family1";
                String colA = "first_string_column";
                String combined = family1 + "," + colA + "," + colA;
                HBaseValueMeta vm = new HBaseValueMeta(combined, 2, -1, -1);
                vm.setTableName(tableName);
                vm.setMappingName(mappingName);
                testMapping.addMappedColumn(vm, false);
                String colB = "first_integer_column";
                combined = family1 + "," + colB + "," + colB;
                vm = new HBaseValueMeta(combined, 5, -1, -1);
                vm.setTableName(tableName);
                vm.setMappingName(mappingName);
                testMapping.addMappedColumn(vm, false);
                String family2 = "Family2";
                String colC = "first_indexed_column";
                combined = family2 + "," + colC + "," + colC;
                vm = new HBaseValueMeta(combined, 2, -1, -1);
                vm.setTableName(tableName);
                vm.setMappingName(mappingName);
                vm.setStorageType(2);
                Object[] vals = new Object[]{"nomVal1", "nomVal2", "nomVal3"};
                vm.setIndex(vals);
                testMapping.addMappedColumn(vm, false);
                admin.putMapping(testMapping, false);
            } else if (args[0].equalsIgnoreCase("describe")) {
                String usage = "Usage: describe mapping <mappingName> on table <tableName>";
                if (args.length != 6) {
                    System.err.println(usage);
                    System.exit(1);
                }
                if (!args[1].equalsIgnoreCase("mapping")) {
                    System.err.println(usage);
                    System.exit(1);
                }
                String mName = args[2].trim();
                if (!args[3].equalsIgnoreCase("on") && !args[4].equalsIgnoreCase("table")) {
                    System.err.println(usage);
                    System.exit(1);
                }
                String tabName = args[5];
                String description = admin.describeMapping(tabName, mName);
                System.out.println(description);
            } else if (args[0].equalsIgnoreCase("list") && args.length == 2) {
                if (!args[1].equalsIgnoreCase("tables")) {
                    System.err.println("Usage: list tables");
                    System.exit(1);
                }
                Set<String> tables = admin.getMappedTables();
                System.out.println("Tables with mappings:\n");
                for (String t : tables) {
                    System.out.println("\t" + t);
                }
            } else if (args[0].equalsIgnoreCase("list") && args.length > 2) {
                String usage = "Usage: list mappings for table <tableName>";
                if (args.length != 5) {
                    System.err.println(usage);
                    System.exit(1);
                }
                if (!(args[1].equalsIgnoreCase("mappings") && args[2].equalsIgnoreCase("for") && args[3].equalsIgnoreCase("table"))) {
                    System.err.println(usage);
                    System.exit(1);
                }
                List<String> mappings = admin.getMappingNames(args[4]);
                System.out.println("Mappings that exist for table \"" + args[4] + "\":\n");
                for (String m : mappings) {
                    System.out.println("\t" + m);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

