/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Type;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Visitor;

public class BinaryExpression
extends Expression {
    public final Expression expression0;
    public final Expression expression1;
    private final Primitive primitive;

    BinaryExpression(ExpressionType nodeType, Type type, Expression expression0, Expression expression1) {
        super(nodeType, type);
        this.expression0 = expression0;
        this.expression1 = expression1;
        this.primitive = Primitive.of(expression0.getType());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)obj;
            return this.nodeType == binary.nodeType && this.type.equals(binary.type) && this.expression0.equals(binary.expression0) && this.expression1.equals(binary.expression1);
        }
        return false;
    }

    public int hashCode() {
        return this.nodeType.hashCode() ^ this.expression0.hashCode() ^ this.expression1.hashCode();
    }

    public Expression accept(Visitor visitor) {
        Expression expression0 = this.expression0.accept(visitor);
        Expression expression1 = this.expression1.accept(visitor);
        return visitor.visit(this, expression0, expression1);
    }

    public Object evaluate(Evaluator evaluator) {
        switch (this.nodeType) {
            case AndAlso: {
                return (Boolean)this.expression0.evaluate(evaluator) != false && (Boolean)this.expression1.evaluate(evaluator) != false;
            }
            case Add: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) + (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) + (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Divide: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) / (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) / (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Equal: {
                return this.expression0.evaluate(evaluator).equals(this.expression1.evaluate(evaluator));
            }
            case GreaterThan: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) > (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) > (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case GreaterThanOrEqual: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) >= (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) >= (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case LessThan: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) < (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) < (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case LessThanOrEqual: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) <= (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) <= (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Multiply: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) * (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) * (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case NotEqual: {
                return !this.expression0.evaluate(evaluator).equals(this.expression1.evaluate(evaluator));
            }
            case OrElse: {
                return (Boolean)this.expression0.evaluate(evaluator) != false || (Boolean)this.expression1.evaluate(evaluator) != false;
            }
            case Subtract: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) - (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) - (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
        }
        throw this.cannotEvaluate();
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        this.expression0.accept(writer, lprec, this.nodeType.lprec);
        writer.append(this.nodeType.op);
        this.expression1.accept(writer, this.nodeType.rprec, rprec);
    }

    private RuntimeException cannotEvaluate() {
        return new RuntimeException("cannot evaluate " + this + ", nodeType=" + (Object)((Object)this.nodeType) + ", primitive=" + (Object)((Object)this.primitive));
    }
}

