/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.GotoStatement;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

public class BlockBuilder {
    final List<Statement> statements = new ArrayList<Statement>();
    final Set<String> variables = new HashSet<String>();
    private final boolean optimizing;

    public BlockBuilder() {
        this(true);
    }

    public BlockBuilder(boolean optimizing) {
        this.optimizing = optimizing;
    }

    public void clear() {
        this.statements.clear();
        this.variables.clear();
    }

    public Expression append(String name, BlockStatement block) {
        return this.append(name, block, true);
    }

    public Expression append(String name, BlockStatement block, boolean optimize) {
        Statement lastStatement;
        if (this.statements.size() > 0 && (lastStatement = this.statements.get(this.statements.size() - 1)) instanceof GotoStatement) {
            this.statements.set(this.statements.size() - 1, Expressions.statement(((GotoStatement)lastStatement).expression));
        }
        Expression result = null;
        HashMap<ParameterExpression, Expression> replacements = new HashMap<ParameterExpression, Expression>();
        SubstituteVariableVisitor visitor = new SubstituteVariableVisitor(replacements);
        for (int i = 0; i < block.statements.size(); ++i) {
            Statement statement = block.statements.get(i);
            if (!replacements.isEmpty()) {
                statement = statement.accept(visitor);
            }
            if (statement instanceof DeclarationStatement) {
                DeclarationStatement declaration = (DeclarationStatement)statement;
                if (this.variables.contains(declaration.parameter.name)) {
                    Expression x = this.append(this.newName(declaration.parameter.name, optimize), declaration.initializer);
                    statement = null;
                    result = x;
                    replacements.put(declaration.parameter, x);
                } else {
                    this.add(statement);
                }
            } else {
                this.add(statement);
            }
            if (i != block.statements.size() - 1) continue;
            if (statement instanceof DeclarationStatement) {
                result = ((DeclarationStatement)statement).parameter;
                continue;
            }
            if (!(statement instanceof GotoStatement)) continue;
            this.statements.remove(this.statements.size() - 1);
            result = this.append_(name, ((GotoStatement)statement).expression, optimize);
            if (result instanceof ParameterExpression || result instanceof ConstantExpression) continue;
            DeclarationStatement declare = Expressions.declare(16, this.newName(name, optimize), result);
            this.add(declare);
            result = declare.parameter;
        }
        return result;
    }

    public Expression append(String name, Expression expression) {
        return this.append(name, expression, true);
    }

    public Expression appendIfNotNull(String name, Expression expression) {
        if (expression == null) {
            return null;
        }
        return this.append(name, expression, true);
    }

    public Expression append(String name, Expression expression, boolean optimize) {
        Statement lastStatement;
        if (this.statements.size() > 0 && (lastStatement = this.statements.get(this.statements.size() - 1)) instanceof GotoStatement) {
            this.statements.set(this.statements.size() - 1, Expressions.statement(((GotoStatement)lastStatement).expression));
        }
        return this.append_(name, expression, optimize);
    }

    private Expression append_(String name, Expression expression, boolean optimize) {
        if (expression instanceof ParameterExpression || expression instanceof ConstantExpression && (((ConstantExpression)expression).value != null || expression.type == Object.class)) {
            return expression;
        }
        if (this.optimizing) {
            for (Statement statement : this.statements) {
                if (!(statement instanceof DeclarationStatement)) continue;
                DeclarationStatement decl = (DeclarationStatement)statement;
                if ((decl.modifiers & 0x10) == 0 || decl.initializer == null || !decl.initializer.equals(expression)) continue;
                return decl.parameter;
            }
        }
        DeclarationStatement declare = Expressions.declare(16, this.newName(name, optimize), expression);
        this.add(declare);
        return declare.parameter;
    }

    public void add(Statement statement) {
        String name;
        this.statements.add(statement);
        if (statement instanceof DeclarationStatement && !this.variables.add(name = ((DeclarationStatement)statement).parameter.name)) {
            throw new AssertionError((Object)("duplicate variable " + name));
        }
    }

    public void add(Expression expression) {
        this.add(Expressions.return_(null, expression));
    }

    public BlockStatement toBlock() {
        if (this.optimizing) {
            this.optimize();
        }
        return Expressions.block(this.statements);
    }

    private void optimize() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        UseCounter useCounter = new UseCounter();
        for (Statement statement : this.statements) {
            if (!(statement instanceof DeclarationStatement)) continue;
            Slot slot = new Slot((DeclarationStatement)statement);
            useCounter.map.put(slot.parameter, slot);
            slots.add(slot);
        }
        for (Statement statement : this.statements) {
            statement.accept(useCounter);
        }
        HashMap<ParameterExpression, Expression> subMap = new HashMap<ParameterExpression, Expression>();
        SubstituteVariableVisitor visitor = new SubstituteVariableVisitor(subMap);
        ArrayList<Statement> oldStatements = new ArrayList<Statement>(this.statements);
        this.statements.clear();
        for (Statement oldStatement : oldStatements) {
            if (oldStatement instanceof DeclarationStatement) {
                DeclarationStatement statement = (DeclarationStatement)oldStatement;
                Slot slot = (Slot)useCounter.map.get(statement.parameter);
                int count = slot.count;
                if (Expressions.isConstantNull(slot.expression)) {
                    count = 100;
                }
                if (statement.parameter.name.startsWith("_")) {
                    count = 100;
                }
                if (slot.expression instanceof NewExpression && ((NewExpression)((Slot)slot).expression).memberDeclarations != null) {
                    count = 100;
                }
                switch (count) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        subMap.put(slot.parameter, slot.expression);
                        break;
                    }
                    default: {
                        this.statements.add(statement);
                        break;
                    }
                }
                continue;
            }
            this.statements.add(oldStatement.accept(visitor));
        }
        if (!subMap.isEmpty()) {
            oldStatements.clear();
            oldStatements.addAll(this.statements);
            this.statements.clear();
            for (Statement oldStatement : oldStatements) {
                this.statements.add(oldStatement.accept(visitor));
            }
        }
    }

    private String newName(String suggestion, boolean optimize) {
        if (!optimize && !suggestion.startsWith("_")) {
            suggestion = '_' + suggestion;
        }
        return this.newName(suggestion);
    }

    public String newName(String suggestion) {
        int i = 0;
        String candidate = suggestion;
        while (this.variables.contains(candidate)) {
            candidate = suggestion + i++;
        }
        return candidate;
    }

    public BlockBuilder append(Expression expression) {
        this.add(expression);
        return this;
    }

    private static class Slot {
        private final ParameterExpression parameter;
        private final Expression expression;
        private int count;

        public Slot(DeclarationStatement declarationStatement) {
            this.parameter = declarationStatement.parameter;
            this.expression = declarationStatement.initializer;
        }
    }

    private static class UseCounter
    extends Visitor {
        private final Map<ParameterExpression, Slot> map = new HashMap<ParameterExpression, Slot>();

        private UseCounter() {
        }

        public Expression visit(ParameterExpression parameter) {
            Slot slot = this.map.get(parameter);
            if (slot != null) {
                slot.count++;
            }
            return super.visit(parameter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubstituteVariableVisitor
    extends Visitor {
        private final Map<ParameterExpression, Expression> map;
        private final Map<ParameterExpression, Boolean> actives = new IdentityHashMap<ParameterExpression, Boolean>();

        public SubstituteVariableVisitor(Map<ParameterExpression, Expression> map) {
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Expression visit(ParameterExpression parameterExpression) {
            Expression e = this.map.get(parameterExpression);
            if (e != null) {
                try {
                    Boolean put = this.actives.put(parameterExpression, true);
                    if (put != null) {
                        throw new AssertionError((Object)("recursive expansion of " + parameterExpression + " in " + this.actives.keySet()));
                    }
                    Expression expression = e.accept(this);
                    return expression;
                }
                finally {
                    this.actives.remove(parameterExpression);
                }
            }
            return super.visit(parameterExpression);
        }
    }
}

