/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStatement
extends Statement {
    public final List<Statement> statements;

    BlockStatement(List<Statement> statements, Type type) {
        super(ExpressionType.Block, type);
        this.statements = statements;
        assert (this.distinctVariables(true));
    }

    private boolean distinctVariables(boolean fail) {
        HashSet<String> names = new HashSet<String>();
        for (Statement statement : this.statements) {
            String name;
            if (!(statement instanceof DeclarationStatement) || names.add(name = ((DeclarationStatement)statement).parameter.name)) continue;
            assert (!fail) : "duplicate variable " + name;
            return false;
        }
        return true;
    }

    @Override
    public BlockStatement accept(Visitor visitor) {
        List<Statement> newStatements = Expressions.acceptStatements(this.statements, visitor);
        return visitor.visit(this, newStatements);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        if (this.statements.isEmpty()) {
            writer.append("{}");
            return;
        }
        writer.begin("{\n");
        for (Statement node : this.statements) {
            node.accept(writer, 0, 0);
        }
        writer.end("}\n");
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        Object o = null;
        for (Statement statement : this.statements) {
            o = statement.evaluate(evaluator);
        }
        return o;
    }
}

