/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

public class WhileStatement
extends Statement {
    public final Expression condition;
    public final Statement body;

    public WhileStatement(Expression condition, Statement body) {
        super(ExpressionType.While, Void.TYPE);
        this.condition = condition;
        this.body = body;
    }

    public Statement accept(Visitor visitor) {
        Expression condition1 = this.condition.accept(visitor);
        Statement body1 = this.body.accept(visitor);
        return visitor.visit(this, condition1, body1);
    }

    void accept0(ExpressionWriter writer) {
        writer.append("while (").append(this.condition).append(") ").append(Blocks.toBlock(this.body));
    }
}

