/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBundleJob;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_BUNDLE_JOB", query="update BundleJobBean w set w.appName = :appName, w.appPath = :appPath, w.conf = :conf, w.externalId = :externalId, w.timeOut = :timeOut, w.createdTimestamp = :createdTimestamp, w.endTimestamp = :endTimestamp, w.jobXml = :jobXml, w.lastModifiedTimestamp = :lastModifiedTimestamp, w.origJobXml = :origJobXml, w.startTimestamp = :startTimestamp, w.status = :status, w.timeUnitStr = :timeUnit, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_STATUS", query="update BundleJobBean w set w.status = :status, w.lastModifiedTimestamp = :lastModifiedTimestamp, w.pending = :pending where w.id = :id"), @NamedQuery(name="DELETE_BUNDLE_JOB", query="delete from BundleJobBean w where w.id = :id"), @NamedQuery(name="GET_BUNDLE_JOBS", query="select OBJECT(w) from BundleJobBean w"), @NamedQuery(name="GET_BUNDLE_JOB", query="select OBJECT(w) from BundleJobBean w where w.id = :id"), @NamedQuery(name="GET_BUNDLE_JOBS_COUNT", query="select count(w) from BundleJobBean w"), @NamedQuery(name="GET_BUNDLE_JOBS_COLUMNS", query="select w.id, w.appName, w.appPath, w.conf, w.status, w.kickoffTimestamp, w.startTimestamp, w.endTimestamp, w.pauseTimestamp, w.createdTimestamp, w.user, w.group, w.timeUnitStr, w.timeOut from BundleJobBean w order by w.createdTimestamp desc"), @NamedQuery(name="GET_BUNDLE_JOBS_RUNNING_OR_PENDING", query="select OBJECT(w) from BundleJobBean w where w.status = 'RUNNING' OR w.status = 'RUNNINGWITHERROR' OR w.pending = 1 order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_NEED_START", query="select OBJECT(w) from BundleJobBean w where w.status = 'PREP' AND (w.kickoffTimestamp IS NULL OR (w.kickoffTimestamp IS NOT NULL AND w.kickoffTimestamp <= :currentTime)) order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_PAUSED", query="select OBJECT(w) from BundleJobBean w where w.status = 'PAUSED' OR w.status = 'PAUSEDWITHERROR' OR w.status = 'PREPPAUSED' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_UNPAUSED", query="select OBJECT(w) from BundleJobBean w where w.status = 'RUNNING' OR w.status = 'RUNNINGWITHERROR' OR w.status = 'PREP' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_OLDER_THAN", query="select OBJECT(w) from BundleJobBean w where w.startTimestamp <= :matTime AND (w.status = 'PREP' OR w.status = 'RUNNING' or w.status = 'RUNNINGWITHERROR')  order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_OLDER_THAN_STATUS", query="select OBJECT(w) from BundleJobBean w where w.status = :status AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COMPLETED_BUNDLE_JOBS_OLDER_THAN", query="select w.id from BundleJobBean w where ( w.status = 'SUCCEEDED' OR w.status = 'FAILED' OR w.status = 'KILLED' OR w.status = 'DONEWITHERROR') AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="BULK_MONITOR_BUNDLE_QUERY", query="SELECT b.id, b.status, b.user FROM BundleJobBean b WHERE b.appName = :appName"), @NamedQuery(name="BULK_MONITOR_ACTIONS_QUERY", query="SELECT a.id, a.actionNumber, a.errorCode, a.errorMessage, a.externalId, a.externalStatus, a.status, a.createdTimestamp, a.nominalTimestamp, a.missingDependencies, c.id, c.appName, c.status FROM CoordinatorActionBean a, CoordinatorJobBean c WHERE a.jobId = c.id AND c.bundleId = :bundleId ORDER BY a.jobId, a.createdTimestamp"), @NamedQuery(name="BULK_MONITOR_COUNT_QUERY", query="SELECT COUNT(a) FROM CoordinatorActionBean a, CoordinatorJobBean c"), @NamedQuery(name="GET_BUNDLE_JOB_FOR_USER", query="select w.user from BundleJobBean w where w.id = :id")})
public class BundleJobBean
extends JsonBundleJob
implements Writable,
PersistenceCapable {
    @Basic
    @Index
    @Column(name="status")
    private String status = Job.Status.PREP.toString();
    @Basic
    @Column(name="kickoff_time")
    private Timestamp kickoffTimestamp = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Column(name="pause_time")
    private Timestamp pauseTimestamp = null;
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Column(name="time_unit")
    private String timeUnitStr = BundleJob.Timeunit.NONE.toString();
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Index
    @Column(name="suspended_time")
    private Timestamp suspendedTimestamp = null;
    @Column(name="job_xml")
    @Lob
    private String jobXml = null;
    @Column(name="orig_job_xml")
    @Lob
    private String origJobXml = null;
    private static int pcInheritedFieldCount = JsonBundleJob.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonBundleJob;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$BundleJobBean;

    public Timestamp getKickoffTimestamp() {
        return BundleJobBean.pcGetkickoffTimestamp(this);
    }

    public Timestamp getstartTimestamp() {
        return BundleJobBean.pcGetstartTimestamp(this);
    }

    public void setKickoffTimestamp(Timestamp kickoffTimestamp) {
        super.setKickoffTime(DateUtils.toDate(kickoffTimestamp));
        BundleJobBean.pcSetkickoffTimestamp(this, kickoffTimestamp);
    }

    public void setStartTimestamp(Timestamp startTimestamp) {
        super.setStartTime(DateUtils.toDate(startTimestamp));
        BundleJobBean.pcSetstartTimestamp(this, startTimestamp);
    }

    @Override
    public void setStartTime(Date startTime) {
        super.setStartTime(startTime);
        BundleJobBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    public Timestamp getEndTimestamp() {
        return BundleJobBean.pcGetendTimestamp(this);
    }

    public void setEndTimestamp(Timestamp endTimestamp) {
        super.setEndTime(DateUtils.toDate(endTimestamp));
        BundleJobBean.pcSetendTimestamp(this, endTimestamp);
    }

    public Timestamp getPauseTimestamp() {
        return BundleJobBean.pcGetpauseTimestamp(this);
    }

    public void setPauseTimestamp(Timestamp pauseTimestamp) {
        super.setPauseTime(DateUtils.toDate(pauseTimestamp));
        BundleJobBean.pcSetpauseTimestamp(this, pauseTimestamp);
    }

    public Timestamp getCreatedTimestamp() {
        return BundleJobBean.pcGetcreatedTimestamp(this);
    }

    @Override
    public Date getCreatedTime() {
        return DateUtils.toDate(BundleJobBean.pcGetcreatedTimestamp(this));
    }

    public String getTimeUnitStr() {
        return BundleJobBean.pcGettimeUnitStr(this);
    }

    public int getPending() {
        return BundleJobBean.pcGetpending(this);
    }

    @Override
    public void setPending() {
        super.setPending();
        BundleJobBean.pcSetpending(this, 1);
    }

    @Override
    public void resetPending() {
        super.resetPending();
        BundleJobBean.pcSetpending(this, 0);
    }

    public boolean isPending() {
        return BundleJobBean.pcGetpending(this) == 1;
    }

    public Timestamp getLastModifiedTimestamp() {
        return BundleJobBean.pcGetlastModifiedTimestamp(this);
    }

    public void setLastModifiedTimestamp(Timestamp lastModifiedTimestamp) {
        BundleJobBean.pcSetlastModifiedTimestamp(this, lastModifiedTimestamp);
    }

    public Timestamp getSuspendedTimestamp() {
        return BundleJobBean.pcGetsuspendedTimestamp(this);
    }

    public void setSuspendedTimestamp(Timestamp suspendedTimestamp) {
        BundleJobBean.pcSetsuspendedTimestamp(this, suspendedTimestamp);
    }

    public String getJobXml() {
        return BundleJobBean.pcGetjobXml(this);
    }

    public void setJobXml(String jobXml) {
        BundleJobBean.pcSetjobXml(this, jobXml);
    }

    public String getOrigJobXml() {
        return BundleJobBean.pcGetorigJobXml(this);
    }

    public void setOrigJobXml(String origJobXml) {
        BundleJobBean.pcSetorigJobXml(this, origJobXml);
    }

    @Override
    public void setCreatedTime(Date createTime) {
        super.setCreatedTime(createTime);
        BundleJobBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createTime));
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        BundleJobBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(BundleJobBean.pcGetlastModifiedTimestamp(this));
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getAppPath());
        WritableUtils.writeStr(dataOutput, this.getAppName());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        WritableUtils.writeStr(dataOutput, this.getTimeUnit().toString());
        dataOutput.writeLong(this.getKickoffTime() != null ? this.getKickoffTime().getTime() : -1L);
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getUser());
        WritableUtils.writeStr(dataOutput, this.getGroup());
        WritableUtils.writeStr(dataOutput, this.getExternalId());
        dataOutput.writeInt(this.getTimeout());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setAppPath(WritableUtils.readStr(dataInput));
        this.setAppName(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(Job.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setTimeUnit(BundleJob.Timeunit.valueOf((String)WritableUtils.readStr(dataInput)));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setKickoffTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setStartTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        this.setUser(WritableUtils.readStr(dataInput));
        this.setGroup(WritableUtils.readStr(dataInput));
        this.setExternalId(WritableUtils.readStr(dataInput));
        this.setTimeOut(dataInput.readInt());
    }

    @Override
    public Job.Status getStatus() {
        return Job.Status.valueOf((String)BundleJobBean.pcGetstatus(this));
    }

    public String getStatusStr() {
        return BundleJobBean.pcGetstatus(this);
    }

    @Override
    public Date getEndTime() {
        return DateUtils.toDate(BundleJobBean.pcGetendTimestamp(this));
    }

    @Override
    public Date getKickoffTime() {
        return DateUtils.toDate(BundleJobBean.pcGetkickoffTimestamp(this));
    }

    @Override
    public BundleJob.Timeunit getTimeUnit() {
        return BundleJob.Timeunit.valueOf((String)BundleJobBean.pcGettimeUnitStr(this));
    }

    @Override
    public void setEndTime(Date endTime) {
        super.setEndTime(endTime);
        BundleJobBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    @Override
    public void setKickoffTime(Date kickoffTime) {
        super.setKickoffTime(kickoffTime);
        BundleJobBean.pcSetkickoffTimestamp(this, DateUtils.convertDateToTimestamp(kickoffTime));
    }

    @Override
    public Date getPauseTime() {
        return DateUtils.toDate(BundleJobBean.pcGetpauseTimestamp(this));
    }

    @Override
    public void setPauseTime(Date pauseTime) {
        super.setPauseTime(pauseTime);
        BundleJobBean.pcSetpauseTimestamp(this, DateUtils.convertDateToTimestamp(pauseTime));
    }

    @Override
    public void setStatus(Job.Status val) {
        super.setStatus(val);
        BundleJobBean.pcSetstatus(this, val.toString());
    }

    @Override
    public void setTimeUnit(BundleJob.Timeunit timeUnit) {
        super.setTimeUnit(timeUnit);
        BundleJobBean.pcSettimeUnitStr(this, timeUnit.toString());
    }

    public void setSuspendedTime(Date suspendTime) {
        BundleJobBean.pcSetsuspendedTimestamp(this, DateUtils.convertDateToTimestamp(suspendTime));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonBundleJob != null ? class$Lorg$apache$oozie$client$rest$JsonBundleJob : (class$Lorg$apache$oozie$client$rest$JsonBundleJob = BundleJobBean.class$("org.apache.oozie.client.rest.JsonBundleJob"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"createdTimestamp", "endTimestamp", "jobXml", "kickoffTimestamp", "lastModifiedTimestamp", "origJobXml", "pauseTimestamp", "pending", "startTimestamp", "status", "suspendedTimestamp", "timeUnitStr"};
        Class[] classArray = new Class[12];
        Class clazz2 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[4] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[6] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[7] = Integer.TYPE;
        classArray[8] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[10] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$BundleJobBean != null ? class$Lorg$apache$oozie$BundleJobBean : (class$Lorg$apache$oozie$BundleJobBean = BundleJobBean.class$("org.apache.oozie.BundleJobBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"BundleJobBean", (PersistenceCapable)new BundleJobBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.createdTimestamp = null;
        this.endTimestamp = null;
        this.jobXml = null;
        this.kickoffTimestamp = null;
        this.lastModifiedTimestamp = null;
        this.origJobXml = null;
        this.pauseTimestamp = null;
        this.pending = 0;
        this.startTimestamp = null;
        this.status = null;
        this.suspendedTimestamp = null;
        this.timeUnitStr = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        BundleJobBean bundleJobBean = new BundleJobBean();
        if (bl) {
            bundleJobBean.pcClearFields();
        }
        bundleJobBean.pcStateManager = stateManager;
        bundleJobBean.pcCopyKeyFieldsFromObjectId(object);
        return bundleJobBean;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        BundleJobBean bundleJobBean = new BundleJobBean();
        if (bl) {
            bundleJobBean.pcClearFields();
        }
        bundleJobBean.pcStateManager = stateManager;
        return bundleJobBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 12 + JsonBundleJob.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.jobXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.kickoffTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.origJobXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.pauseTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.suspendedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.timeUnitStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jobXml);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kickoffTimestamp);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.origJobXml);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pauseTimestamp);
                return;
            }
            case 7: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspendedTimestamp);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeUnitStr);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(BundleJobBean bundleJobBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(bundleJobBean, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.createdTimestamp = bundleJobBean.createdTimestamp;
                return;
            }
            case 1: {
                this.endTimestamp = bundleJobBean.endTimestamp;
                return;
            }
            case 2: {
                this.jobXml = bundleJobBean.jobXml;
                return;
            }
            case 3: {
                this.kickoffTimestamp = bundleJobBean.kickoffTimestamp;
                return;
            }
            case 4: {
                this.lastModifiedTimestamp = bundleJobBean.lastModifiedTimestamp;
                return;
            }
            case 5: {
                this.origJobXml = bundleJobBean.origJobXml;
                return;
            }
            case 6: {
                this.pauseTimestamp = bundleJobBean.pauseTimestamp;
                return;
            }
            case 7: {
                this.pending = bundleJobBean.pending;
                return;
            }
            case 8: {
                this.startTimestamp = bundleJobBean.startTimestamp;
                return;
            }
            case 9: {
                this.status = bundleJobBean.status;
                return;
            }
            case 10: {
                this.suspendedTimestamp = bundleJobBean.suspendedTimestamp;
                return;
            }
            case 11: {
                this.timeUnitStr = bundleJobBean.timeUnitStr;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        BundleJobBean bundleJobBean = (BundleJobBean)object;
        if (bundleJobBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(bundleJobBean, nArray[n]);
            ++n;
        }
    }

    private static final Timestamp pcGetcreatedTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 0;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.createdTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 0, (Object)bundleJobBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetendTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 1;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.endTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 1, (Object)bundleJobBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetjobXml(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.jobXml;
        }
        int n = pcInheritedFieldCount + 2;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.jobXml;
    }

    private static final void pcSetjobXml(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.jobXml = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 2, bundleJobBean.jobXml, string, 0);
    }

    private static final Timestamp pcGetkickoffTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.kickoffTimestamp;
        }
        int n = pcInheritedFieldCount + 3;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.kickoffTimestamp;
    }

    private static final void pcSetkickoffTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.kickoffTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 3, (Object)bundleJobBean.kickoffTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.lastModifiedTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 4, (Object)bundleJobBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetorigJobXml(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.origJobXml;
        }
        int n = pcInheritedFieldCount + 5;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.origJobXml;
    }

    private static final void pcSetorigJobXml(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.origJobXml = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 5, bundleJobBean.origJobXml, string, 0);
    }

    private static final Timestamp pcGetpauseTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.pauseTimestamp;
        }
        int n = pcInheritedFieldCount + 6;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.pauseTimestamp;
    }

    private static final void pcSetpauseTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.pauseTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 6, (Object)bundleJobBean.pauseTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.pending;
        }
        int n = pcInheritedFieldCount + 7;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.pending;
    }

    private static final void pcSetpending(BundleJobBean bundleJobBean, int n) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.pending = n;
            return;
        }
        bundleJobBean.pcStateManager.settingIntField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 7, bundleJobBean.pending, n, 0);
    }

    private static final Timestamp pcGetstartTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 8;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.startTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 8, (Object)bundleJobBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatus(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.status;
        }
        int n = pcInheritedFieldCount + 9;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.status;
    }

    private static final void pcSetstatus(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.status = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 9, bundleJobBean.status, string, 0);
    }

    private static final Timestamp pcGetsuspendedTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.suspendedTimestamp;
        }
        int n = pcInheritedFieldCount + 10;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.suspendedTimestamp;
    }

    private static final void pcSetsuspendedTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.suspendedTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 10, (Object)bundleJobBean.suspendedTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGettimeUnitStr(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.timeUnitStr;
        }
        int n = pcInheritedFieldCount + 11;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.timeUnitStr;
    }

    private static final void pcSettimeUnitStr(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.timeUnitStr = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 11, bundleJobBean.timeUnitStr, string, 0);
    }
}

