/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.util.XLog;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class ScriptLanguageActionExecutor
extends JavaActionExecutor {
    public ScriptLanguageActionExecutor(String type) {
        super(type);
    }

    @Override
    protected List<Class> getLauncherClasses() {
        List<Class> classes = super.getLauncherClasses();
        classes.add(LauncherMain.class);
        classes.add(MapReduceMain.class);
        return classes;
    }

    @Override
    protected Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        super.setupLauncherConf(conf, actionXml, appPath, context);
        Namespace ns = actionXml.getNamespace();
        String script = actionXml.getChild("script", ns).getTextTrim();
        String name = new Path(script).getName();
        String scriptContent = context.getProtoActionConf().get(this.getScriptName());
        Path scriptFile = null;
        if (scriptContent != null) {
            FSDataOutputStream dos = null;
            try {
                Path actionPath = context.getActionDir();
                scriptFile = new Path(actionPath, script);
                FileSystem fs = context.getAppFileSystem();
                dos = fs.create(scriptFile);
                dos.writeBytes(scriptContent);
                this.addToCache(conf, actionPath, script + "#" + name, false);
            }
            catch (Exception ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FAILED_OPERATION", XLog.format("Not able to write script file {0} on hdfs", scriptFile), ex);
            }
            finally {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (IOException ex) {
                    XLog.getLog(this.getClass()).error("Error: " + ex.getMessage());
                }
            }
        }
        this.addToCache(conf, appPath, script + "#" + name, false);
        return conf;
    }

    protected abstract String getScriptName();
}

