/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetReadyActionsJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String coordJobId = null;
    private int numResults;
    private String executionOrder = null;

    public CoordJobGetReadyActionsJPAExecutor(String coordJobId, int numResults, String executionOrder) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
        this.numResults = numResults;
        this.executionOrder = executionOrder;
    }

    @Override
    public String getName() {
        return "CoordJobGetReadyActionsJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<CoordinatorActionBean> actionBeans = null;
        try {
            Query q = this.executionOrder.equalsIgnoreCase("FIFO") ? em.createNamedQuery("GET_COORD_ACTIONS_FOR_JOB_FIFO") : em.createNamedQuery("GET_COORD_ACTIONS_FOR_JOB_LIFO");
            q.setParameter("jobId", (Object)this.coordJobId);
            if (this.executionOrder.equalsIgnoreCase("LAST_ONLY")) {
                q.setMaxResults(1);
            } else if (this.numResults > 0) {
                q.setMaxResults(this.numResults);
            }
            List objectArrList = q.getResultList();
            actionBeans = new ArrayList<CoordinatorActionBean>();
            for (Object[] arr : objectArrList) {
                CoordinatorActionBean caa = this.getBeanForCoordinatorActionFromArray(arr);
                actionBeans.add(caa);
            }
            return actionBeans;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private CoordinatorActionBean getBeanForCoordinatorActionFromArray(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setJobId((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            bean.setPending((Integer)arr[3]);
        }
        return bean;
    }
}

