/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordJobsGetPendingJPAExecutor
implements JPAExecutor<List<CoordinatorJobBean>> {
    private int limit;

    public CoordJobsGetPendingJPAExecutor(int limit) {
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "CoordJobsGetPendingJPAExecutor";
    }

    @Override
    public List<CoordinatorJobBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<CoordinatorJobBean> jobList = new ArrayList<CoordinatorJobBean>();
        try {
            Query q = em.createNamedQuery("GET_COORD_JOBS_PENDING");
            if (this.limit > 0) {
                q.setMaxResults(this.limit);
            }
            List coordBeans = q.getResultList();
            for (CoordinatorJobBean j : coordBeans) {
                jobList.add(j);
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return jobList;
    }
}

