/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.oozie.service.Services;

public class AuthFilter
extends AuthenticationFilter {
    private static final String OOZIE_PREFIX = "oozie.authentication.";
    private HttpServlet optionsServlet;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.optionsServlet = new HttpServlet(){};
        this.optionsServlet.init();
    }

    public void destroy() {
        this.optionsServlet.destroy();
        super.destroy();
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
        Properties props = new Properties();
        Configuration conf = Services.get().getConf();
        props.setProperty("cookie.path", "/");
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith(OOZIE_PREFIX)) continue;
            String value = conf.get(name);
            name = name.substring(OOZIE_PREFIX.length());
            props.setProperty(name, value);
        }
        return props;
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain filterChain) throws IOException, ServletException {
        FilterChain filterChainWrapper = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
                if (httpRequest.getMethod().equals("OPTIONS")) {
                    AuthFilter.this.optionsServlet.service(request, response);
                } else {
                    httpRequest.setAttribute("oozie.user.name", (Object)httpRequest.getRemoteUser());
                    filterChain.doFilter(servletRequest, servletResponse);
                }
            }
        };
        super.doFilter(request, response, filterChainWrapper);
    }
}

