/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.ProxyUserService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.HostnameFilter;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class JsonRestServlet
extends HttpServlet {
    private static final String JSTON_UTF8 = "application/json; charset=\"UTF-8\"";
    protected static final String XML_UTF8 = "application/xml; charset=\"UTF-8\"";
    protected static final String TEXT_UTF8 = "text/plain; charset=\"UTF-8\"";
    protected static final String AUDIT_OPERATION = "audit.operation";
    protected static final String AUDIT_PARAM = "audit.param";
    protected static final String AUDIT_ERROR_CODE = "audit.error.code";
    protected static final String AUDIT_ERROR_MESSAGE = "audit.error.message";
    protected static final String AUDIT_HTTP_STATUS_CODE = "audit.http.status.code";
    private XLog auditLog;
    XLog.Info logInfo;
    protected static final String INSTRUMENTATION_GROUP = "webservices";
    private static final String INSTR_TOTAL_REQUESTS_SAMPLER = "requests";
    private static final String INSTR_TOTAL_REQUESTS_COUNTER = "requests";
    private static final String INSTR_TOTAL_FAILED_REQUESTS_COUNTER = "failed";
    private static AtomicLong TOTAL_REQUESTS_SAMPLER_COUNTER;
    private Instrumentation instrumentation;
    private String instrumentationName;
    private AtomicLong samplerCounter = new AtomicLong();
    private ThreadLocal<Instrumentation.Cron> requestCron = new ThreadLocal();
    private List<ResourceInfo> resourcesInfo = new ArrayList<ResourceInfo>();
    private boolean allowSafeModeChanges;
    public static final String AUTH_TOKEN = "oozie.auth.token";
    public static final String USER_NAME = "oozie.user.name";
    protected static final String UNDEF = "?";

    public JsonRestServlet(String instrumentationName, ResourceInfo ... resourcesInfo) {
        this.instrumentationName = ParamChecker.notEmpty(instrumentationName, "instrumentationName");
        if (resourcesInfo.length == 0) {
            throw new IllegalArgumentException("There must be at least one ResourceInfo");
        }
        this.resourcesInfo = Arrays.asList(resourcesInfo);
        this.auditLog = XLog.getLog("oozieaudit");
        this.auditLog.setMsgPrefix("");
        this.logInfo = new XLog.Info(XLog.Info.get());
    }

    protected void setAllowSafeModeChanges(boolean allow) {
        this.allowSafeModeChanges = allow;
    }

    private void defineSampler(String samplerName, final AtomicLong samplerCounter) {
        this.instrumentation.addSampler(INSTRUMENTATION_GROUP, samplerName, 60, 1, new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return samplerCounter.get();
            }
        });
    }

    private void addCron(String name, Instrumentation.Cron cron) {
        this.instrumentation.addCron(INSTRUMENTATION_GROUP, name, cron);
    }

    protected void startCron() {
        this.requestCron.get().start();
    }

    protected void stopCron() {
        this.requestCron.get().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
        Class<JsonRestServlet> clazz = JsonRestServlet.class;
        synchronized (JsonRestServlet.class) {
            if (TOTAL_REQUESTS_SAMPLER_COUNTER == null) {
                TOTAL_REQUESTS_SAMPLER_COUNTER = new AtomicLong();
                this.defineSampler("requests", TOTAL_REQUESTS_SAMPLER_COUNTER);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.defineSampler(this.instrumentationName, this.samplerCounter);
            return;
        }
    }

    private void incrCounter(String name, int count) {
        if (this.instrumentation != null) {
            this.instrumentation.incr(INSTRUMENTATION_GROUP, name, count);
        }
    }

    private void logAuditInfo(HttpServletRequest request) {
        if (request.getAttribute(AUDIT_OPERATION) != null) {
            Integer httpStatusCode = (Integer)request.getAttribute(AUDIT_HTTP_STATUS_CODE);
            httpStatusCode = httpStatusCode != null ? httpStatusCode : 200;
            String status = httpStatusCode == 200 ? "SUCCESS" : "FAILED";
            String operation = (String)request.getAttribute(AUDIT_OPERATION);
            String param = (String)request.getAttribute(AUDIT_PARAM);
            String user = XLog.Info.get().getParameter("USER");
            String group = XLog.Info.get().getParameter("GROUP");
            String jobId = XLog.Info.get().getParameter("JOB");
            String app = XLog.Info.get().getParameter("APP");
            String errorCode = (String)request.getAttribute(AUDIT_ERROR_CODE);
            String errorMessage = (String)request.getAttribute(AUDIT_ERROR_MESSAGE);
            this.auditLog.info("USER [{0}], GROUP [{1}], APP [{2}], JOBID [{3}], OPERATION [{4}], PARAMETER [{5}], STATUS [{6}], HTTPCODE [{7}], ERRORCODE [{8}], ERRORMESSAGE [{9}]", user, group, app, jobId, operation, param, status, httpStatusCode, errorCode, errorMessage);
        }
    }

    protected final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Services.get().getSystemMode() != OozieClient.SYSTEM_MODE.NORMAL && !request.getMethod().equals("GET") && !this.allowSafeModeChanges) {
            this.sendErrorResponse(response, 503, ErrorCode.E0002.toString(), ErrorCode.E0002.getTemplate());
            return;
        }
        Instrumentation.Cron cron = new Instrumentation.Cron();
        this.requestCron.set(cron);
        try {
            cron.start();
            this.validateRestUrl(request.getMethod(), this.getResourceName(request), request.getParameterMap());
            XLog.Info.get().clear();
            String user = this.getUser(request);
            TOTAL_REQUESTS_SAMPLER_COUNTER.incrementAndGet();
            this.samplerCounter.incrementAndGet();
            XLog log = XLog.getLog(((Object)((Object)this)).getClass());
            if (log.isTraceEnabled()) {
                this.logHeaderInfo(request);
            }
            super.service(request, response);
        }
        catch (XServletException ex) {
            XLog log = XLog.getLog(((Object)((Object)this)).getClass());
            log.warn("URL[{0} {1}] error[{2}], {3}", new Object[]{request.getMethod(), this.getRequestUrl(request), ex.getErrorCode(), ex.getMessage(), ex});
            request.setAttribute(AUDIT_ERROR_MESSAGE, (Object)ex.getMessage());
            request.setAttribute(AUDIT_ERROR_CODE, (Object)ex.getErrorCode().toString());
            request.setAttribute(AUDIT_HTTP_STATUS_CODE, (Object)ex.getHttpStatusCode());
            this.incrCounter(INSTR_TOTAL_FAILED_REQUESTS_COUNTER, 1);
            this.sendErrorResponse(response, ex.getHttpStatusCode(), ex.getErrorCode().toString(), ex.getMessage());
        }
        catch (AccessControlException ex) {
            XLog log = XLog.getLog(((Object)((Object)this)).getClass());
            log.error("URL[{0} {1}] error, {2}", request.getMethod(), this.getRequestUrl(request), ex.getMessage(), ex);
            this.incrCounter(INSTR_TOTAL_FAILED_REQUESTS_COUNTER, 1);
            this.sendErrorResponse(response, 401, ErrorCode.E1400.toString(), ex.getMessage());
        }
        catch (RuntimeException ex) {
            XLog log = XLog.getLog(((Object)((Object)this)).getClass());
            log.error("URL[{0} {1}] error, {2}", request.getMethod(), this.getRequestUrl(request), ex.getMessage(), ex);
            this.incrCounter(INSTR_TOTAL_FAILED_REQUESTS_COUNTER, 1);
            throw ex;
        }
        finally {
            this.logAuditInfo(request);
            TOTAL_REQUESTS_SAMPLER_COUNTER.decrementAndGet();
            this.incrCounter("requests", 1);
            this.samplerCounter.decrementAndGet();
            XLog.Info.remove();
            cron.stop();
            this.incrCounter(this.instrumentationName, 1);
            this.incrCounter(this.instrumentationName + "-" + request.getMethod(), 1);
            this.addCron(this.instrumentationName, cron);
            this.addCron(this.instrumentationName + "-" + request.getMethod(), cron);
            this.requestCron.remove();
        }
    }

    private void logHeaderInfo(HttpServletRequest request) {
        XLog log = XLog.getLog(((Object)((Object)this)).getClass());
        StringBuilder traceInfo = new StringBuilder(4096);
        Enumeration names = request.getHeaderNames();
        traceInfo.append("Request URL: ").append(this.getRequestUrl(request)).append("\nRequest Headers:\n");
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            traceInfo.append(name).append(" : ").append(value).append("\n");
        }
        log.trace(traceInfo);
    }

    private String getRequestUrl(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        if (request.getQueryString() != null) {
            url.append(UNDEF).append(request.getQueryString());
        }
        return url.toString();
    }

    protected void sendJsonResponse(HttpServletResponse response, int statusCode, JsonBean bean, String timeZoneId) throws IOException {
        response.setStatus(statusCode);
        JSONObject json = bean.toJSONObject(timeZoneId);
        response.setContentType(JSTON_UTF8);
        json.writeJSONString((Writer)response.getWriter());
    }

    protected void sendErrorResponse(HttpServletResponse response, int statusCode, String error, String message) throws IOException {
        response.setHeader("oozie-error-code", error);
        response.setHeader("oozie-error-message", message);
        response.sendError(statusCode);
    }

    protected void sendJsonResponse(HttpServletResponse response, int statusCode, JSONStreamAware json) throws IOException {
        if (statusCode == 200 || statusCode == 201) {
            response.setStatus(statusCode);
        } else {
            response.sendError(statusCode);
        }
        response.setStatus(statusCode);
        response.setContentType(JSTON_UTF8);
        json.writeJSONString((Writer)response.getWriter());
    }

    protected void validateRestUrl(String method, String resourceName, Map<String, String[]> queryStringParams) throws ServletException {
        if (resourceName.contains("/")) {
            throw new XServletException(400, ErrorCode.E0301, resourceName);
        }
        boolean valid = false;
        for (int i = 0; !valid && i < this.resourcesInfo.size(); ++i) {
            ResourceInfo resourceInfo = this.resourcesInfo.get(i);
            if (!resourceInfo.name.equals(resourceName) && !resourceInfo.wildcard) continue;
            if (!resourceInfo.methods.contains(method)) {
                throw new XServletException(400, ErrorCode.E0301, resourceName);
            }
            for (Map.Entry<String, String[]> entry : queryStringParams.entrySet()) {
                String name = entry.getKey();
                ParameterInfo parameterInfo = (ParameterInfo)resourceInfo.parameters.get(name);
                if (parameterInfo == null) continue;
                if (!parameterInfo.methods.contains(method)) {
                    throw new XServletException(400, ErrorCode.E0302, name);
                }
                String value = entry.getValue()[0].trim();
                if (parameterInfo.type.equals(Boolean.class) && !(value = value.toLowerCase()).equals("true") && !value.equals("false")) {
                    throw new XServletException(400, ErrorCode.E0304, name, "boolean");
                }
                if (!parameterInfo.type.equals(Integer.class)) continue;
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new XServletException(400, ErrorCode.E0304, name, "integer");
                }
            }
            for (ParameterInfo parameterInfo : resourceInfo.parameters.values()) {
                if (!parameterInfo.methods.contains(method) || !parameterInfo.required || queryStringParams.get(parameterInfo.name) != null) continue;
                throw new XServletException(400, ErrorCode.E0305, parameterInfo.name);
            }
            valid = true;
        }
        if (!valid) {
            throw new XServletException(400, ErrorCode.E0301, resourceName);
        }
    }

    protected String getResourceName(HttpServletRequest request) {
        String requestPath = request.getPathInfo();
        if (requestPath != null) {
            while (requestPath.startsWith("/")) {
                requestPath = requestPath.substring(1);
            }
            requestPath = requestPath.trim();
        } else {
            requestPath = "";
        }
        return requestPath;
    }

    protected String getContentType(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            int index = contentType.indexOf(";");
            if (index > -1) {
                contentType = contentType.substring(0, index);
            }
            contentType = contentType.toLowerCase();
        }
        return contentType;
    }

    protected String validateContentType(HttpServletRequest request, String expected) throws XServletException {
        String contentType = this.getContentType(request);
        if (contentType == null || contentType.trim().length() == 0) {
            throw new XServletException(400, ErrorCode.E0300, contentType);
        }
        if (!contentType.equals(expected)) {
            throw new XServletException(400, ErrorCode.E0300, contentType);
        }
        return contentType;
    }

    protected String getUser(HttpServletRequest request) {
        String userName = (String)request.getAttribute(USER_NAME);
        String doAsUserName = request.getParameter("doAs");
        if (doAsUserName != null && !doAsUserName.equals(userName)) {
            ProxyUserService proxyUser = Services.get().get(ProxyUserService.class);
            try {
                proxyUser.validate(userName, HostnameFilter.get(), doAsUserName);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.auditLog.info("Proxy user [{0}] DoAs user [{1}] Request [{2}]", userName, doAsUserName, this.getRequestUrl(request));
            XLog.Info.get().setParameter("USER", userName + " doAs " + doAsUserName);
            userName = doAsUserName;
        } else {
            XLog.Info.get().setParameter("USER", userName);
        }
        return userName != null ? userName : UNDEF;
    }

    protected void setLogInfo(String jobid, String actionid) {
        this.logInfo.setParameter("JOB", jobid);
        this.logInfo.setParameter("ACTION", actionid);
        XLog.Info.get().setParameters(this.logInfo);
    }

    public static class ResourceInfo {
        private String name;
        private boolean wildcard;
        private List<String> methods;
        private Map<String, ParameterInfo> parameters = new HashMap<String, ParameterInfo>();

        public ResourceInfo(String name, List<String> methods, List<ParameterInfo> parameters) {
            this.name = name;
            this.wildcard = name.equals("*");
            for (ParameterInfo parameter : parameters) {
                this.parameters.put(parameter.name, parameter);
            }
            this.methods = ParamChecker.notNull(methods, "methods");
        }
    }

    public static class ParameterInfo {
        private String name;
        private Class type;
        private List<String> methods;
        private boolean required;

        public ParameterInfo(String name, Class type, boolean required, List<String> methods) {
            this.name = ParamChecker.notEmpty(name, "name");
            if (type != Integer.class && type != Boolean.class && type != String.class) {
                throw new IllegalArgumentException("Type must be integer, boolean or string");
            }
            this.type = ParamChecker.notNull(type, "type");
            this.required = required;
            this.methods = ParamChecker.notNull(methods, "methods");
        }
    }
}

