/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.io.NamedPipe;
import com.infobright.io.OSType;
import java.io.IOException;

class WindowsNamedPipe
extends NamedPipe {
    private static final int MAX_RETRIES = 10;
    private static final int TIME_BETWEEN_RETRIES = 200;
    private long handle;

    WindowsNamedPipe(String name) throws IOException {
        super(WindowsNamedPipe.getNativeName(name));
        IOException ioe = null;
        for (int retries = 0; retries < 10; ++retries) {
            try {
                this.handle = WindowsNamedPipe.clientCreate(this.getPipeName());
                return;
            }
            catch (IOException ex) {
                ioe = ex;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        IOException ioe2 = new IOException(ioe.getMessage() + ": Confirm that table engine=brighthouse!!!");
        ioe2.setStackTrace(ioe.getStackTrace());
        throw ioe2;
    }

    WindowsNamedPipe(String name, boolean writeAllowed, boolean readAllowed, int bufsize, long timeout) throws IOException {
        super(WindowsNamedPipe.getNativeName(name));
        String pipeName = WindowsNamedPipe.getNativeName(name);
        this.handle = WindowsNamedPipe.serverCreate(pipeName, writeAllowed, readAllowed, bufsize, timeout);
    }

    static final String getNativeName(String name) {
        return String.format("\\\\.\\pipe\\%s", name);
    }

    public void connect() throws IOException {
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.handle == 0L) {
            throw new IOException("the named pipe has been closed");
        }
        return WindowsNamedPipe.fileRead(this.handle, bytes, offset, length);
    }

    public int write(byte[] bytes, int offset, int length) throws IOException {
        if (this.handle == 0L) {
            throw new IOException("the named pipe has been closed");
        }
        return WindowsNamedPipe.fileWrite(this.handle, bytes, offset, length);
    }

    public void close() throws IOException {
        if (this.handle != 0L) {
            WindowsNamedPipe.fileClose(this.handle);
            this.handle = 0L;
        }
    }

    private static native long serverCreate(String var0, boolean var1, boolean var2, int var3, long var4) throws IOException;

    private static native long clientCreate(String var0) throws IOException;

    private static native int fileRead(long var0, byte[] var2, int var3, int var4) throws IOException;

    private static native int fileWrite(long var0, byte[] var2, int var3, int var4) throws IOException;

    private static native void fileClose(long var0) throws IOException;

    static {
        if (new OSType().isWindows()) {
            UnsatisfiedLinkError error = null;
            try {
                System.loadLibrary("infobright_jni");
            }
            catch (UnsatisfiedLinkError ule) {
                error = ule;
                String[] paths = System.getProperty("java.library.path").split(";");
                String curdir = System.getProperty("user.dir");
                for (String path : paths) {
                    try {
                        if (!path.contains(":\\")) {
                            path = curdir + "/" + path;
                        }
                        System.load(path + "/infobright_jni.dll");
                        error = null;
                        break;
                    }
                    catch (UnsatisfiedLinkError e) {
                    }
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }
}

