/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SimpleSQLReportDataFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.ui.datasources.jdbc.JdbcDataSourceModule;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcPreviewWorker;

public class JdbcQueryDesignerDialog
extends CommonDialog {
    private static final Log log = LogFactory.getLog(JdbcQueryDesignerDialog.class);
    private QueryBuilder queryBuilder;
    private ConnectionProvider connectionProvider;
    private ResourceBundleSupport bundleSupport;
    private DesignTimeContext designTimeContext;

    public JdbcQueryDesignerDialog(JDialog owner, QueryBuilder queryBuilder) {
        super((Dialog)owner);
        if (queryBuilder == null) {
            throw new NullPointerException();
        }
        this.setModal(true);
        this.bundleSupport = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.ui.datasources.jdbc.messages", ObjectUtilities.getClassLoader(JdbcDataSourceModule.class));
        this.setTitle(this.bundleSupport.getString("JdbcDataSourceDialog.SQLLeonardoTitle"));
        this.queryBuilder = queryBuilder;
        this.setDefaultCloseOperation(2);
        this.init();
    }

    protected void performInitialResize() {
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
    }

    protected String getDialogId() {
        return "JdbcDataSourceEditor.QueryDesigner";
    }

    protected Component createContentPane() {
        return this.queryBuilder;
    }

    protected Action[] getExtraActions() {
        return new Action[]{new PreviewButtonAction()};
    }

    public String designQuery(DesignTimeContext designTimeContext, ConnectionProvider jndiSource, String schema, String query) {
        this.designTimeContext = designTimeContext;
        this.connectionProvider = jndiSource;
        try {
            QueryModel queryModel = SQLParser.toQueryModel((String)query);
            this.queryBuilder.setQueryModel(queryModel);
        }
        catch (Exception e1) {
            log.warn((Object)"QueryPanel.actionPerformed ", (Throwable)e1);
        }
        try {
            if (schema != null) {
                QueryModel qm = this.queryBuilder.getQueryModel();
                qm.setSchema(schema);
                this.queryBuilder.setQueryModel(qm);
            }
        }
        catch (Exception e1) {
            log.warn((Object)"QueryPanel.actionPerformed ", (Throwable)e1);
        }
        if (this.performEdit()) {
            return this.getQuery();
        }
        return null;
    }

    protected ConnectionProvider getConnectionDefinition() {
        return this.connectionProvider;
    }

    protected String getQuery() {
        return this.queryBuilder.getQueryModel().toString(true);
    }

    protected ResourceBundleSupport getBundleSupport() {
        return this.bundleSupport;
    }

    private class PreviewButtonAction
    extends AbstractAction {
        private PreviewButtonAction() {
            this.putValue("Name", JdbcQueryDesignerDialog.this.getBundleSupport().getString("JdbcDataSourceDialog.Preview"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            block2: {
                try {
                    String query = JdbcQueryDesignerDialog.this.getQuery();
                    DataPreviewDialog dialog = new DataPreviewDialog((Dialog)((Object)JdbcQueryDesignerDialog.this));
                    dialog.showData((PreviewWorker)new JdbcPreviewWorker((DataFactory)new SimpleSQLReportDataFactory(JdbcQueryDesignerDialog.this.getConnectionDefinition()), query, 0, 0));
                }
                catch (Exception e) {
                    log.warn((Object)"QueryPanel.actionPerformed ", (Throwable)e);
                    if (JdbcQueryDesignerDialog.this.designTimeContext == null) break block2;
                    JdbcQueryDesignerDialog.this.designTimeContext.userError(e);
                }
            }
        }
    }
}

