/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.impl.AbstractSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSchema
extends AbstractSchema {
    protected final Map<String, Table> tableMap;
    protected final Multimap<String, TableFunction> membersMap;
    protected final Map<String, Schema> subSchemaMap;

    public MapSchema(SchemaPlus parentSchema, String name) {
        this(parentSchema, name, new HashMap<String, Table>(), (ListMultimap<String, TableFunction>)LinkedListMultimap.create(), new HashMap<String, Schema>());
    }

    public MapSchema(SchemaPlus parentSchema, String name, Map<String, Table> tableMap, ListMultimap<String, TableFunction> membersMap, Map<String, Schema> subSchemaMap) {
        super(parentSchema, name);
        this.tableMap = tableMap;
        this.membersMap = membersMap;
        this.subSchemaMap = subSchemaMap;
        assert (name != null);
        assert (tableMap != null);
        assert (membersMap != null);
        assert (subSchemaMap != null);
    }

    public void initialize() {
        for (Map.Entry<String, Table> entry : this.initialTables().entrySet()) {
            this.tableMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    @Override
    protected Multimap<String, TableFunction> getTableFunctionMultimap() {
        return this.membersMap;
    }

    @Override
    protected Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMap;
    }

    protected Map<String, Table> initialTables() {
        return ImmutableMap.of();
    }
}

