/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.hydromatic.linq4j.function.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Hook {
    PARSE_TREE,
    JAVA_PLAN,
    CONVERTED,
    EXPRESSION_REDUCER,
    QUERY_PLAN;

    private final List<Function1<Object, Object>> handlers = new CopyOnWriteArrayList<Function1<Object, Object>>();
    private final ThreadLocal<List<Function1<Object, Object>>> threadHandlers = new ThreadLocal<List<Function1<Object, Object>>>(){

        @Override
        protected List<Function1<Object, Object>> initialValue() {
            return new ArrayList<Function1<Object, Object>>();
        }
    };

    public Closeable add(final Function1<Object, Object> handler) {
        this.handlers.add(handler);
        return new Closeable(){

            public void close() {
                Hook.this.remove(handler);
            }
        };
    }

    private boolean remove(Function1 handler) {
        return this.handlers.remove(handler);
    }

    public Closeable addThread(final Function1<Object, Object> handler) {
        this.threadHandlers.get().add(handler);
        return new Closeable(){

            public void close() {
                Hook.this.removeThread(handler);
            }
        };
    }

    private boolean removeThread(Function1 handler) {
        return this.threadHandlers.get().remove(handler);
    }

    public void run(Object arg) {
        for (Function1<Object, Object> handler : this.handlers) {
            handler.apply(arg);
        }
        for (Function1<Object, Object> handler : this.threadHandlers.get()) {
            handler.apply(arg);
        }
    }

    public static interface Closeable {
        public void close();
    }
}

