/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.metadata.RelColumnMapping;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableFunctionRelBase
extends AbstractRelNode {
    private final RexNode rexCall;
    protected final ImmutableList<RelNode> inputs;
    protected final ImmutableSet<RelColumnMapping> columnMappings;

    protected TableFunctionRelBase(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, RexNode rexCall, RelDataType rowType, Set<RelColumnMapping> columnMappings) {
        super(cluster, traits);
        this.rexCall = rexCall;
        this.rowType = rowType;
        this.inputs = ImmutableList.copyOf(inputs);
        this.columnMappings = columnMappings == null ? null : ImmutableSet.copyOf(columnMappings);
    }

    protected TableFunctionRelBase(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs(), input.getExpression("invocation"), input.getRowType("rowType"), (Set<RelColumnMapping>)ImmutableSet.of());
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of((Object)this.rexCall);
    }

    @Override
    public double getRows() {
        if (this.inputs.size() == 0) {
            return super.getRows();
        }
        double nRows = 0.0;
        for (RelNode input : this.inputs) {
            Double d = RelMetadataQuery.getRowCount(input);
            if (d == null) continue;
            nRows += d.doubleValue();
        }
        return nRows;
    }

    public RexNode getCall() {
        return this.rexCall;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("invocation", this.rexCall).item("rowType", this.rowType);
    }

    public Set<RelColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }
}

