/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Set;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;

public class PushJoinThroughUnionRule
extends RelOptRule {
    public static final PushJoinThroughUnionRule LEFT_UNION = new PushJoinThroughUnionRule(PushJoinThroughUnionRule.operand(JoinRel.class, PushJoinThroughUnionRule.operand(UnionRel.class, PushJoinThroughUnionRule.any()), PushJoinThroughUnionRule.operand(RelNode.class, PushJoinThroughUnionRule.any())), "union on left");
    public static final PushJoinThroughUnionRule RIGHT_UNION = new PushJoinThroughUnionRule(PushJoinThroughUnionRule.operand(JoinRel.class, PushJoinThroughUnionRule.operand(RelNode.class, PushJoinThroughUnionRule.any()), PushJoinThroughUnionRule.operand(UnionRel.class, PushJoinThroughUnionRule.any())), "union on right");

    private PushJoinThroughUnionRule(RelOptRuleOperand operand, String id) {
        super(operand, "PushJoinThroughUnionRule: " + id);
    }

    public void onMatch(RelOptRuleCall call) {
        boolean unionOnLeft;
        Object otherInput;
        UnionRel unionRel;
        JoinRel joinRel = (JoinRel)call.rel(0);
        if (call.rel(1) instanceof UnionRel) {
            unionRel = (UnionRel)call.rel(1);
            otherInput = call.rel(2);
            unionOnLeft = true;
        } else {
            otherInput = call.rel(1);
            unionRel = (UnionRel)call.rel(2);
            unionOnLeft = false;
        }
        if (!unionRel.all) {
            return;
        }
        if (!joinRel.getVariablesStopped().isEmpty()) {
            return;
        }
        if (unionOnLeft ? joinRel.getJoinType().generatesNullsOnLeft() : joinRel.getJoinType().generatesNullsOnRight()) {
            return;
        }
        ArrayList<RelNode> newUnionInputs = new ArrayList<RelNode>();
        RelOptCluster cluster = unionRel.getCluster();
        for (RelNode input : unionRel.getInputs()) {
            Object joinRight;
            RelNode joinLeft;
            if (unionOnLeft) {
                joinLeft = input;
                joinRight = otherInput;
            } else {
                joinLeft = otherInput;
                joinRight = input;
            }
            newUnionInputs.add(new JoinRel(cluster, joinLeft, (RelNode)joinRight, joinRel.getCondition(), joinRel.getJoinType(), (Set<String>)ImmutableSet.of()));
        }
        UnionRel newUnionRel = new UnionRel(cluster, newUnionInputs, true);
        call.transformTo(newUnionRel);
    }
}

