/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.hep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.hep.HepInstruction;
import org.eigenbase.relopt.hep.HepMatchOrder;
import org.eigenbase.relopt.hep.HepProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HepProgramBuilder {
    private final List<HepInstruction> instructions = new ArrayList<HepInstruction>();
    private HepInstruction.BeginGroup group;

    private void clear() {
        this.instructions.clear();
        this.group = null;
    }

    public <R extends RelOptRule> HepProgramBuilder addRuleClass(Class<R> ruleClass) {
        HepInstruction.RuleClass instruction = new HepInstruction.RuleClass();
        instruction.ruleClass = ruleClass;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addRuleCollection(Collection<RelOptRule> rules) {
        HepInstruction.RuleCollection instruction = new HepInstruction.RuleCollection();
        instruction.rules = rules;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addRuleInstance(RelOptRule rule) {
        HepInstruction.RuleInstance instruction = new HepInstruction.RuleInstance();
        instruction.rule = rule;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addRuleByDescription(String ruleDescription) {
        HepInstruction.RuleInstance instruction = new HepInstruction.RuleInstance();
        instruction.ruleDescription = ruleDescription;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addGroupBegin() {
        assert (this.group == null);
        HepInstruction.BeginGroup instruction = new HepInstruction.BeginGroup();
        this.instructions.add(instruction);
        this.group = instruction;
        return this;
    }

    public HepProgramBuilder addGroupEnd() {
        assert (this.group != null);
        HepInstruction.EndGroup instruction = new HepInstruction.EndGroup();
        this.instructions.add(instruction);
        this.group.endGroup = instruction;
        this.group = null;
        return this;
    }

    public HepProgramBuilder addConverters(boolean guaranteed) {
        assert (this.group == null);
        HepInstruction.ConverterRules instruction = new HepInstruction.ConverterRules();
        instruction.guaranteed = guaranteed;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addCommonRelSubExprInstruction() {
        assert (this.group == null);
        HepInstruction.CommonRelSubExprRules instruction = new HepInstruction.CommonRelSubExprRules();
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addMatchOrder(HepMatchOrder order) {
        assert (this.group == null);
        HepInstruction.MatchOrder instruction = new HepInstruction.MatchOrder();
        instruction.order = order;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addMatchLimit(int limit) {
        assert (this.group == null);
        HepInstruction.MatchLimit instruction = new HepInstruction.MatchLimit();
        instruction.limit = limit;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgramBuilder addSubprogram(HepProgram program) {
        assert (this.group == null);
        HepInstruction.Subprogram instruction = new HepInstruction.Subprogram();
        instruction.subprogram = program;
        this.instructions.add(instruction);
        return this;
    }

    public HepProgram build() {
        assert (this.group == null);
        HepProgram program = new HepProgram(this.instructions);
        this.clear();
        return program;
    }
}

