/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt.volcano;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.volcano.RelSet;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.relopt.volcano.VolcanoPlanner;
import org.eigenbase.relopt.volcano.VolcanoPlannerPhase;
import org.eigenbase.relopt.volcano.VolcanoRuleMatch;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.ChunkList;
import org.eigenbase.util.Stacks;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleQueue {
    private static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    private static final Set<String> ALL_RULES = ImmutableSet.of((Object)"<ALL RULES>");
    private static final double ONE_MINUS_EPSILON = RuleQueue.computeOneMinusEpsilon();
    final Map<RelSubset, Double> subsetImportances = new HashMap<RelSubset, Double>();
    final Set<RelSubset> boostedSubsets = new HashSet<RelSubset>();
    final Map<VolcanoPlannerPhase, PhaseMatchList> matchListMap = new HashMap<VolcanoPlannerPhase, PhaseMatchList>();
    private final Comparator<VolcanoRuleMatch> ruleMatchImportanceComparator = new RuleMatchImportanceComparator();
    private final VolcanoPlanner planner;
    private final Comparator<RelSubset> relImportanceComparator = new RelImportanceComparator();
    private final Map<VolcanoPlannerPhase, Set<String>> phaseRuleMapping;

    RuleQueue(VolcanoPlanner planner) {
        this.planner = planner;
        this.phaseRuleMapping = new HashMap<VolcanoPlannerPhase, Set<String>>();
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            this.phaseRuleMapping.put(phase, new HashSet());
        }
        planner.getPhaseRuleMappingInitializer().initialize(this.phaseRuleMapping);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            if (this.phaseRuleMapping.get((Object)phase).isEmpty()) {
                this.phaseRuleMapping.put(phase, ALL_RULES);
            }
            PhaseMatchList matchList = new PhaseMatchList(phase);
            this.matchListMap.put(phase, matchList);
        }
    }

    public void phaseCompleted(VolcanoPlannerPhase phase) {
        this.matchListMap.get((Object)phase).clear();
    }

    public double getImportance(RelSet set) {
        double importance = 0.0;
        for (RelSubset subset : set.subsets) {
            importance = Math.max(importance, this.getImportance(subset));
        }
        return importance;
    }

    public void recompute(RelSubset subset, boolean force) {
        Double previousImportance = this.subsetImportances.get(subset);
        if (previousImportance == null) {
            if (!force) {
                return;
            }
            previousImportance = Double.NEGATIVE_INFINITY;
        }
        double importance = this.computeImportance(subset);
        if (previousImportance == importance) {
            return;
        }
        this.updateImportance(subset, importance);
    }

    public void recompute(RelSubset subset) {
        this.recompute(subset, false);
    }

    public void boostImportance(Collection<RelSubset> subsets, double factor) {
        LOGGER.finer("boostImportance(" + factor + ", " + subsets + ")");
        ArrayList<RelSubset> boostRemovals = new ArrayList<RelSubset>();
        Iterator<RelSubset> iter = this.boostedSubsets.iterator();
        while (iter.hasNext()) {
            RelSubset subset = iter.next();
            if (subsets.contains(subset)) continue;
            iter.remove();
            boostRemovals.add(subset);
        }
        Collections.sort(boostRemovals, new Comparator<RelSubset>(){

            @Override
            public int compare(RelSubset o1, RelSubset o2) {
                int o2children;
                int o1children = this.countChildren(o1);
                int c = this.compare(o1children, o2children = this.countChildren(o2));
                if (c == 0) {
                    c = this.compare(o1.getId(), o2.getId());
                }
                return c;
            }

            @Override
            private int compare(int i1, int i2) {
                return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
            }

            private int countChildren(RelSubset subset) {
                int count = 0;
                for (RelNode rel : subset.getRels()) {
                    count += rel.getInputs().size();
                }
                return count;
            }
        });
        for (RelSubset subset : boostRemovals) {
            subset.propagateBoostRemoval(this.planner);
        }
        for (RelSubset subset : subsets) {
            double importance = this.subsetImportances.get(subset);
            this.updateImportance(subset, Math.min(ONE_MINUS_EPSILON, importance * factor));
            subset.boosted = true;
            this.boostedSubsets.add(subset);
        }
    }

    void updateImportance(RelSubset subset, Double importance) {
        this.subsetImportances.put(subset, importance);
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            Multimap<RelSubset, VolcanoRuleMatch> relMatchMap = matchList.matchMap;
            if (!relMatchMap.containsKey((Object)subset)) continue;
            for (VolcanoRuleMatch match : relMatchMap.get((Object)subset)) {
                match.clearCachedImportance();
            }
        }
    }

    double getImportance(RelSubset rel) {
        assert (rel != null);
        double importance = 0.0;
        RelSet set = this.planner.getSet(rel);
        assert (set != null);
        for (RelSubset subset2 : set.subsets) {
            Double d = this.subsetImportances.get(subset2);
            if (d == null) continue;
            double subsetImportance = d;
            if (subset2 != rel) {
                subsetImportance /= 2.0;
            }
            if (!(subsetImportance > importance)) continue;
            importance = subsetImportance;
        }
        return importance;
    }

    void addMatch(VolcanoRuleMatch match) {
        String matchName = match.toString();
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            if (!matchList.names.add(matchName)) continue;
            String ruleClassName = match.getRule().getClass().getSimpleName();
            Set<String> phaseRuleSet = this.phaseRuleMapping.get((Object)matchList.phase);
            if (phaseRuleSet != ALL_RULES && !phaseRuleSet.contains(ruleClassName)) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(matchList.phase.toString() + " Rule-match queued: " + matchName);
            }
            matchList.list.add(match);
            matchList.matchMap.put((Object)this.planner.getSubset(match.rels[0]), (Object)match);
        }
    }

    double computeImportance(RelSubset subset) {
        double importance;
        if (subset == this.planner.root) {
            importance = 1.0;
        } else {
            importance = 0.0;
            for (RelSubset parent : subset.getParentSubsets(this.planner)) {
                double childImportance = this.computeImportanceOfChild(subset, parent);
                importance = Math.max(importance, childImportance);
            }
        }
        LOGGER.finest("Importance of [" + subset + "] is " + importance);
        return importance;
    }

    private void dump() {
        if (LOGGER.isLoggable(Level.FINER)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.dump(pw);
            pw.flush();
            LOGGER.finer(sw.toString());
        }
    }

    private void dump(PrintWriter pw) {
        this.planner.dump(pw);
        pw.print("Importances: {");
        RelSubset[] subsets = this.subsetImportances.keySet().toArray(new RelSubset[this.subsetImportances.keySet().size()]);
        Arrays.sort(subsets, this.relImportanceComparator);
        for (RelSubset subset : subsets) {
            pw.print(" " + subset.toString() + "=" + this.subsetImportances.get(subset));
        }
        pw.println("}");
    }

    VolcanoRuleMatch popMatch(VolcanoPlannerPhase phase) {
        VolcanoRuleMatch match;
        this.dump();
        PhaseMatchList phaseMatchList = this.matchListMap.get((Object)phase);
        if (phaseMatchList == null) {
            throw new AssertionError((Object)("Used match list for phase " + (Object)((Object)phase) + " after phase complete"));
        }
        List<VolcanoRuleMatch> matchList = phaseMatchList.list;
        while (true) {
            if (matchList.isEmpty()) {
                return null;
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                Collections.sort(matchList, this.ruleMatchImportanceComparator);
                match = matchList.remove(0);
                StringBuilder b = new StringBuilder();
                b.append("Sorted rule queue:");
                for (VolcanoRuleMatch match2 : matchList) {
                    double importance = match2.computeImportance();
                    b.append("\n");
                    b.append(match2);
                    b.append(" importance ");
                    b.append(importance);
                }
                LOGGER.finest(b.toString());
            } else {
                match = null;
                int bestPos = -1;
                int i = -1;
                for (VolcanoRuleMatch match2 : matchList) {
                    ++i;
                    if (match != null && this.ruleMatchImportanceComparator.compare(match2, match) >= 0) continue;
                    bestPos = i;
                    match = match2;
                }
                match = matchList.remove(bestPos);
            }
            if (!this.skipMatch(match)) break;
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Skip match: " + match);
        }
        match.recomputeDigest();
        phaseMatchList.matchMap.remove((Object)this.planner.getSubset(match.rels[0]), (Object)match);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Pop match: " + match);
        }
        return match;
    }

    private boolean skipMatch(VolcanoRuleMatch match) {
        for (RelNode rel : match.rels) {
            Double importance = this.planner.relImportances.get(rel);
            if (importance == null || importance != 0.0) continue;
            return true;
        }
        ArrayList<RelSubset> subsets = new ArrayList<RelSubset>();
        try {
            this.checkDuplicateSubsets(subsets, match.rule.getOperand(), match.rels);
        }
        catch (Util.FoundOne e) {
            return true;
        }
        return false;
    }

    private void checkDuplicateSubsets(List<RelSubset> subsets, RelOptRuleOperand operand, RelNode[] rels) {
        RelSubset subset = this.planner.getSubset(rels[operand.ordinalInRule]);
        if (subsets.contains(subset)) {
            throw Util.FoundOne.NULL;
        }
        if (!operand.getChildOperands().isEmpty()) {
            Stacks.push(subsets, subset);
            for (RelOptRuleOperand childOperand : operand.getChildOperands()) {
                this.checkDuplicateSubsets(subsets, childOperand, rels);
            }
            Stacks.pop(subsets, subset);
        }
    }

    private double computeImportanceOfChild(RelSubset child, RelSubset parent) {
        double parentCost;
        double parentImportance = this.getImportance(parent);
        double childCost = this.toDouble(this.planner.getCost(child));
        double alpha = childCost / (parentCost = this.toDouble(this.planner.getCost(parent)));
        if (alpha >= 1.0) {
            alpha = 0.99;
        }
        double importance = parentImportance * alpha;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Importance of [" + child + "] to its parent [" + parent + "] is " + importance + " (parent importance=" + parentImportance + ", child cost=" + childCost + ", parent cost=" + parentCost + ")");
        }
        return importance;
    }

    private double toDouble(RelOptCost cost) {
        if (cost.isInfinite()) {
            return 1.0E30;
        }
        return cost.getCpu() + cost.getRows() + cost.getIo();
    }

    static int compareRels(RelNode[] rels0, RelNode[] rels1) {
        int c = rels0.length - rels1.length;
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < rels0.length; ++i) {
            c = rels0[i].getId() - rels1[i].getId();
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private static double computeOneMinusEpsilon() {
        double d0;
        double d = 0.0;
        do {
            d0 = d;
        } while ((d = (d + 1.0) / 2.0) != 1.0);
        return d0;
    }

    private static class PhaseMatchList {
        final VolcanoPlannerPhase phase;
        final List<VolcanoRuleMatch> list = new ChunkList<VolcanoRuleMatch>();
        final Set<String> names = new HashSet<String>();
        final Multimap<RelSubset, VolcanoRuleMatch> matchMap = HashMultimap.create();

        PhaseMatchList(VolcanoPlannerPhase phase) {
            this.phase = phase;
        }

        void clear() {
            this.list.clear();
            this.names.clear();
            this.matchMap.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuleMatchImportanceComparator
    implements Comparator<VolcanoRuleMatch> {
        private RuleMatchImportanceComparator() {
        }

        @Override
        public int compare(VolcanoRuleMatch match1, VolcanoRuleMatch match2) {
            double imp2;
            double imp1 = match1.getImportance();
            int c = Double.compare(imp1, imp2 = match2.getImportance());
            if (c == 0) {
                c = RuleQueue.compareRels(match1.rels, match2.rels);
            }
            return -c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelImportanceComparator
    implements Comparator<RelSubset> {
        private RelImportanceComparator() {
        }

        @Override
        public int compare(RelSubset rel1, RelSubset rel2) {
            double imp1 = RuleQueue.this.getImportance(rel1);
            double imp2 = RuleQueue.this.getImportance(rel2);
            int c = Double.compare(imp2, imp1);
            if (c == 0) {
                c = rel1.getId() - rel2.getId();
            }
            return c;
        }
    }
}

