/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAsOperator
extends SqlSpecialOperator {
    public SqlAsOperator() {
        super("AS", SqlKind.AS, 20, true, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() >= 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, this.getLeftPrec());
        boolean needsSpace = true;
        writer.setNeedWhitespace(true);
        if (writer.getDialect().allowsAs()) {
            writer.sep("AS");
            writer.setNeedWhitespace(true);
        }
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        if (call.operandCount() > 2) {
            SqlWriter.Frame frame1 = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE, "(", ")");
            for (SqlNode operand : Util.skip(call.getOperandList(), 2)) {
                writer.sep(",", false);
                operand.unparse(writer, 0, 0);
            }
            writer.endList(frame1);
        }
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        assert (operands.get(1) instanceof SqlIdentifier);
        operands.get(0).validateExpr(validator, scope);
        SqlIdentifier id = (SqlIdentifier)operands.get(1);
        if (!id.isSimple()) {
            throw validator.newValidationError(id, EigenbaseResource.instance().AliasMustBeSimpleIdentifier.ex());
        }
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope, (SqlNode)call.operand(0));
        assert (nodeType != null);
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        return call.getOperandList().get(0).getMonotonicity(scope);
    }
}

