/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlWith
extends SqlCall {
    public final SqlNodeList withList;
    public final SqlNode body;

    public SqlWith(SqlParserPos pos, SqlNodeList withList, SqlNode body) {
        super(pos);
        this.withList = withList;
        this.body = body;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.WITH;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlWithOperator.INSTANCE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.withList, (Object)this.body);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateWith(this, scope);
    }

    private static class SqlWithOperator
    extends SqlSpecialOperator {
        private static final SqlWithOperator INSTANCE = new SqlWithOperator();

        private SqlWithOperator() {
            super("WITH", SqlKind.WITH, 2);
        }

        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWith with = (SqlWith)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.WITH, "WITH", "");
            SqlWriter.Frame frame1 = writer.startList("", "");
            for (SqlNode node : with.withList) {
                writer.sep(",");
                node.unparse(writer, 0, 0);
            }
            writer.endList(frame1);
            with.body.unparse(writer, 0, 0);
            writer.endList(frame);
        }

        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            validator.validateWith((SqlWith)call, scope);
        }
    }
}

