/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlSingleOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlItemOperator
extends SqlSpecialOperator {
    private static final SqlSingleOperandTypeChecker ARRAY_OR_MAP = OperandTypes.or(OperandTypes.family(SqlTypeFamily.ARRAY), OperandTypes.family(SqlTypeFamily.MAP), OperandTypes.family(SqlTypeFamily.ANY));

    public SqlItemOperator() {
        super("ITEM", SqlKind.OTHER_FUNCTION, 100, true, null, null, null);
    }

    @Override
    public int reduceExpr(int ordinal, List<Object> list) {
        SqlNode left = (SqlNode)list.get(ordinal - 1);
        SqlNode right = (SqlNode)list.get(ordinal + 1);
        SqlParserUtil.ToTreeListItem treeListItem = (SqlParserUtil.ToTreeListItem)list.get(ordinal);
        SqlParserUtil.replaceSublist(list, ordinal - 1, ordinal + 2, this.createCall(left.getParserPosition().plus(right.getParserPosition()).plus(treeListItem.getPos()), left, right));
        return ordinal - 1;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
        SqlWriter.Frame frame = writer.startList("[", "]");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        Object left = callBinding.getCall().operand(0);
        Object right = callBinding.getCall().operand(1);
        if (!ARRAY_OR_MAP.checkSingleOperandType(callBinding, (SqlNode)left, 0, throwOnFailure)) {
            return false;
        }
        RelDataType operandType = callBinding.getOperandType(0);
        SqlSingleOperandTypeChecker checker = this.getChecker(operandType);
        return checker.checkSingleOperandType(callBinding, (SqlNode)right, 0, throwOnFailure);
    }

    private SqlSingleOperandTypeChecker getChecker(RelDataType operandType) {
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return OperandTypes.family(SqlTypeFamily.INTEGER);
            }
            case MAP: {
                return OperandTypes.family(operandType.getKeyType().getSqlTypeName().getFamily());
            }
            case ANY: {
                return OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.CHARACTER));
            }
        }
        throw new AssertionError((Object)operandType.getSqlTypeName());
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<ARRAY>[<INTEGER>]\n<MAP>[<VALUE>]";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType operandType = opBinding.getOperandType(0);
        switch (operandType.getSqlTypeName()) {
            case ARRAY: {
                return typeFactory.createTypeWithNullability(operandType.getComponentType(), true);
            }
            case MAP: {
                return typeFactory.createTypeWithNullability(operandType.getValueType(), true);
            }
            case ANY: {
                return typeFactory.createSqlType(SqlTypeName.ANY);
            }
        }
        throw new AssertionError();
    }
}

