/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlSingleOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FamilyOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final ImmutableList<SqlTypeFamily> families;

    FamilyOperandTypeChecker(List<SqlTypeFamily> families) {
        this.families = ImmutableList.copyOf(families);
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        SqlTypeFamily family = (SqlTypeFamily)this.families.get(iFormalOperand);
        if (family == SqlTypeFamily.ANY) {
            return true;
        }
        if (SqlUtil.isNullLiteral(node, false)) {
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, EigenbaseResource.instance().NullIllegal.ex());
            }
            return false;
        }
        RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName.getFamily() == SqlTypeFamily.ANY) {
            return true;
        }
        if (!family.getTypeNames().contains((Object)typeName)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.families.size() != callBinding.getOperandCount()) {
            return false;
        }
        for (Ord op : Ord.zip(callBinding.getCall().getOperandList())) {
            if (this.checkSingleOperandType(callBinding, (SqlNode)op.e, op.i, throwOnFailure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.families.size());
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, this.families);
    }
}

