/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSQSAsyncClient
extends AmazonSQSClient
implements AmazonSQSAsync {
    private ExecutorService executorService;

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(final ListQueuesRequest listQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.listQueues(listQueuesRequest);
            }
        });
    }

    @Override
    public Future<Void> setQueueAttributesAsync(final SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.setQueueAttributes(setQueueAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> changeMessageVisibilityAsync(final ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.changeMessageVisibility(changeMessageVisibilityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(final CreateQueueRequest createQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                return AmazonSQSAsyncClient.this.createQueue(createQueueRequest);
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.removePermission(removePermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(final GetQueueAttributesRequest getQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueAttributesResult>(){

            @Override
            public GetQueueAttributesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.getQueueAttributes(getQueueAttributesRequest);
            }
        });
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.addPermission(addPermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteQueueAsync(final DeleteQueueRequest deleteQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.deleteQueue(deleteQueueRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMessageAsync(final DeleteMessageRequest deleteMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.deleteMessage(deleteMessageRequest);
                return null;
            }
        });
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(final SendMessageRequest sendMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageResult>(){

            @Override
            public SendMessageResult call() throws Exception {
                return AmazonSQSAsyncClient.this.sendMessage(sendMessageRequest);
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(final ReceiveMessageRequest receiveMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReceiveMessageResult>(){

            @Override
            public ReceiveMessageResult call() throws Exception {
                return AmazonSQSAsyncClient.this.receiveMessage(receiveMessageRequest);
            }
        });
    }
}

