/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableCounterLong
extends MutableCounter {
    private volatile long value;

    MutableCounterLong(MetricsInfo info, long initValue) {
        super(info);
        this.value = initValue;
    }

    @Override
    public synchronized void incr() {
        ++this.value;
        this.setChanged();
    }

    public synchronized void incr(long delta) {
        this.value += delta;
        this.setChanged();
    }

    public long value() {
        return this.value;
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.info(), this.value);
            this.clearChanged();
        }
    }
}

