/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.tools.configeditor.editor.EditorFactory;
import org.pentaho.reporting.tools.configeditor.editor.ModuleEditor;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.util.VerticalLayout;

public class ConfigEditorPanel
extends JPanel {
    private final JTextArea descriptionArea;
    private final JTextArea moduleNameField;
    private final JTextArea producerField;
    private final MessageFormat moduleNameFormat = new MessageFormat("{0} - Version {1}.{2}-{3}");
    private final JPanel editorArea;
    private ModuleEditor moduleEditor;

    public ConfigEditorPanel() {
        this.moduleNameField = new JTextArea();
        this.moduleNameField.setName("ModuleNameField");
        this.moduleNameField.setMinimumSize(new Dimension(100, 10));
        this.moduleNameField.setEditable(false);
        this.moduleNameField.setLineWrap(false);
        this.moduleNameField.setFont(new Font("SansSerif", 1, this.moduleNameField.getFont().getSize() + 4));
        this.producerField = new JTextArea();
        this.producerField.setName("ProducerField");
        this.producerField.setMinimumSize(new Dimension(100, 10));
        this.producerField.setEditable(false);
        this.producerField.setLineWrap(false);
        this.producerField.setWrapStyleWord(true);
        this.producerField.setFont(this.producerField.getFont().deriveFont(2));
        this.producerField.setBackground(UIManager.getColor("controlLtHighlight"));
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setName("DescriptionArea");
        this.descriptionArea.setMinimumSize(new Dimension(100, 10));
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setBackground(UIManager.getColor("controlShadow"));
        this.editorArea = new JPanel();
        this.editorArea.setLayout(new BorderLayout());
        JPanel contentArea = new JPanel();
        contentArea.setLayout(new VerticalLayout());
        contentArea.add(this.moduleNameField);
        contentArea.add(this.producerField);
        contentArea.add(this.descriptionArea);
        this.setLayout(new BorderLayout());
        this.add((Component)contentArea, "North");
        this.add((Component)this.editorArea, "Center");
    }

    public void editModule(Module module, HierarchicalConfiguration config, ConfigDescriptionEntry[] entries) {
        Object[] params = new Object[]{module.getName(), module.getMajorVersion(), module.getMinorVersion(), module.getPatchLevel()};
        this.moduleNameField.setText(this.moduleNameFormat.format(params));
        this.producerField.setText(module.getProducer());
        this.descriptionArea.setText(module.getDescription());
        this.editorArea.removeAll();
        this.moduleEditor = EditorFactory.getInstance().getModule(module, config, entries);
        if (this.moduleEditor != null) {
            this.editorArea.add(this.moduleEditor.getComponent());
            this.moduleEditor.reset();
        }
        this.invalidate();
    }

    public void reset() {
        if (this.moduleEditor != null) {
            this.moduleEditor.reset();
        }
    }

    public void store() {
        if (this.moduleEditor != null) {
            this.moduleEditor.store();
        }
    }
}

