/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class GetQueryFieldsProgressDialog {
    private static Class<?> PKG = GetQueryFieldsProgressDialog.class;
    private Shell shell;
    private DatabaseMeta dbMeta;
    private String sql;
    private RowMetaInterface result;
    private Database db;

    public GetQueryFieldsProgressDialog(Shell shell, DatabaseMeta dbInfo, String sql) {
        this.shell = shell;
        this.dbMeta = dbInfo;
        this.sql = sql;
    }

    public RowMetaInterface open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                GetQueryFieldsProgressDialog.this.db = new Database(Spoon.loggingObject, GetQueryFieldsProgressDialog.this.dbMeta);
                try {
                    GetQueryFieldsProgressDialog.this.db.connect();
                    GetQueryFieldsProgressDialog.this.result = GetQueryFieldsProgressDialog.this.db.getQueryFields(GetQueryFieldsProgressDialog.this.sql, false);
                    if (monitor.isCanceled()) {
                        throw new InvocationTargetException(new Exception("This operation was cancelled!"));
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Problem encountered determining query fields: " + e.toString());
                }
                finally {
                    GetQueryFieldsProgressDialog.this.db.disconnect();
                }
            }
        };
        try {
            final ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            GetQueryFieldsProgressDialog.this.db.cancelQuery();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        catch (InterruptedException e) {
            this.showErrorDialog(e);
            return null;
        }
        return this.result;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetQueryFieldsProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetQueryFieldsProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

