/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.ui.core.dialog.EnterStringDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;

public class RepositorySecurityUI {
    public static boolean verifyOperations(Shell shell, Repository repository, boolean displayError, RepositoryOperation ... operations) {
        String operationsDesc = "[";
        if (displayError) {
            for (RepositoryOperation operation : operations) {
                if (operationsDesc.length() > 1) {
                    operationsDesc = operationsDesc + ", ";
                }
                operationsDesc = operationsDesc + operation.getDescription();
            }
            operationsDesc = operationsDesc + "]";
        }
        try {
            if (repository == null) {
                return false;
            }
            repository.getSecurityProvider().validateAction(operations);
        }
        catch (KettleException e) {
            KettleRepositoryLostException krle = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
            if (krle != null) {
                throw krle;
            }
            if (displayError) {
                new ErrorDialog(shell, "Security error", "There was a security error performing operations:" + Const.CR + operationsDesc, (Exception)((Object)e));
            }
            return true;
        }
        return false;
    }

    public static boolean verifyOperations(Shell shell, Repository repository, RepositoryOperation ... operations) {
        return RepositorySecurityUI.verifyOperations(shell, repository, true, operations);
    }

    public static String getVersionComment(Shell shell, Repository repository, String operationDescription) {
        if (repository == null) {
            return null;
        }
        RepositorySecurityProvider provider = repository.getSecurityProvider();
        if (provider.allowsVersionComments()) {
            String explanation = "Enter a comment ";
            explanation = provider.isVersionCommentMandatory() ? explanation + "(Mandatory) : " : explanation + ": ";
            String versionComment = "Checked in";
            EnterStringDialog dialog = new EnterStringDialog(shell, versionComment, "Enter comment", explanation);
            dialog.setManditory(provider.isVersionCommentMandatory());
            versionComment = dialog.open();
            return versionComment;
        }
        return null;
    }

    public static boolean showVersionCommentMandatoryDialog(Shell shell) {
        MessageBox box = new MessageBox(shell, 193);
        box.setMessage("Version comments are mandatory for this repository." + Const.CR + "Do you want to enter a comment?");
        box.setText("Version comments are mandatory!");
        return box.open() == 64;
    }
}

