/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.xmloutput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmloutput.XMLField;
import org.pentaho.di.trans.steps.xmloutput.XMLOutputMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class XMLOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = XMLOutputMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wFileTab;
    private CTabItem wContentTab;
    private CTabItem wFieldsTab;
    private FormData fdFileComp;
    private FormData fdContentComp;
    private FormData fdFieldsComp;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Label wlExtension;
    private TextVar wExtension;
    private FormData fdlExtension;
    private FormData fdExtension;
    private Label wlServletOutput;
    private Button wServletOutput;
    private FormData fdlServletOutput;
    private FormData fdServletOutput;
    private Label wlAddStepnr;
    private Button wAddStepnr;
    private FormData fdlAddStepnr;
    private FormData fdAddStepnr;
    private Label wlAddDate;
    private Button wAddDate;
    private FormData fdlAddDate;
    private FormData fdAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private FormData fdlAddTime;
    private FormData fdAddTime;
    private Button wbShowFiles;
    private FormData fdbShowFiles;
    private Label wlZipped;
    private Button wZipped;
    private FormData fdlZipped;
    private FormData fdZipped;
    private Label wlOmitNullValues;
    private Button wOmitNullValues;
    private FormData fdlOmitNullValues;
    private FormData fdOmitNullValues;
    private Label wlEncoding;
    private CCombo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlNameSpace;
    private Text wNameSpace;
    private FormData fdlNameSpace;
    private FormData fdNameSpace;
    private Label wlMainElement;
    private CCombo wMainElement;
    private FormData fdlMainElement;
    private FormData fdMainElement;
    private Label wlRepeatElement;
    private CCombo wRepeatElement;
    private FormData fdlRepeatElement;
    private FormData fdRepeatElement;
    private Label wlSplitEvery;
    private Text wSplitEvery;
    private FormData fdlSplitEvery;
    private FormData fdSplitEvery;
    private TableView wFields;
    private FormData fdFields;
    private XMLOutputMeta input;
    private Button wMinWidth;
    private Listener lsMinWidth;
    private boolean gotEncodings = false;
    private Label wlAddToResult;
    private Button wAddToResult;
    private FormData fdlAddToResult;
    private FormData fdAddToResult;
    private Label wlDoNotOpenNewFileInit;
    private Button wDoNotOpenNewFileInit;
    private FormData fdlDoNotOpenNewFileInit;
    private FormData fdDoNotOpenNewFileInit;
    private Label wlSpecifyFormat;
    private Button wSpecifyFormat;
    private FormData fdlSpecifyFormat;
    private FormData fdSpecifyFormat;
    private Label wlDateTimeFormat;
    private CCombo wDateTimeFormat;
    private FormData fdlDateTimeFormat;
    private FormData fdDateTimeFormat;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;

    public XMLOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (XMLOutputMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wFileTab = new CTabItem(this.wTabFolder, 0);
        this.wFileTab.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.FileTab.Tab", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment(0, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Browse.Button", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment(0, 0);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.top = new FormAttachment(0, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wlDoNotOpenNewFileInit = new Label(wFileComp, 131072);
        this.wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDoNotOpenNewFileInit);
        this.fdlDoNotOpenNewFileInit = new FormData();
        this.fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        this.fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        this.wlDoNotOpenNewFileInit.setLayoutData((Object)this.fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button(wFileComp, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDoNotOpenNewFileInit);
        this.fdDoNotOpenNewFileInit = new FormData();
        this.fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        this.fdDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)this.fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        });
        this.wlServletOutput = new Label(wFileComp, 131072);
        this.wlServletOutput.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ServletOutput.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlServletOutput);
        this.fdlServletOutput = new FormData();
        this.fdlServletOutput.left = new FormAttachment(0, 0);
        this.fdlServletOutput.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdlServletOutput.right = new FormAttachment(middle, -margin);
        this.wlServletOutput.setLayoutData((Object)this.fdlServletOutput);
        this.wServletOutput = new Button(wFileComp, 32);
        this.wServletOutput.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ServletOutput.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServletOutput);
        this.fdServletOutput = new FormData();
        this.fdServletOutput.left = new FormAttachment(middle, 0);
        this.fdServletOutput.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdServletOutput.right = new FormAttachment(100, 0);
        this.wServletOutput.setLayoutData((Object)this.fdServletOutput);
        this.wServletOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
                XMLOutputDialog.this.setFlagsServletOption();
            }
        });
        this.wlExtension = new Label(wFileComp, 131072);
        this.wlExtension.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Extension.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlExtension);
        this.fdlExtension = new FormData();
        this.fdlExtension.left = new FormAttachment(0, 0);
        this.fdlExtension.top = new FormAttachment((Control)this.wServletOutput, margin);
        this.fdlExtension.right = new FormAttachment(middle, -margin);
        this.wlExtension.setLayoutData((Object)this.fdlExtension);
        this.wExtension = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.wExtension.setText("");
        this.props.setLook((Control)this.wExtension);
        this.wExtension.addModifyListener(lsMod);
        this.fdExtension = new FormData();
        this.fdExtension.left = new FormAttachment(middle, 0);
        this.fdExtension.top = new FormAttachment((Control)this.wServletOutput, margin);
        this.fdExtension.right = new FormAttachment(100, 0);
        this.wExtension.setLayoutData(this.fdExtension);
        this.wlAddStepnr = new Label(wFileComp, 131072);
        this.wlAddStepnr.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddStepNr.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddStepnr);
        this.fdlAddStepnr = new FormData();
        this.fdlAddStepnr.left = new FormAttachment(0, 0);
        this.fdlAddStepnr.top = new FormAttachment((Control)this.wExtension, margin);
        this.fdlAddStepnr.right = new FormAttachment(middle, -margin);
        this.wlAddStepnr.setLayoutData((Object)this.fdlAddStepnr);
        this.wAddStepnr = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddStepnr);
        this.fdAddStepnr = new FormData();
        this.fdAddStepnr.left = new FormAttachment(middle, 0);
        this.fdAddStepnr.top = new FormAttachment((Control)this.wExtension, margin);
        this.fdAddStepnr.right = new FormAttachment(100, 0);
        this.wAddStepnr.setLayoutData((Object)this.fdAddStepnr);
        this.wAddStepnr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddDate = new Label(wFileComp, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddDate);
        this.fdlAddDate = new FormData();
        this.fdlAddDate.left = new FormAttachment(0, 0);
        this.fdlAddDate.top = new FormAttachment((Control)this.wAddStepnr, margin);
        this.fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)this.fdlAddDate);
        this.wAddDate = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddDate);
        this.fdAddDate = new FormData();
        this.fdAddDate.left = new FormAttachment(middle, 0);
        this.fdAddDate.top = new FormAttachment((Control)this.wAddStepnr, margin);
        this.fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)this.fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddTime = new Label(wFileComp, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTime);
        this.fdlAddTime = new FormData();
        this.fdlAddTime.left = new FormAttachment(0, 0);
        this.fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        this.fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)this.fdlAddTime);
        this.wAddTime = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddTime);
        this.fdAddTime = new FormData();
        this.fdAddTime.left = new FormAttachment(middle, 0);
        this.fdAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        this.fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)this.fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        });
        this.wlSpecifyFormat = new Label(wFileComp, 131072);
        this.wlSpecifyFormat.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.SpecifyFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSpecifyFormat);
        this.fdlSpecifyFormat = new FormData();
        this.fdlSpecifyFormat.left = new FormAttachment(0, 0);
        this.fdlSpecifyFormat.top = new FormAttachment((Control)this.wAddTime, margin);
        this.fdlSpecifyFormat.right = new FormAttachment(middle, -margin);
        this.wlSpecifyFormat.setLayoutData((Object)this.fdlSpecifyFormat);
        this.wSpecifyFormat = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wSpecifyFormat);
        this.wSpecifyFormat.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.SpecifyFormat.Tooltip", (String[])new String[0]));
        this.fdSpecifyFormat = new FormData();
        this.fdSpecifyFormat.left = new FormAttachment(middle, 0);
        this.fdSpecifyFormat.top = new FormAttachment((Control)this.wAddTime, margin);
        this.fdSpecifyFormat.right = new FormAttachment(100, 0);
        this.wSpecifyFormat.setLayoutData((Object)this.fdSpecifyFormat);
        this.wSpecifyFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
                XMLOutputDialog.this.setDateTimeFormat();
            }
        });
        String[] dats = Const.getDateFormats();
        this.wlDateTimeFormat = new Label(wFileComp, 131072);
        this.wlDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.DateTimeFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDateTimeFormat);
        this.fdlDateTimeFormat = new FormData();
        this.fdlDateTimeFormat.left = new FormAttachment(0, 0);
        this.fdlDateTimeFormat.top = new FormAttachment((Control)this.wSpecifyFormat, margin);
        this.fdlDateTimeFormat.right = new FormAttachment(middle, -margin);
        this.wlDateTimeFormat.setLayoutData((Object)this.fdlDateTimeFormat);
        this.wDateTimeFormat = new CCombo(wFileComp, 2056);
        this.wDateTimeFormat.setEditable(true);
        this.props.setLook((Control)this.wDateTimeFormat);
        this.wDateTimeFormat.addModifyListener(lsMod);
        this.fdDateTimeFormat = new FormData();
        this.fdDateTimeFormat.left = new FormAttachment(middle, 0);
        this.fdDateTimeFormat.top = new FormAttachment((Control)this.wSpecifyFormat, margin);
        this.fdDateTimeFormat.right = new FormAttachment(100, 0);
        this.wDateTimeFormat.setLayoutData((Object)this.fdDateTimeFormat);
        for (int x2 = 0; x2 < dats.length; ++x2) {
            this.wDateTimeFormat.add(dats[x2]);
        }
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ShowFiles.Button", (String[])new String[0]));
        this.fdbShowFiles = new FormData();
        this.fdbShowFiles.left = new FormAttachment(middle, 0);
        this.fdbShowFiles.top = new FormAttachment((Control)this.wDateTimeFormat, margin * 2);
        this.wbShowFiles.setLayoutData((Object)this.fdbShowFiles);
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputMeta tfoi = new XMLOutputMeta();
                XMLOutputDialog.this.getInfo(tfoi);
                String[] files = tfoi.getFiles((VariableSpace)XMLOutputDialog.this.transMeta);
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(XMLOutputDialog.this.shell, files, BaseMessages.getString((Class)PKG, (String)"XMLOutputDialog.OutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"XMLOutputDialog.OutputFiles.DialogMessage", (String[])new String[0]));
                    esd.setViewOnly();
                    esd.open();
                } else {
                    MessageBox mb = new MessageBox(XMLOutputDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString((Class)PKG, (String)"XMLOutputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        this.wlAddToResult = new Label(wFileComp, 131072);
        this.wlAddToResult.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddToResult);
        this.fdlAddToResult = new FormData();
        this.fdlAddToResult.left = new FormAttachment(0, 0);
        this.fdlAddToResult.top = new FormAttachment((Control)this.wbShowFiles, 2 * margin);
        this.fdlAddToResult.right = new FormAttachment(middle, -margin);
        this.wlAddToResult.setLayoutData((Object)this.fdlAddToResult);
        this.wAddToResult = new Button(wFileComp, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        this.fdAddToResult = new FormData();
        this.fdAddToResult.left = new FormAttachment(middle, 0);
        this.fdAddToResult.top = new FormAttachment((Control)this.wbShowFiles, 2 * margin);
        this.fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)this.fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XMLOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        this.fdFileComp = new FormData();
        this.fdFileComp.left = new FormAttachment(0, 0);
        this.fdFileComp.top = new FormAttachment(0, 0);
        this.fdFileComp.right = new FormAttachment(100, 0);
        this.fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)this.fdFileComp);
        wFileComp.layout();
        this.wFileTab.setControl((Control)wFileComp);
        this.wContentTab = new CTabItem(this.wTabFolder, 0);
        this.wContentTab.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        this.wlZipped = new Label(wContentComp, 131072);
        this.wlZipped.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Zipped.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlZipped);
        this.fdlZipped = new FormData();
        this.fdlZipped.left = new FormAttachment(0, 0);
        this.fdlZipped.top = new FormAttachment(0, 0);
        this.fdlZipped.right = new FormAttachment(middle, -margin);
        this.wlZipped.setLayoutData((Object)this.fdlZipped);
        this.wZipped = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wZipped);
        this.fdZipped = new FormData();
        this.fdZipped.left = new FormAttachment(middle, 0);
        this.fdZipped.top = new FormAttachment(0, 0);
        this.fdZipped.right = new FormAttachment(100, 0);
        this.wZipped.setLayoutData((Object)this.fdZipped);
        this.wZipped.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        });
        this.wlEncoding = new Label(wContentComp, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment((Control)this.wZipped, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment((Control)this.wZipped, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)XMLOutputDialog.this.shell.getDisplay(), 1);
                XMLOutputDialog.this.shell.setCursor(busy);
                XMLOutputDialog.this.setEncodings();
                XMLOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlNameSpace = new Label(wContentComp, 131072);
        this.wlNameSpace.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.NameSpace.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNameSpace);
        this.fdlNameSpace = new FormData();
        this.fdlNameSpace.left = new FormAttachment(0, 0);
        this.fdlNameSpace.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdlNameSpace.right = new FormAttachment(middle, -margin);
        this.wlNameSpace.setLayoutData((Object)this.fdlNameSpace);
        this.wNameSpace = new Text(wContentComp, 18436);
        this.props.setLook((Control)this.wNameSpace);
        this.wNameSpace.addModifyListener(lsMod);
        this.fdNameSpace = new FormData();
        this.fdNameSpace.left = new FormAttachment(middle, 0);
        this.fdNameSpace.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdNameSpace.right = new FormAttachment(100, 0);
        this.wNameSpace.setLayoutData((Object)this.fdNameSpace);
        this.wlMainElement = new Label(wContentComp, 131072);
        this.wlMainElement.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.MainElement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMainElement);
        this.fdlMainElement = new FormData();
        this.fdlMainElement.left = new FormAttachment(0, 0);
        this.fdlMainElement.top = new FormAttachment((Control)this.wNameSpace, margin);
        this.fdlMainElement.right = new FormAttachment(middle, -margin);
        this.wlMainElement.setLayoutData((Object)this.fdlMainElement);
        this.wMainElement = new CCombo(wContentComp, 2056);
        this.wMainElement.setEditable(true);
        this.props.setLook((Control)this.wMainElement);
        this.wMainElement.addModifyListener(lsMod);
        this.fdMainElement = new FormData();
        this.fdMainElement.left = new FormAttachment(middle, 0);
        this.fdMainElement.top = new FormAttachment((Control)this.wNameSpace, margin);
        this.fdMainElement.right = new FormAttachment(100, 0);
        this.wMainElement.setLayoutData((Object)this.fdMainElement);
        this.wlRepeatElement = new Label(wContentComp, 131072);
        this.wlRepeatElement.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.RepeatElement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRepeatElement);
        this.fdlRepeatElement = new FormData();
        this.fdlRepeatElement.left = new FormAttachment(0, 0);
        this.fdlRepeatElement.top = new FormAttachment((Control)this.wMainElement, margin);
        this.fdlRepeatElement.right = new FormAttachment(middle, -margin);
        this.wlRepeatElement.setLayoutData((Object)this.fdlRepeatElement);
        this.wRepeatElement = new CCombo(wContentComp, 2056);
        this.wRepeatElement.setEditable(true);
        this.props.setLook((Control)this.wRepeatElement);
        this.wRepeatElement.addModifyListener(lsMod);
        this.fdRepeatElement = new FormData();
        this.fdRepeatElement.left = new FormAttachment(middle, 0);
        this.fdRepeatElement.top = new FormAttachment((Control)this.wMainElement, margin);
        this.fdRepeatElement.right = new FormAttachment(100, 0);
        this.wRepeatElement.setLayoutData((Object)this.fdRepeatElement);
        this.wlSplitEvery = new Label(wContentComp, 131072);
        this.wlSplitEvery.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.SplitEvery.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSplitEvery);
        this.fdlSplitEvery = new FormData();
        this.fdlSplitEvery.left = new FormAttachment(0, 0);
        this.fdlSplitEvery.top = new FormAttachment((Control)this.wRepeatElement, margin);
        this.fdlSplitEvery.right = new FormAttachment(middle, -margin);
        this.wlSplitEvery.setLayoutData((Object)this.fdlSplitEvery);
        this.wSplitEvery = new Text(wContentComp, 18436);
        this.props.setLook((Control)this.wSplitEvery);
        this.wSplitEvery.addModifyListener(lsMod);
        this.fdSplitEvery = new FormData();
        this.fdSplitEvery.left = new FormAttachment(middle, 0);
        this.fdSplitEvery.top = new FormAttachment((Control)this.wRepeatElement, margin);
        this.fdSplitEvery.right = new FormAttachment(100, 0);
        this.wSplitEvery.setLayoutData((Object)this.fdSplitEvery);
        this.wlOmitNullValues = new Label(wContentComp, 131072);
        this.wlOmitNullValues.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.OmitNullValues.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOmitNullValues);
        this.fdlOmitNullValues = new FormData();
        this.fdlOmitNullValues.left = new FormAttachment(0, 0);
        this.fdlOmitNullValues.top = new FormAttachment((Control)this.wSplitEvery, margin);
        this.fdlOmitNullValues.right = new FormAttachment(middle, -margin);
        this.wlOmitNullValues.setLayoutData((Object)this.fdlOmitNullValues);
        this.wOmitNullValues = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wOmitNullValues);
        this.fdOmitNullValues = new FormData();
        this.fdOmitNullValues.left = new FormAttachment(middle, 0);
        this.fdOmitNullValues.top = new FormAttachment((Control)this.wSplitEvery, margin);
        this.fdOmitNullValues.right = new FormAttachment(100, 0);
        this.wOmitNullValues.setLayoutData((Object)this.fdOmitNullValues);
        this.wOmitNullValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLOutputDialog.this.input.setChanged();
            }
        });
        this.fdContentComp = new FormData();
        this.fdContentComp.left = new FormAttachment(0, 0);
        this.fdContentComp.top = new FormAttachment(0, 0);
        this.fdContentComp.right = new FormAttachment(100, 0);
        this.fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)this.fdContentComp);
        wContentComp.layout();
        this.wContentTab.setControl((Control)wContentComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Get.Button", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Get.Tooltip", (String[])new String[0]));
        this.wMinWidth = new Button(wFieldsComp, 8);
        this.wMinWidth.setText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.MinWidth.Label", (String[])new String[0]));
        this.wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"XMLOutputDialog.MinWidth.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet, this.wMinWidth}, margin, null);
        int FieldsRows = this.input.getOutputFields().length;
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ElementName.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.ContentType.Column", (String[])new String[0]), 2, new String[]{"Element", "Attribute"}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Type.Column", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Format.Column", (String[])new String[0]), 2, formats), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Null.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = XMLOutputDialog.this.transMeta.findStep(XMLOutputDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = XMLOutputDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            XMLOutputDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        XMLOutputDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        XMLOutputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                XMLOutputDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                XMLOutputDialog.this.get();
            }
        };
        this.lsMinWidth = new Listener(){

            public void handleEvent(Event e) {
                XMLOutputDialog.this.setMinimalWidth();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                XMLOutputDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wMinWidth.addListener(13, this.lsMinWidth);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XMLOutputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLOutputDialog.this.wFilename.setToolTipText(XMLOutputDialog.this.transMeta.environmentSubstitute(XMLOutputDialog.this.wFilename.getText()));
            }
        });
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XMLOutputDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.xml", "*.txt", "*.csv", "*"});
                if (XMLOutputDialog.this.wFilename.getText() != null) {
                    dialog.setFileName(XMLOutputDialog.this.transMeta.environmentSubstitute(XMLOutputDialog.this.wFilename.getText()));
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.XMLFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    XMLOutputDialog.this.wFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                XMLOutputDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = XMLOutputDialog.this.shell.getSize();
                XMLOutputDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((XMLOutputDialog)XMLOutputDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                XMLOutputDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.setDateTimeFormat();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setFlagsServletOption() {
        boolean enableFilename = !this.wServletOutput.getSelection();
        this.wlFilename.setEnabled(enableFilename);
        this.wFilename.setEnabled(enableFilename);
        this.wlDoNotOpenNewFileInit.setEnabled(enableFilename);
        this.wDoNotOpenNewFileInit.setEnabled(enableFilename);
        this.wlExtension.setEnabled(enableFilename);
        this.wExtension.setEnabled(enableFilename);
        this.wlSplitEvery.setEnabled(enableFilename);
        this.wSplitEvery.setEnabled(enableFilename);
        this.wlAddDate.setEnabled(enableFilename);
        this.wAddDate.setEnabled(enableFilename);
        this.wlAddTime.setEnabled(enableFilename);
        this.wAddTime.setEnabled(enableFilename);
        this.wlDateTimeFormat.setEnabled(enableFilename);
        this.wDateTimeFormat.setEnabled(enableFilename);
        this.wlSpecifyFormat.setEnabled(enableFilename);
        this.wSpecifyFormat.setEnabled(enableFilename);
        this.wlAddStepnr.setEnabled(enableFilename);
        this.wAddStepnr.setEnabled(enableFilename);
        this.wbShowFiles.setEnabled(enableFilename);
        this.wlAddToResult.setEnabled(enableFilename);
        this.wAddToResult.setEnabled(enableFilename);
    }

    private void setDateTimeFormat() {
        if (this.wSpecifyFormat.getSelection()) {
            this.wAddDate.setSelection(false);
            this.wAddTime.setSelection(false);
        }
        this.wDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wlDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wAddDate.setEnabled(!this.wSpecifyFormat.getSelection() && !this.wServletOutput.getSelection());
        this.wlAddDate.setEnabled(!this.wSpecifyFormat.getSelection() && !this.wServletOutput.getSelection());
        this.wAddTime.setEnabled(!this.wSpecifyFormat.getSelection() && !this.wServletOutput.getSelection());
        this.wlAddTime.setEnabled(!this.wSpecifyFormat.getSelection() && !this.wServletOutput.getSelection());
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void getData() {
        if (this.input.getFileName() != null) {
            this.wFilename.setText(this.input.getFileName());
        }
        if (this.input.getExtension() != null) {
            this.wExtension.setText(this.input.getExtension());
        }
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        this.wServletOutput.setSelection(this.input.isServletOutput());
        this.setFlagsServletOption();
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getNameSpace() != null) {
            this.wNameSpace.setText(this.input.getNameSpace());
        }
        if (this.input.getMainElement() != null) {
            this.wMainElement.setText(this.input.getMainElement());
        }
        if (this.input.getRepeatElement() != null) {
            this.wRepeatElement.setText(this.input.getRepeatElement());
        }
        this.wSplitEvery.setText("" + this.input.getSplitEvery());
        this.wZipped.setSelection(this.input.isZipped());
        this.wOmitNullValues.setSelection(this.input.isOmitNullValues());
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wAddStepnr.setSelection(this.input.isStepNrInFilename());
        this.wAddToResult.setSelection(this.input.isAddToResultFiles());
        if (this.input.getDateTimeFormat() != null) {
            this.wDateTimeFormat.setText(this.input.getDateTimeFormat());
        }
        this.wSpecifyFormat.setSelection(this.input.isSpecifyFormat());
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"XMLOutputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            XMLField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            int index = 1;
            if (field.getFieldName() != null) {
                item.setText(index++, field.getFieldName());
            }
            if (field.getElementName() != null) {
                item.setText(index++, field.getElementName());
            } else if (field.getFieldName() != null) {
                item.setText(index++, field.getFieldName());
            }
            int n = ++index;
            item.setText(n, field.getContentType().name());
            int n2 = ++index;
            ++index;
            item.setText(n2, field.getTypeDesc());
            if (field.getFormat() != null) {
                item.setText(index++, field.getFormat());
            } else {
                ++index;
            }
            if (field.getLength() >= 0) {
                item.setText(index++, "" + field.getLength());
            } else {
                ++index;
            }
            if (field.getPrecision() >= 0) {
                item.setText(index++, "" + field.getPrecision());
            } else {
                ++index;
            }
            if (field.getCurrencySymbol() != null) {
                item.setText(index++, field.getCurrencySymbol());
            } else {
                ++index;
            }
            if (field.getDecimalSymbol() != null) {
                item.setText(index++, field.getDecimalSymbol());
            } else {
                ++index;
            }
            if (field.getGroupingSymbol() != null) {
                item.setText(index++, field.getGroupingSymbol());
            } else {
                ++index;
            }
            if (field.getNullString() != null) {
                item.setText(index++, field.getNullString());
                continue;
            }
            ++index;
        }
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(XMLOutputMeta xmlOutputMeta) {
        xmlOutputMeta.setFileName(this.wFilename.getText());
        xmlOutputMeta.setEncoding(this.wEncoding.getText());
        xmlOutputMeta.setNameSpace(this.wNameSpace.getText());
        xmlOutputMeta.setMainElement(this.wMainElement.getText());
        xmlOutputMeta.setRepeatElement(this.wRepeatElement.getText());
        xmlOutputMeta.setExtension(this.wExtension.getText());
        xmlOutputMeta.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
        xmlOutputMeta.setServletOutput(this.wServletOutput.getSelection());
        xmlOutputMeta.setSplitEvery(Const.toInt((String)this.wSplitEvery.getText(), (int)0));
        xmlOutputMeta.setDateTimeFormat(this.wDateTimeFormat.getText());
        xmlOutputMeta.setSpecifyFormat(this.wSpecifyFormat.getSelection());
        xmlOutputMeta.setStepNrInFilename(this.wAddStepnr.getSelection());
        xmlOutputMeta.setDateInFilename(this.wAddDate.getSelection());
        xmlOutputMeta.setTimeInFilename(this.wAddTime.getSelection());
        xmlOutputMeta.setAddToResultFiles(this.wAddToResult.getSelection());
        xmlOutputMeta.setZipped(this.wZipped.getSelection());
        xmlOutputMeta.setOmitNullValues(this.wOmitNullValues.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        xmlOutputMeta.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            XMLField field = new XMLField();
            TableItem item = this.wFields.getNonEmpty(i);
            int index = 1;
            field.setFieldName(item.getText(index++));
            field.setElementName(item.getText(index++));
            if (field.getFieldName().equals(field.getElementName())) {
                field.setElementName("");
            }
            field.setContentType(XMLField.ContentType.valueOf((String)item.getText(index++)));
            field.setType(item.getText(index++));
            field.setFormat(item.getText(index++));
            field.setLength(Const.toInt((String)item.getText(index++), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(index++), (int)-1));
            field.setCurrencySymbol(item.getText(index++));
            field.setDecimalSymbol(item.getText(index++));
            field.setGroupingSymbol(item.getText(index++));
            field.setNullString(item.getText(index++));
            xmlOutputMeta.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.isNumber() && v.getLength() > 0) {
                            int m;
                            int le = v.getLength();
                            int pr = v.getPrecision();
                            if (v.getPrecision() <= 0) {
                                pr = 0;
                            }
                            String mask = " ";
                            for (m = 0; m < le - pr; ++m) {
                                mask = mask + "0";
                            }
                            if (pr > 0) {
                                mask = mask + ".";
                            }
                            for (m = 0; m < pr; ++m) {
                                mask = mask + "0";
                            }
                            tableItem.setText(4, mask);
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[]{4}, 6, 7, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(5, "");
            item.setText(6, "");
            int type = ValueMeta.getType((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(4, "");
                    continue block6;
                }
                case 5: {
                    item.setText(4, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(4, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        this.wFields.optWidth(true);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }
}

