/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jets3t.service.model.S3Owner;

public abstract class BaseS3Object
implements Serializable {
    private Map metadata = new HashMap();

    public Map getMetadataMap() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Object getMetadata(String name) {
        return this.metadata.get(name);
    }

    public boolean containsMetadata(String name) {
        return this.metadata.keySet().contains(name);
    }

    public void addMetadata(String name, String value) {
        this.metadata.put(name, value);
    }

    public void addMetadata(String name, Date value) {
        this.metadata.put(name, value);
    }

    public void addMetadata(String name, S3Owner value) {
        this.metadata.put(name, value);
    }

    public void addAllMetadata(Map metadata) {
        this.metadata.putAll(metadata);
    }

    public void removeMetadata(String name) {
        this.metadata.remove(name);
    }

    public void replaceAllMetadata(Map metadata) {
        this.metadata.clear();
        this.addAllMetadata(metadata);
    }
}

