/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Times {
    static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("d-MMM-yyyy HH:mm:ss");
        }
    };

    public static long elapsed(long started, long finished) {
        return Times.elapsed(started, finished, true);
    }

    public static long elapsed(long started, long finished, boolean isRunning) {
        if (finished > 0L && started > 0L) {
            return finished - started;
        }
        if (isRunning) {
            return started > 0L ? System.currentTimeMillis() - started : 0L;
        }
        return -1L;
    }

    public static String format(long ts) {
        return ts > 0L ? String.valueOf(dateFormat.get().format(new Date(ts))) : "N/A";
    }
}

