/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jHierarchy;
import mondrian.olap4j.MondrianOlap4jLevel;
import mondrian.olap4j.MondrianOlap4jMember;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.olap4j.MondrianOlap4jSchema;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCube
extends MondrianOlap4jMetadataElement
implements org.olap4j.metadata.Cube,
Named {
    final Cube cube;
    final MondrianOlap4jSchema olap4jSchema;

    MondrianOlap4jCube(Cube cube, MondrianOlap4jSchema olap4jSchema) {
        this.cube = cube;
        this.olap4jSchema = olap4jSchema;
    }

    public Schema getSchema() {
        return this.olap4jSchema;
    }

    public int hashCode() {
        return this.olap4jSchema.hashCode() ^ this.cube.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MondrianOlap4jCube) {
            MondrianOlap4jCube that = (MondrianOlap4jCube)obj;
            return this.olap4jSchema == that.olap4jSchema && this.cube.equals(that.cube);
        }
        return false;
    }

    public NamedList<org.olap4j.metadata.Dimension> getDimensions() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        SchemaReader schemaReader = olap4jConnection.getMondrianConnection2().getSchemaReader().withLocus();
        for (Dimension dimension : schemaReader.getCubeDimensions(this.cube)) {
            list.add((Object)new MondrianOlap4jDimension(this.olap4jSchema, dimension));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public NamedList<org.olap4j.metadata.Hierarchy> getHierarchies() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        SchemaReader schemaReader = olap4jConnection.getMondrianConnection2().getSchemaReader().withLocus();
        for (Dimension dimension : schemaReader.getCubeDimensions(this.cube)) {
            for (Hierarchy hierarchy : schemaReader.getDimensionHierarchies(dimension)) {
                list.add((Object)new MondrianOlap4jHierarchy(this.olap4jSchema, hierarchy));
            }
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public List<Measure> getMeasures() {
        org.olap4j.metadata.Dimension dimension = (org.olap4j.metadata.Dimension)this.getDimensions().get("Measures");
        if (dimension == null) {
            return Collections.emptyList();
        }
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        try {
            SchemaReader schemaReader = olap4jConnection.getMondrianConnection().getSchemaReader().withLocus();
            MondrianOlap4jLevel measuresLevel = (MondrianOlap4jLevel)dimension.getDefaultHierarchy().getLevels().get(0);
            ArrayList<Measure> measures = new ArrayList<Measure>();
            List<Member> levelMembers = schemaReader.getLevelMembers(measuresLevel.level, true);
            for (Member member : levelMembers) {
                MondrianOlap4jMember olap4jMember = olap4jConnection.toOlap4j(member);
                if (!(olap4jMember instanceof Measure)) continue;
                measures.add((Measure)olap4jMember);
            }
            return measures;
        }
        catch (OlapException e) {
            throw new RuntimeException(e);
        }
    }

    public NamedList<org.olap4j.metadata.NamedSet> getSets() {
        NamedListImpl list = new NamedListImpl();
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        for (NamedSet namedSet : this.cube.getNamedSets()) {
            list.add((Object)olap4jConnection.toOlap4j(this.cube, namedSet));
        }
        return Olap4jUtil.cast((NamedList)list);
    }

    public Collection<Locale> getSupportedLocales() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.cube.getName();
    }

    public String getUniqueName() {
        return this.cube.getUniqueName();
    }

    public String getCaption() {
        return this.cube.getLocalized(OlapElement.LocalizedProperty.CAPTION, this.olap4jSchema.getLocale());
    }

    public String getDescription() {
        return this.cube.getLocalized(OlapElement.LocalizedProperty.DESCRIPTION, this.olap4jSchema.getLocale());
    }

    public boolean isVisible() {
        return this.cube.isVisible();
    }

    public MondrianOlap4jMember lookupMember(List<IdentifierSegment> nameParts) throws OlapException {
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        Role role = olap4jConnection.getMondrianConnection().getRole();
        SchemaReader schemaReader = this.cube.getSchemaReader(role).withLocus();
        return this.lookupMember(schemaReader, nameParts);
    }

    private MondrianOlap4jMember lookupMember(SchemaReader schemaReader, List<IdentifierSegment> nameParts) {
        ArrayList<Id.Segment> segmentList = new ArrayList<Id.Segment>();
        for (IdentifierSegment namePart : nameParts) {
            segmentList.add(Util.convert(namePart));
        }
        Member member = schemaReader.getMemberByUniqueName(segmentList, false);
        if (member == null) {
            return null;
        }
        return this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection.toOlap4j(member);
    }

    public List<org.olap4j.metadata.Member> lookupMembers(Set<Member.TreeOp> treeOps, List<IdentifierSegment> nameParts) throws OlapException {
        MondrianOlap4jMember parentMember;
        MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        Role role = olap4jConnection.getMondrianConnection().getRole();
        SchemaReader schemaReader = this.cube.getSchemaReader(role).withLocus();
        MondrianOlap4jMember member = this.lookupMember(schemaReader, nameParts);
        if (member == null) {
            return Collections.emptyList();
        }
        ArrayList<MondrianOlap4jMember> list = new ArrayList<MondrianOlap4jMember>();
        if (treeOps.contains(Member.TreeOp.ANCESTORS)) {
            for (MondrianOlap4jMember m = member.getParentMember(); m != null; m = m.getParentMember()) {
                list.add(0, m);
            }
        } else if (treeOps.contains(Member.TreeOp.PARENT) && (parentMember = member.getParentMember()) != null) {
            list.add(parentMember);
        }
        ArrayList remainingSiblingsList = null;
        if (treeOps.contains(Member.TreeOp.SIBLINGS)) {
            MondrianOlap4jMember parentMember2 = member.getParentMember();
            NamedList<MondrianOlap4jMember> siblingMembers = parentMember2 != null ? olap4jConnection.toOlap4j(schemaReader.getMemberChildren(parentMember2.member)) : olap4jConnection.toOlap4j(schemaReader.getHierarchyRootMembers(member.member.getHierarchy()));
            ArrayList<MondrianOlap4jMember> targetList = list;
            for (MondrianOlap4jMember siblingMember : siblingMembers) {
                if (siblingMember.equals(member)) {
                    remainingSiblingsList = new ArrayList();
                    targetList = remainingSiblingsList;
                    continue;
                }
                targetList.add(siblingMember);
            }
        }
        if (treeOps.contains(Member.TreeOp.SELF)) {
            list.add(member);
        }
        if (treeOps.contains(Member.TreeOp.DESCENDANTS)) {
            this.addDescendants(list, schemaReader, olap4jConnection, member, true);
        } else if (treeOps.contains(Member.TreeOp.CHILDREN)) {
            this.addDescendants(list, schemaReader, olap4jConnection, member, false);
        }
        if (remainingSiblingsList != null) {
            list.addAll(remainingSiblingsList);
        }
        return Olap4jUtil.cast(list);
    }

    private void addDescendants(List<MondrianOlap4jMember> list, SchemaReader schemaReader, MondrianOlap4jConnection olap4jConnection, MondrianOlap4jMember member, boolean recurse) {
        for (Member m : schemaReader.getMemberChildren(member.member)) {
            MondrianOlap4jMember childMember = olap4jConnection.toOlap4j(m);
            list.add(childMember);
            if (!recurse) continue;
            this.addDescendants(list, schemaReader, olap4jConnection, childMember, recurse);
        }
    }

    public boolean isDrillThroughEnabled() {
        return true;
    }

    @Override
    protected OlapElement getOlapElement() {
        return this.cube;
    }
}

