/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.compatibility.Row;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class RowMeta
implements RowMetaInterface {
    public static final String XML_META_TAG = "row-meta";
    public static final String XML_DATA_TAG = "row-data";
    private List<ValueMetaInterface> valueMetaList = new ArrayList<ValueMetaInterface>();
    private List<Integer> valuesThatNeedRealClone;
    private Map<String, Integer> valueIndexMap = new ConcurrentHashMap<String, Integer>();

    public RowMeta() {
    }

    @Override
    public RowMeta clone() {
        try {
            RowMeta rowMeta = new RowMeta();
            for (int i = 0; i < this.size(); ++i) {
                ValueMetaInterface valueMeta = this.getValueMeta(i);
                rowMeta.addValueMeta(ValueMetaFactory.cloneValueMeta(valueMeta));
            }
            return rowMeta;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RowMetaInterface cloneToType(int targetType) throws KettleValueException {
        try {
            RowMeta rowMeta = new RowMeta();
            for (ValueMetaInterface valueMeta : this.getValueMetaList()) {
                rowMeta.addValueMeta(ValueMetaFactory.cloneValueMeta(valueMeta, targetType));
            }
            return rowMeta;
        }
        catch (KettlePluginException e) {
            throw new KettleValueException(e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("[");
            buffer.append(this.getValueMeta(i).toString());
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public List<ValueMetaInterface> getValueMetaList() {
        return Collections.unmodifiableList(this.valueMetaList);
    }

    @Override
    public void setValueMetaList(List<ValueMetaInterface> valueMetaList) {
        this.valueMetaList = valueMetaList;
        this.valueIndexMap.clear();
        for (int i = 0; i < this.valueMetaList.size(); ++i) {
            ValueMetaInterface valueMeta = this.valueMetaList.get(i);
            if (Const.isEmpty(valueMeta.getName())) continue;
            this.valueIndexMap.put(valueMeta.getName().toLowerCase(), i);
        }
    }

    @Override
    public int size() {
        return this.valueMetaList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean exists(ValueMetaInterface meta) {
        return meta != null && this.searchValueMeta(meta.getName()) != null;
    }

    @Override
    public void addValueMeta(ValueMetaInterface meta) {
        this.addValueMeta(this.valueMetaList.size(), meta);
    }

    @Override
    public void addValueMeta(int index, ValueMetaInterface meta) {
        if (meta != null) {
            ValueMetaInterface newMeta = !this.exists(meta) ? meta : this.renameValueMetaIfInRow(meta);
            this.valueMetaList.add(index, newMeta);
            if (!Const.isEmpty(newMeta.getName())) {
                this.valueIndexMap.put(newMeta.getName().toLowerCase(), index);
            }
        }
    }

    @Override
    public ValueMetaInterface getValueMeta(int index) {
        if (index >= 0 && index < this.valueMetaList.size()) {
            return this.valueMetaList.get(index);
        }
        return null;
    }

    @Override
    public void setValueMeta(int index, ValueMetaInterface valueMeta) {
        if (valueMeta != null) {
            this.valueMetaList.set(index, valueMeta);
            if (!Const.isEmpty(valueMeta.getName())) {
                this.valueIndexMap.put(valueMeta.getName().toLowerCase(), index);
            }
        }
    }

    @Override
    public String getString(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getString(dataRow[index]);
    }

    @Override
    public Long getInteger(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getInteger(dataRow[index]);
    }

    @Override
    public Double getNumber(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getNumber(dataRow[index]);
    }

    @Override
    public Date getDate(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getDate(dataRow[index]);
    }

    @Override
    public BigDecimal getBigNumber(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getBigNumber(dataRow[index]);
    }

    @Override
    public Boolean getBoolean(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getBoolean(dataRow[index]);
    }

    @Override
    public byte[] getBinary(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return null;
        }
        ValueMetaInterface meta = this.valueMetaList.get(index);
        return meta.getBinary(dataRow[index]);
    }

    @Override
    public boolean isNull(Object[] dataRow, int index) throws KettleValueException {
        if (dataRow == null) {
            return true;
        }
        return this.getValueMeta(index).isNull(dataRow[index]);
    }

    @Override
    public Object[] cloneRow(Object[] objects) throws KettleValueException {
        return this.cloneRow(objects, (Object[])objects.clone());
    }

    @Override
    public Object[] cloneRow(Object[] objects, Object[] newObjects) throws KettleValueException {
        if (this.valuesThatNeedRealClone == null) {
            this.valuesThatNeedRealClone = new ArrayList<Integer>();
            for (int i = 0; i < this.size(); ++i) {
                ValueMetaInterface valueMeta = this.getValueMeta(i);
                if (!valueMeta.requiresRealClone()) continue;
                this.valuesThatNeedRealClone.add(i);
            }
        }
        for (Integer i : this.valuesThatNeedRealClone) {
            ValueMetaInterface valueMeta = this.getValueMeta(i);
            newObjects[i.intValue()] = valueMeta.cloneValueData(objects[i]);
        }
        return newObjects;
    }

    @Override
    public String getString(Object[] dataRow, String valueName, String defaultValue) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getString(dataRow, index);
    }

    @Override
    public Long getInteger(Object[] dataRow, String valueName, Long defaultValue) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getInteger(dataRow, index);
    }

    @Override
    public Date getDate(Object[] dataRow, String valueName, Date defaultValue) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            return defaultValue;
        }
        return this.getDate(dataRow, index);
    }

    @Override
    public int indexOfValue(String valueName) {
        ValueMetaInterface value;
        if (valueName == null) {
            return -1;
        }
        String key = valueName.toLowerCase();
        Integer index = this.valueIndexMap.get(key);
        if (index != null && !valueName.equalsIgnoreCase((value = this.valueMetaList.get(index)).getName())) {
            index = null;
            this.valueIndexMap.remove(key);
        }
        for (int i = 0; index == null && i < this.valueMetaList.size(); ++i) {
            if (!valueName.equalsIgnoreCase(this.valueMetaList.get(i).getName())) continue;
            index = i;
            this.valueIndexMap.put(key, index);
        }
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public ValueMetaInterface searchValueMeta(String valueName) {
        Integer index = this.indexOfValue(valueName);
        if (index < 0) {
            return null;
        }
        return this.valueMetaList.get(index);
    }

    @Override
    public void addRowMeta(RowMetaInterface rowMeta) {
        for (int i = 0; i < rowMeta.size(); ++i) {
            this.addValueMeta(rowMeta.getValueMeta(i));
        }
    }

    @Override
    public void mergeRowMeta(RowMetaInterface r) {
        for (int x = 0; x < r.size(); ++x) {
            ValueMetaInterface field = r.getValueMeta(x);
            if (this.searchValueMeta(field.getName()) == null) {
                this.addValueMeta(field);
                continue;
            }
            this.addValueMeta(this.renameValueMetaIfInRow(field));
        }
    }

    private ValueMetaInterface renameValueMetaIfInRow(ValueMetaInterface valueMeta) {
        int index = 1;
        String name = valueMeta.getName() + "_" + index;
        while (this.searchValueMeta(name) != null) {
            name = valueMeta.getName() + "_" + ++index;
        }
        ValueMetaInterface copy = valueMeta.clone();
        copy.setName(name);
        return copy;
    }

    @Override
    public String[] getFieldNames() {
        String[] retval = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            retval[i] = this.getValueMeta(i).getName();
        }
        return retval;
    }

    @Override
    public void writeData(DataOutputStream outputStream, Object[] data) throws KettleFileException {
        for (int i = 0; i < this.size(); ++i) {
            this.getValueMeta(i).writeData(outputStream, data[i]);
        }
        if (this.size() == 0) {
            try {
                outputStream.writeBoolean(true);
            }
            catch (IOException e) {
                throw new KettleFileException("Error writing marker flag", e);
            }
        }
    }

    @Override
    public void writeMeta(DataOutputStream outputStream) throws KettleFileException {
        try {
            outputStream.writeInt(this.size());
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to write nr of metadata values", e);
        }
        for (int i = 0; i < this.size(); ++i) {
            this.getValueMeta(i).writeMeta(outputStream);
        }
    }

    public RowMeta(DataInputStream inputStream) throws KettleFileException, KettleEOFException, SocketTimeoutException {
        this();
        int nr;
        try {
            nr = inputStream.readInt();
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (EOFException e) {
            throw new KettleEOFException("End of file while reading the number of metadata values in the row metadata", e);
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to read nr of metadata values: " + e.toString(), e);
        }
        for (int i = 0; i < nr; ++i) {
            try {
                int type = inputStream.readInt();
                ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta(type);
                valueMeta.readMetaData(inputStream);
                this.addValueMeta(valueMeta);
                continue;
            }
            catch (EOFException e) {
                throw new KettleEOFException(e);
            }
            catch (Exception e) {
                throw new KettleFileException(this.toString() + " : Unable to read row metadata from input stream", e);
            }
        }
    }

    @Override
    public Object[] readData(DataInputStream inputStream) throws KettleFileException, KettleEOFException, SocketTimeoutException {
        Object[] data = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            data[i] = this.getValueMeta(i).readData(inputStream);
        }
        if (this.size() == 0) {
            try {
                inputStream.readBoolean();
            }
            catch (EOFException e) {
                throw new KettleEOFException(e);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                throw new KettleFileException(this.toString() + " : Unable to read the marker flag data from input stream", e);
            }
        }
        return data;
    }

    @Override
    public void clear() {
        this.valueMetaList.clear();
        this.valueIndexMap.clear();
    }

    @Override
    public void removeValueMeta(String valueName) throws KettleValueException {
        int index = this.indexOfValue(valueName);
        if (index < 0) {
            throw new KettleValueException("Unable to find value metadata with name '" + valueName + "', so I can't delete it.");
        }
        this.removeValueMeta(index);
    }

    @Override
    public void removeValueMeta(int index) {
        this.valueMetaList.remove(index);
        this.valueIndexMap.clear();
    }

    @Override
    public String toStringMeta() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("[");
            buffer.append(this.getValueMeta(i).toStringMeta());
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String getString(Object[] row) throws KettleValueException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("[");
            buffer.append(this.getString(row, i));
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public String[] getFieldNamesAndTypes(int maxlen) {
        String[] retval = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ValueMetaInterface v = this.getValueMeta(i);
            retval[i] = Const.rightPad(v.getName(), maxlen) + "   (" + v.getTypeDesc() + ")";
        }
        return retval;
    }

    @Override
    public int compare(Object[] rowData1, Object[] rowData2, int[] fieldnrs) throws KettleValueException {
        for (int i = 0; i < fieldnrs.length; ++i) {
            ValueMetaInterface valueMeta = this.getValueMeta(fieldnrs[i]);
            int cmp = valueMeta.compare(rowData1[fieldnrs[i]], rowData2[fieldnrs[i]]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean equals(Object[] rowData1, Object[] rowData2, int[] fieldnrs) throws KettleValueException {
        for (int i = 0; i < fieldnrs.length; ++i) {
            ValueMetaInterface valueMeta = this.getValueMeta(fieldnrs[i]);
            int cmp = valueMeta.compare(rowData1[fieldnrs[i]], rowData2[fieldnrs[i]]);
            if (cmp == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Object[] rowData1, Object[] rowData2, int[] fieldnrs1, int[] fieldnrs2) throws KettleValueException {
        int len = fieldnrs1.length < fieldnrs2.length ? fieldnrs1.length : fieldnrs2.length;
        for (int i = 0; i < len; ++i) {
            ValueMetaInterface valueMeta = this.getValueMeta(fieldnrs1[i]);
            int cmp = valueMeta.compare(rowData1[fieldnrs1[i]], rowData2[fieldnrs2[i]]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compare(Object[] rowData1, RowMetaInterface rowMeta2, Object[] rowData2, int[] fieldnrs1, int[] fieldnrs2) throws KettleValueException {
        int len = fieldnrs1.length < fieldnrs2.length ? fieldnrs1.length : fieldnrs2.length;
        for (int i = 0; i < len; ++i) {
            ValueMetaInterface valueMeta2;
            ValueMetaInterface valueMeta1 = this.getValueMeta(fieldnrs1[i]);
            int cmp = valueMeta1.compare(rowData1[fieldnrs1[i]], valueMeta2 = rowMeta2.getValueMeta(fieldnrs2[i]), rowData2[fieldnrs2[i]]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compare(Object[] rowData1, Object[] rowData2) throws KettleValueException {
        for (int i = 0; i < this.size(); ++i) {
            ValueMetaInterface valueMeta = this.getValueMeta(i);
            int cmp = valueMeta.compare(rowData1[i], rowData2[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    @Deprecated
    public int oldXORHashCode(Object[] rowData) throws KettleValueException {
        int hash = 0;
        for (int i = 0; i < this.size(); ++i) {
            ValueMetaInterface valueMeta = this.getValueMeta(i);
            hash ^= valueMeta.hashCode(rowData[i]);
        }
        return hash;
    }

    @Override
    public int hashCode(Object[] rowData) throws KettleValueException {
        return Arrays.hashCode(rowData);
    }

    @Override
    public int convertedValuesHashCode(Object[] rowData) throws KettleValueException {
        if (rowData == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < rowData.length; ++i) {
            result = 31 * result + this.getValueMeta(i).hashCode();
        }
        return result;
    }

    public static final byte[] extractData(RowMetaInterface metadata, Object[] row) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            metadata.writeData(dataOutputStream, row);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing row to byte array", e);
        }
    }

    public static final Object[] getRow(RowMetaInterface metadata, byte[] data) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return metadata.readData(dataInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error de-serializing row of data from byte array", e);
        }
    }

    public static Row createOriginalRow(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        Row row = new Row();
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            Object valueData = rowData[i];
            Value value = valueMeta.createOriginalValue(valueData);
            row.addValue(value);
        }
        return row;
    }

    @Override
    public String getMetaXML() throws IOException {
        StringBuffer xml = new StringBuffer();
        xml.append("<").append(XML_META_TAG).append(">");
        for (int i = 0; i < this.size(); ++i) {
            xml.append(this.getValueMeta(i).getMetaXML());
        }
        xml.append("</").append(XML_META_TAG).append(">");
        return xml.toString();
    }

    public RowMeta(Node node) throws KettleException {
        this();
        int nrValues = XMLHandler.countNodes(node, "value-meta");
        for (int i = 0; i < nrValues; ++i) {
            this.addValueMeta(new ValueMeta(XMLHandler.getSubNodeByNr(node, "value-meta", i)));
        }
    }

    @Override
    public String getDataXML(Object[] rowData) throws IOException {
        StringBuffer xml = new StringBuffer();
        xml.append("<").append(XML_DATA_TAG).append(">");
        for (int i = 0; i < this.size(); ++i) {
            xml.append(this.getValueMeta(i).getDataXML(rowData[i]));
        }
        xml.append("</").append(XML_DATA_TAG).append(">");
        return xml.toString();
    }

    @Override
    public Object[] getRow(Node node) throws KettleException {
        Object[] rowData = RowDataUtil.allocateRowData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Node valueDataNode = XMLHandler.getSubNodeByNr(node, "value-data", i);
            rowData[i] = this.getValueMeta(i).getValue(valueDataNode);
        }
        return rowData;
    }
}

