/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.GreenplumDatabaseMeta;
import org.pentaho.di.core.database.MySQLDatabaseMeta;
import org.pentaho.di.core.database.NetezzaDatabaseMeta;
import org.pentaho.di.core.database.OracleDatabaseMeta;
import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;
import org.pentaho.di.core.database.SQLiteDatabaseMeta;
import org.pentaho.di.core.database.TeradataDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.w3c.dom.Node;

public class ValueMetaBase
implements ValueMetaInterface {
    protected static Class<?> PKG = Const.class;
    public static final String DEFAULT_DATE_FORMAT_MASK = Const.NVL(EnvUtil.getSystemProperty("KETTLE_DEFAULT_DATE_FORMAT"), "yyyy/MM/dd HH:mm:ss.SSS");
    public static final String DEFAULT_TIMESTAMP_FORMAT_MASK = Const.NVL(EnvUtil.getSystemProperty("KETTLE_DEFAULT_TIMESTAMP_FORMAT"), "yyyy/MM/dd HH:mm:ss.SSSSSSSSS");
    public static final String XML_META_TAG = "value-meta";
    public static final String XML_DATA_TAG = "value-data";
    public static final boolean EMPTY_STRING_AND_NULL_ARE_DIFFERENT = ValueMetaBase.convertStringToBoolean(Const.NVL(System.getProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N"), "N"));
    protected String name;
    protected int length;
    protected int precision;
    protected int type;
    protected int trimType;
    protected int storageType;
    protected String origin;
    protected String comments;
    protected Object[] index;
    protected String conversionMask;
    protected String stringEncoding;
    protected String decimalSymbol;
    protected String groupingSymbol;
    protected String currencySymbol;
    protected boolean caseInsensitive;
    protected boolean sortedDescending;
    protected boolean outputPaddingEnabled;
    protected boolean largeTextField;
    protected Locale dateFormatLocale;
    protected TimeZone dateFormatTimeZone;
    protected boolean dateFormatLenient;
    protected boolean lenientStringToNumber;
    protected boolean ignoreTimezone;
    protected SimpleDateFormat dateFormat;
    protected boolean dateFormatChanged;
    protected DecimalFormat decimalFormat;
    protected boolean decimalFormatChanged;
    protected ValueMetaInterface storageMetadata;
    protected boolean identicalFormat;
    protected ValueMetaInterface conversionMetadata;
    boolean singleByteEncoding;
    protected long numberOfBinaryStringConversions;
    protected boolean bigNumberFormatting;
    protected int originalColumnType;
    protected String originalColumnTypeName;
    protected int originalPrecision;
    protected int originalScale;
    protected boolean originalAutoIncrement;
    protected int originalNullable;
    protected boolean originalSigned;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, "ValueMeta.TrimType.None", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Left", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Right", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Both", new String[0])};
    public static final String[] SINGLE_BYTE_ENCODINGS = new String[]{"ISO8859_1", "Cp1252", "ASCII", "Cp037", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp420", "Cp424", "Cp437", "Cp500", "Cp737", "Cp775", "Cp850", "Cp852", "Cp855", "Cp856", "Cp857", "Cp858", "Cp860", "Cp861", "Cp862", "Cp863", "Cp865", "Cp866", "Cp869", "Cp870", "Cp871", "Cp875", "Cp918", "Cp921", "Cp922", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1250", "Cp1251", "Cp1253", "Cp1254", "Cp1255", "Cp1257", "ISO8859_2", "ISO8859_3", "ISO8859_5", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "ISO8859_13", "ISO8859_15", "ISO8859_15_FDIS", "MacCentralEurope", "MacCroatian", "MacCyrillic", "MacDingbat", "MacGreek", "MacHebrew", "MacIceland", "MacRoman", "MacRomania", "MacSymbol", "MacTurkish", "MacUkraine"};
    protected static SimpleDateFormat compatibleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public ValueMetaBase() {
        this(null, 0, -1, -1);
    }

    public ValueMetaBase(String name) {
        this(name, 0, -1, -1);
    }

    public ValueMetaBase(String name, int type) {
        this(name, type, -1, -1);
    }

    public ValueMetaBase(String name, int type, int storageType) {
        this(name, type, -1, -1);
        this.storageType = storageType;
        this.setDefaultConversionMask();
    }

    public ValueMetaBase(String name, int type, int length, int precision) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.storageType = 0;
        this.sortedDescending = false;
        this.outputPaddingEnabled = false;
        this.decimalSymbol = "" + Const.DEFAULT_DECIMAL_SEPARATOR;
        this.groupingSymbol = "" + Const.DEFAULT_GROUPING_SEPARATOR;
        this.dateFormatLocale = Locale.getDefault();
        this.dateFormatTimeZone = TimeZone.getDefault();
        this.identicalFormat = true;
        this.bigNumberFormatting = true;
        this.lenientStringToNumber = ValueMetaBase.convertStringToBoolean(Const.NVL(System.getProperty("KETTLE_LENIENT_STRING_TO_NUMBER_CONVERSION", "N"), "N"));
        this.ignoreTimezone = ValueMetaBase.convertStringToBoolean(Const.NVL(System.getProperty("KETTLE_COMPATIBILITY_DB_IGNORE_TIMEZONE", "N"), "N"));
        this.determineSingleByteEncoding();
        this.setDefaultConversionMask();
    }

    protected void setDefaultConversionMask() {
        switch (this.type) {
            case 5: {
                String alternativeIntegerMask = EnvUtil.getSystemProperty("KETTLE_DEFAULT_INTEGER_FORMAT");
                if (Const.isEmpty(alternativeIntegerMask)) {
                    this.setConversionMask("#;-#");
                    break;
                }
                this.setConversionMask(alternativeIntegerMask);
                break;
            }
            case 1: {
                String alternativeNumberMask = EnvUtil.getSystemProperty("KETTLE_DEFAULT_NUMBER_FORMAT");
                if (Const.isEmpty(alternativeNumberMask)) {
                    this.setConversionMask("#.#;-#.#");
                    break;
                }
                this.setConversionMask(alternativeNumberMask);
                break;
            }
            case 6: {
                String alternativeBigNumberMask = EnvUtil.getSystemProperty("KETTLE_DEFAULT_NUMBER_FORMAT");
                if (Const.isEmpty(alternativeBigNumberMask)) {
                    this.setConversionMask("#.###############################################;-#.###############################################");
                } else {
                    this.setConversionMask(alternativeBigNumberMask);
                }
                this.setGroupingSymbol(null);
                this.setDecimalSymbol(".");
                break;
            }
        }
    }

    protected void determineSingleByteEncoding() {
        this.singleByteEncoding = false;
        Charset cs = Const.isEmpty(this.stringEncoding) ? Charset.defaultCharset() : Charset.forName(this.stringEncoding);
        for (String charSetEncoding : SINGLE_BYTE_ENCODINGS) {
            if (!cs.toString().equalsIgnoreCase(charSetEncoding)) continue;
            this.singleByteEncoding = true;
        }
    }

    @Override
    public ValueMetaBase clone() {
        try {
            ValueMetaBase valueMeta = (ValueMetaBase)super.clone();
            valueMeta.dateFormat = null;
            valueMeta.decimalFormat = null;
            if (this.dateFormatLocale != null) {
                valueMeta.dateFormatLocale = (Locale)this.dateFormatLocale.clone();
            }
            if (this.dateFormatTimeZone != null) {
                valueMeta.dateFormatTimeZone = (TimeZone)this.dateFormatTimeZone.clone();
            }
            if (this.storageMetadata != null) {
                valueMeta.storageMetadata = this.storageMetadata.clone();
            }
            if (this.conversionMetadata != null) {
                valueMeta.conversionMetadata = this.conversionMetadata.clone();
            }
            valueMeta.compareStorageAndActualFormat();
            return valueMeta;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public Object[] getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Object[] index) {
        this.index = index;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setLength(int length, int precision) {
        this.length = length;
        this.precision = precision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Override
    public int getPrecision() {
        if (this.isInteger() || this.isBinary()) {
            return 0;
        }
        if (this.isString() || this.isBoolean()) {
            return -1;
        }
        return this.precision;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public int getStorageType() {
        return this.storageType;
    }

    @Override
    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    @Override
    public boolean isStorageNormal() {
        return this.storageType == 0;
    }

    @Override
    public boolean isStorageIndexed() {
        return this.storageType == 2;
    }

    @Override
    public boolean isStorageBinaryString() {
        return this.storageType == 1;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    @Deprecated
    public void setType(int type) {
        this.type = type;
    }

    @Override
    @Deprecated
    public String getConversionMask() {
        return this.conversionMask;
    }

    @Override
    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
        this.dateFormatChanged = true;
        this.decimalFormatChanged = true;
        this.compareStorageAndActualFormat();
    }

    @Override
    public String getStringEncoding() {
        return this.stringEncoding;
    }

    @Override
    public void setStringEncoding(String encoding) {
        this.stringEncoding = encoding;
        this.determineSingleByteEncoding();
        this.compareStorageAndActualFormat();
    }

    @Override
    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    @Override
    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
        this.decimalFormatChanged = true;
        this.compareStorageAndActualFormat();
    }

    @Override
    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    @Override
    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
        this.decimalFormatChanged = true;
        this.compareStorageAndActualFormat();
    }

    @Override
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    @Override
    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        this.decimalFormatChanged = true;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public boolean isSortedDescending() {
        return this.sortedDescending;
    }

    @Override
    public void setSortedDescending(boolean sortedDescending) {
        this.sortedDescending = sortedDescending;
    }

    @Override
    public boolean isOutputPaddingEnabled() {
        return this.outputPaddingEnabled;
    }

    @Override
    public void setOutputPaddingEnabled(boolean outputPaddingEnabled) {
        this.outputPaddingEnabled = outputPaddingEnabled;
    }

    @Override
    public boolean isLargeTextField() {
        return this.largeTextField;
    }

    @Override
    public void setLargeTextField(boolean largeTextField) {
        this.largeTextField = largeTextField;
    }

    @Override
    public boolean isDateFormatLenient() {
        return this.dateFormatLenient;
    }

    @Override
    public void setDateFormatLenient(boolean dateFormatLenient) {
        this.dateFormatLenient = dateFormatLenient;
        this.dateFormatChanged = true;
    }

    @Override
    public Locale getDateFormatLocale() {
        return this.dateFormatLocale;
    }

    @Override
    public void setDateFormatLocale(Locale dateFormatLocale) {
        this.dateFormatLocale = dateFormatLocale;
        this.dateFormatChanged = true;
    }

    protected synchronized String convertDateToString(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return this.getDateFormat().format(date);
    }

    protected synchronized String convertDateToCompatibleString(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return compatibleDateFormat.format(date);
    }

    protected synchronized java.util.Date convertStringToDate(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            String df;
            String string2 = df = this.getDateFormat() != null ? this.getDateFormat().toPattern() : null;
            if (df != null && this.getQuotesBeforeSymbol(df, "Z") % 2 == 0) {
                if (string.contains("Z")) {
                    string = string.replace("Z", "UTC");
                } else if (string.matches(".*[\\+|\\-]\\d\\d:\\d\\d")) {
                    int lPos = string.lastIndexOf(":");
                    string = string.substring(0, lPos) + string.substring(lPos + 1);
                }
            }
            return this.getDateFormat().parse(string);
        }
        catch (ParseException e) {
            String dateFormat = this.getDateFormat() != null ? this.getDateFormat().toPattern() : "null";
            throw new KettleValueException(this.toString() + " : couldn't convert string [" + string + "] to a date using format [" + dateFormat + "] on offset location " + e.getErrorOffset(), e);
        }
    }

    protected Double convertDateToNumber(java.util.Date date) {
        return new Double(date.getTime());
    }

    protected java.util.Date convertNumberToDate(Double number) {
        return new java.util.Date(number.longValue());
    }

    protected Long convertDateToInteger(java.util.Date date) {
        return new Long(date.getTime());
    }

    protected java.util.Date convertIntegerToDate(Long number) {
        return new java.util.Date(number);
    }

    protected BigDecimal convertDateToBigNumber(java.util.Date date) {
        return new BigDecimal(date.getTime());
    }

    protected java.util.Date convertBigNumberToDate(BigDecimal number) {
        return new java.util.Date(number.longValue());
    }

    protected synchronized String convertNumberToString(Double number) throws KettleValueException {
        if (number == null) {
            if (!this.outputPaddingEnabled || this.length < 1) {
                return null;
            }
            String[] emptyPaddedStrings = Const.getEmptyPaddedStrings();
            if (this.length < emptyPaddedStrings.length) {
                return emptyPaddedStrings[this.length];
            }
            return Const.rightPad("", this.length);
        }
        try {
            return this.getDecimalFormat(false).format(number);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert Number to String ", e);
        }
    }

    protected synchronized String convertNumberToCompatibleString(Double number) throws KettleValueException {
        if (number == null) {
            return null;
        }
        return Double.toString(number);
    }

    protected synchronized Double convertStringToNumber(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            Number number;
            if (this.lenientStringToNumber) {
                number = this.getDecimalFormat(false).parse(string);
            } else {
                ParsePosition parsePosition = new ParsePosition(0);
                number = this.getDecimalFormat(false).parse(string, parsePosition);
                if (parsePosition.getIndex() < string.length()) {
                    throw new KettleValueException(this.toString() + " : couldn't convert String to number : non-numeric character found at position " + (parsePosition.getIndex() + 1) + " for value [" + string + "]");
                }
            }
            return new Double(number.doubleValue());
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert String to number ", e);
        }
    }

    @Override
    public synchronized SimpleDateFormat getDateFormat() {
        if (this.conversionMetadata != null) {
            return this.conversionMetadata.getDateFormat();
        }
        if (this.dateFormat == null || this.dateFormatChanged) {
            this.dateFormat = new SimpleDateFormat();
            String mask = Const.isEmpty(this.conversionMask) ? DEFAULT_DATE_FORMAT_MASK : this.conversionMask;
            this.dateFormat = this.dateFormatLocale == null || this.dateFormatLocale.equals(Locale.getDefault()) ? new SimpleDateFormat(mask) : new SimpleDateFormat(mask, this.dateFormatLocale);
            if (this.dateFormatTimeZone != null) {
                this.dateFormat.setTimeZone(this.dateFormatTimeZone);
            }
            this.dateFormat.setLenient(this.dateFormatLenient);
            this.dateFormatChanged = false;
        }
        return this.dateFormat;
    }

    @Override
    public synchronized DecimalFormat getDecimalFormat() {
        return this.getDecimalFormat(false);
    }

    @Override
    public synchronized DecimalFormat getDecimalFormat(boolean useBigDecimal) {
        if (this.conversionMetadata != null) {
            return this.conversionMetadata.getDecimalFormat(useBigDecimal);
        }
        if (this.decimalFormat == null || this.decimalFormatChanged) {
            this.decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            this.decimalFormat.setParseBigDecimal(useBigDecimal);
            DecimalFormatSymbols decimalFormatSymbols = this.decimalFormat.getDecimalFormatSymbols();
            if (!Const.isEmpty(this.currencySymbol)) {
                decimalFormatSymbols.setCurrencySymbol(this.currencySymbol);
            }
            if (!Const.isEmpty(this.groupingSymbol)) {
                decimalFormatSymbols.setGroupingSeparator(this.groupingSymbol.charAt(0));
            }
            if (!Const.isEmpty(this.decimalSymbol)) {
                decimalFormatSymbols.setDecimalSeparator(this.decimalSymbol.charAt(0));
            }
            this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            if (!Const.isEmpty(this.conversionMask)) {
                this.decimalFormat.applyPattern(this.conversionMask);
            } else {
                switch (this.type) {
                    case 5: {
                        int i;
                        if (this.length < 1) {
                            this.decimalFormat.applyPattern(" ###############0;-###############0");
                            break;
                        }
                        StringBuffer integerPattern = new StringBuffer();
                        integerPattern.append(" ");
                        for (i = 0; i < this.getLength(); ++i) {
                            integerPattern.append('0');
                        }
                        integerPattern.append(";");
                        integerPattern.append("-");
                        for (i = 0; i < this.getLength(); ++i) {
                            integerPattern.append('0');
                        }
                        this.decimalFormat.applyPattern(integerPattern.toString());
                        break;
                    }
                    case 1: 
                    case 6: {
                        int i;
                        if (this.length < 1) {
                            this.decimalFormat.applyPattern(" ##########0.0########;-#########0.0########");
                            break;
                        }
                        StringBuffer numberPattern = new StringBuffer();
                        numberPattern.append(' ');
                        if (this.precision < 0) {
                            for (i = 0; i < this.length; ++i) {
                                numberPattern.append('0');
                            }
                            numberPattern.append(".00");
                        } else {
                            for (i = 0; i <= this.length; ++i) {
                                numberPattern.append('0');
                            }
                            int pos = this.length - this.precision + 1;
                            if (pos >= 0 && pos < numberPattern.length()) {
                                numberPattern.setCharAt(this.length - this.precision + 1, '.');
                            }
                        }
                        StringBuffer negativePattern = new StringBuffer(numberPattern);
                        negativePattern.setCharAt(0, '-');
                        numberPattern.append(";");
                        numberPattern.append(negativePattern);
                        this.decimalFormat.applyPattern(numberPattern.toString());
                        break;
                    }
                }
            }
            this.decimalFormatChanged = false;
        }
        return this.decimalFormat;
    }

    protected synchronized String convertIntegerToString(Long integer) throws KettleValueException {
        if (integer == null) {
            if (!this.outputPaddingEnabled || this.length < 1) {
                return null;
            }
            String[] emptyPaddedStrings = Const.getEmptyPaddedStrings();
            if (this.length < emptyPaddedStrings.length) {
                return emptyPaddedStrings[this.length];
            }
            return Const.rightPad("", this.length);
        }
        try {
            return this.getDecimalFormat(false).format(integer);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert Long to String ", e);
        }
    }

    protected synchronized String convertIntegerToCompatibleString(Long integer) throws KettleValueException {
        if (integer == null) {
            return null;
        }
        return Long.toString(integer);
    }

    protected synchronized Long convertStringToInteger(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            Number number;
            if (this.lenientStringToNumber) {
                number = new Long(this.getDecimalFormat(false).parse(string).longValue());
            } else {
                ParsePosition parsePosition = new ParsePosition(0);
                number = this.getDecimalFormat(false).parse(string, parsePosition);
                if (parsePosition.getIndex() < string.length()) {
                    throw new KettleValueException(this.toString() + " : couldn't convert String to number : non-numeric character found at position " + (parsePosition.getIndex() + 1) + " for value [" + string + "]");
                }
            }
            return new Long(number.longValue());
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert String to Integer", e);
        }
    }

    protected synchronized String convertBigNumberToString(BigDecimal number) throws KettleValueException {
        if (number == null) {
            return null;
        }
        try {
            return this.getDecimalFormat(this.bigNumberFormatting).format(number);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert BigNumber to String ", e);
        }
    }

    protected synchronized BigDecimal convertStringToBigNumber(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            Number number;
            if (this.lenientStringToNumber) {
                number = this.getDecimalFormat(this.bigNumberFormatting).parse(string);
            } else {
                ParsePosition parsePosition = new ParsePosition(0);
                number = this.getDecimalFormat(this.bigNumberFormatting).parse(string, parsePosition);
                if (parsePosition.getIndex() < string.length()) {
                    throw new KettleValueException(this.toString() + " : couldn't convert String to number : non-numeric character found at position " + (parsePosition.getIndex() + 1) + " for value [" + string + "]");
                }
            }
            return (BigDecimal)number;
        }
        catch (Exception e) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException ex) {
                throw new KettleValueException(this.toString() + " : couldn't convert string value '" + string + "' to a big number.", ex);
            }
        }
    }

    protected String convertBooleanToString(Boolean bool) {
        if (bool == null) {
            return null;
        }
        if (this.length >= 3) {
            return bool != false ? "true" : "false";
        }
        return bool != false ? "Y" : "N";
    }

    public static Boolean convertStringToBoolean(String string) {
        if (Const.isEmpty(string)) {
            return null;
        }
        return "Y".equalsIgnoreCase(string) || "TRUE".equalsIgnoreCase(string) || "YES".equalsIgnoreCase(string) || "1".equals(string);
    }

    protected Double convertBooleanToNumber(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return new Double(bool != false ? 1.0 : 0.0);
    }

    protected Boolean convertNumberToBoolean(Double number) {
        if (number == null) {
            return null;
        }
        return number.intValue() != 0;
    }

    protected Long convertBooleanToInteger(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? 1L : 0L;
    }

    protected Boolean convertIntegerToBoolean(Long number) {
        if (number == null) {
            return null;
        }
        return number != 0L;
    }

    protected BigDecimal convertBooleanToBigNumber(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    protected Boolean convertBigNumberToBoolean(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.intValue() != 0;
    }

    protected String convertBinaryStringToString(byte[] binary) throws KettleValueException {
        if (binary == null || binary.length == 0) {
            return EMPTY_STRING_AND_NULL_ARE_DIFFERENT && binary != null ? "" : null;
        }
        String encoding = this.identicalFormat ? this.getStringEncoding() : this.storageMetadata.getStringEncoding();
        if (Const.isEmpty(encoding)) {
            return new String(binary);
        }
        try {
            return new String(binary, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleValueException(this.toString() + " : couldn't convert binary value to String with specified string encoding [" + this.stringEncoding + "]", e);
        }
    }

    @Override
    public Object convertToNormalStorageType(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return object;
            }
            case 1: {
                return this.convertBinaryStringToNativeType((byte[])object);
            }
            case 2: {
                return this.index[(Integer)object];
            }
        }
        throw new KettleValueException(this.toStringMeta() + " : Unknown storage type [" + this.storageType + "] while converting to normal storage type");
    }

    @Override
    public Object convertToBinaryStringStorageType(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertNormalStorageTypeToBinaryString(object);
            }
            case 1: {
                return object;
            }
            case 2: {
                return this.convertNormalStorageTypeToBinaryString(this.index[(Integer)object]);
            }
        }
        throw new KettleValueException(this.toStringMeta() + " : Unknown storage type [" + this.storageType + "] while converting to normal storage type");
    }

    @Override
    public Object convertBinaryStringToNativeType(byte[] binary) throws KettleValueException {
        if (binary == null) {
            return null;
        }
        ++this.numberOfBinaryStringConversions;
        String string = this.convertBinaryStringToString(binary);
        return this.convertData(this.storageMetadata, string);
    }

    @Override
    public Object convertNormalStorageTypeToBinaryString(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        String string = this.getString(object);
        return this.convertStringToBinaryString(string);
    }

    protected byte[] convertStringToBinaryString(String string) throws KettleValueException {
        if (string == null) {
            return null;
        }
        if (Const.isEmpty(this.stringEncoding)) {
            return string.getBytes();
        }
        try {
            return string.getBytes(this.stringEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleValueException(this.toString() + " : couldn't convert String to Binary with specified string encoding [" + this.stringEncoding + "]", e);
        }
    }

    @Override
    public Object cloneValueData(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        if (this.storageType == 0) {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return object;
                }
                case 3: {
                    return new java.util.Date(((java.util.Date)object).getTime());
                }
                case 8: {
                    byte[] origin = (byte[])object;
                    byte[] target = new byte[origin.length];
                    System.arraycopy(origin, 0, target, 0, origin.length);
                    return target;
                }
                case 7: {
                    return object;
                }
            }
            throw new KettleValueException(this.toString() + ": unable to make copy of value type: " + this.getType());
        }
        return object;
    }

    @Override
    public String getCompatibleString(Object object) throws KettleValueException {
        try {
            String string;
            block1 : switch (this.type) {
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertDateToCompatibleString((java.util.Date)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertDateToCompatibleString((java.util.Date)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            if (object == null) {
                                string = null;
                                break block1;
                            }
                            string = this.convertDateToCompatibleString((java.util.Date)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertNumberToCompatibleString((Double)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertNumberToCompatibleString((Double)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertNumberToCompatibleString((Double)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertIntegerToCompatibleString((Long)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertIntegerToCompatibleString((Long)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertIntegerToCompatibleString((Long)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                default: {
                    return this.getString(object);
                }
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new KettleValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    @Override
    public String getString(Object object) throws KettleValueException {
        try {
            String string;
            block1 : switch (this.type) {
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break;
                        }
                        case 1: {
                            string = (String)this.convertBinaryStringToNativeType((byte[])object);
                            break;
                        }
                        case 2: {
                            string = object == null ? null : (String)this.index[(Integer)object];
                            break;
                        }
                        default: {
                            throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                        }
                    }
                    if (string == null) break;
                    string = this.trim(string);
                    break;
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertDateToString((java.util.Date)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertDateToString((java.util.Date)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertDateToString((java.util.Date)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertNumberToString((Double)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertNumberToString((Double)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertNumberToString((Double)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertIntegerToString((Long)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertIntegerToString((Long)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertIntegerToString((Long)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBigNumberToString((BigDecimal)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBigNumberToString((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBigNumberToString((BigDecimal)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBooleanToString((Boolean)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBooleanToString((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBooleanToString((Boolean)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBinaryStringToString((byte[])this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 7: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.index[(Integer)object].toString();
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                default: {
                    throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
                }
            }
            if (this.isOutputPaddingEnabled() && this.getLength() > 0) {
                string = ValueDataUtil.rightPad(string, this.getLength());
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new KettleValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    protected String trim(String string) {
        switch (this.getTrimType()) {
            case 0: {
                break;
            }
            case 2: {
                string = Const.rtrim(string);
                break;
            }
            case 1: {
                string = Const.ltrim(string);
                break;
            }
            case 3: {
                string = Const.trim(string);
                break;
            }
        }
        return string;
    }

    @Override
    public Double getNumber(Object object) throws KettleValueException {
        try {
            if (object == null) {
                return null;
            }
            switch (this.type) {
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            return (Double)object;
                        }
                        case 1: {
                            return (Double)this.convertBinaryStringToNativeType((byte[])object);
                        }
                        case 2: {
                            return (Double)this.index[(Integer)object];
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToNumber((String)object);
                        }
                        case 1: {
                            return this.convertStringToNumber((String)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertStringToNumber((String)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertDateToNumber((java.util.Date)object);
                        }
                        case 1: {
                            return this.convertDateToNumber((java.util.Date)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return new Double(((java.util.Date)this.index[(Integer)object]).getTime());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            return new Double(((Long)object).doubleValue());
                        }
                        case 1: {
                            return new Double(((Long)this.convertBinaryStringToNativeType((byte[])object)).doubleValue());
                        }
                        case 2: {
                            return new Double(((Long)this.index[(Integer)object]).doubleValue());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            return new Double(((BigDecimal)object).doubleValue());
                        }
                        case 1: {
                            return new Double(((BigDecimal)this.convertBinaryStringToNativeType((byte[])object)).doubleValue());
                        }
                        case 2: {
                            return new Double(((BigDecimal)this.index[(Integer)object]).doubleValue());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertBooleanToNumber((Boolean)object);
                        }
                        case 1: {
                            return this.convertBooleanToNumber((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertBooleanToNumber((Boolean)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to numbers.");
                }
                case 7: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to numbers.");
                }
            }
            throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
        }
        catch (Exception e) {
            throw new KettleValueException("Unexpected conversion error while converting value [" + this.toString() + "] to a Number", e);
        }
    }

    @Override
    public Long getInteger(Object object) throws KettleValueException {
        try {
            if (object == null) {
                return null;
            }
            switch (this.type) {
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            return (Long)object;
                        }
                        case 1: {
                            return (Long)this.convertBinaryStringToNativeType((byte[])object);
                        }
                        case 2: {
                            return (Long)this.index[(Integer)object];
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToInteger((String)object);
                        }
                        case 1: {
                            return this.convertStringToInteger((String)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertStringToInteger((String)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            return new Long(Math.round((Double)object));
                        }
                        case 1: {
                            return new Long(Math.round((Double)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return new Long(Math.round((Double)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertDateToInteger((java.util.Date)object);
                        }
                        case 1: {
                            return new Long(((java.util.Date)this.convertBinaryStringToNativeType((byte[])object)).getTime());
                        }
                        case 2: {
                            return this.convertDateToInteger((java.util.Date)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            return new Long(((BigDecimal)object).longValue());
                        }
                        case 1: {
                            return new Long(((BigDecimal)this.convertBinaryStringToNativeType((byte[])object)).longValue());
                        }
                        case 2: {
                            return new Long(((BigDecimal)this.index[(Integer)object]).longValue());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertBooleanToInteger((Boolean)object);
                        }
                        case 1: {
                            return this.convertBooleanToInteger((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertBooleanToInteger((Boolean)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to integers.");
                }
                case 7: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to integers.");
                }
            }
            throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
        }
        catch (Exception e) {
            throw new KettleValueException("Unexpected conversion error while converting value [" + this.toString() + "] to an Integer", e);
        }
    }

    @Override
    public BigDecimal getBigNumber(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return (BigDecimal)object;
                    }
                    case 1: {
                        return (BigDecimal)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (BigDecimal)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToBigNumber((String)object);
                    }
                    case 1: {
                        return this.convertStringToBigNumber((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToBigNumber((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return BigDecimal.valueOf((Long)object);
                    }
                    case 1: {
                        return BigDecimal.valueOf((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return BigDecimal.valueOf((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return BigDecimal.valueOf((Double)object);
                    }
                    case 1: {
                        return BigDecimal.valueOf((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return BigDecimal.valueOf((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 3: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertDateToBigNumber((java.util.Date)object);
                    }
                    case 1: {
                        return this.convertDateToBigNumber((java.util.Date)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertDateToBigNumber((java.util.Date)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 4: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBooleanToBigNumber((Boolean)object);
                    }
                    case 1: {
                        return this.convertBooleanToBigNumber((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBooleanToBigNumber((Boolean)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to integers.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to integers.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    @Override
    public Boolean getBoolean(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 4: {
                switch (this.storageType) {
                    case 0: {
                        return (Boolean)object;
                    }
                    case 1: {
                        return (Boolean)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (Boolean)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return ValueMetaBase.convertStringToBoolean(this.trim((String)object));
                    }
                    case 1: {
                        return ValueMetaBase.convertStringToBoolean(this.trim((String)this.convertBinaryStringToNativeType((byte[])object)));
                    }
                    case 2: {
                        return ValueMetaBase.convertStringToBoolean(this.trim((String)this.index[(Integer)object]));
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToBoolean((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToBoolean((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToBoolean((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToBoolean((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToBoolean((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToBoolean((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToBoolean((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToBoolean((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToBoolean((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 3: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert date values to booleans.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to booleans.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to booleans.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    @Override
    public java.util.Date getDate(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 3: {
                switch (this.storageType) {
                    case 0: {
                        return (java.util.Date)object;
                    }
                    case 1: {
                        return (java.util.Date)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (java.util.Date)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToDate((String)object);
                    }
                    case 1: {
                        return this.convertStringToDate((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToDate((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToDate((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToDate((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToDate((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToDate((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToDate((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToDate((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToDate((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToDate((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToDate((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 4: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a boolean to a date.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a binary value to date.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a serializable value to date.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    @Override
    public byte[] getBinary(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 8: {
                switch (this.storageType) {
                    case 0: {
                        return (byte[])object;
                    }
                    case 1: {
                        return (byte[])object;
                    }
                    case 2: {
                        return (byte[])this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 3: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a date to binary.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToBinaryString((String)object);
                    }
                    case 1: {
                        return (byte[])object;
                    }
                    case 2: {
                        return this.convertStringToBinaryString((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a number to binary.");
            }
            case 5: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert an integer to binary.");
            }
            case 6: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a bignumber to binary.");
            }
            case 4: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a boolean to binary.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a serializable to binary.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    @Override
    public byte[] getBinaryString(Object object) throws KettleValueException {
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        try {
            if (object == null) {
                return null;
            }
            switch (this.type) {
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString((String)object);
                        }
                        case 1: {
                            return this.convertStringToBinaryString((String)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertStringToBinaryString((String)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertDateToString((java.util.Date)object));
                        }
                        case 1: {
                            String string = this.convertDateToString((java.util.Date)this.convertBinaryStringToNativeType((byte[])object));
                            return this.convertStringToBinaryString(string);
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertDateToString((java.util.Date)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertNumberToString((Double)object));
                        }
                        case 1: {
                            String string = this.convertNumberToString((Double)this.convertBinaryStringToNativeType((byte[])object));
                            return this.convertStringToBinaryString(string);
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertNumberToString((Double)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertIntegerToString((Long)object));
                        }
                        case 1: {
                            String string = this.convertIntegerToString((Long)this.convertBinaryStringToNativeType((byte[])object));
                            return this.convertStringToBinaryString(string);
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertIntegerToString((Long)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertBigNumberToString((BigDecimal)object));
                        }
                        case 1: {
                            String string = this.convertBigNumberToString((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                            return this.convertStringToBinaryString(string);
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertBigNumberToString((BigDecimal)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertBooleanToString((Boolean)object));
                        }
                        case 1: {
                            String string = this.convertBooleanToString((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                            return this.convertStringToBinaryString(string);
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertBooleanToString((Boolean)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    switch (this.storageType) {
                        case 0: {
                            return (byte[])object;
                        }
                        case 1: {
                            return (byte[])object;
                        }
                        case 2: {
                            return (byte[])this.index[(Integer)object];
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 7: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(object.toString());
                        }
                        case 1: {
                            return (byte[])object;
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.index[(Integer)object].toString());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
            }
            throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
        }
        catch (ClassCastException e) {
            throw new KettleValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    @Override
    public boolean isString() {
        return this.type == 2;
    }

    @Override
    public boolean isDate() {
        return this.type == 3 || this.type == 9;
    }

    @Override
    public boolean isBigNumber() {
        return this.type == 6;
    }

    @Override
    public boolean isNumber() {
        return this.type == 1;
    }

    @Override
    public boolean isBoolean() {
        return this.type == 4;
    }

    @Override
    public boolean isSerializableType() {
        return this.type == 7;
    }

    @Override
    public boolean isBinary() {
        return this.type == 8;
    }

    @Override
    public boolean isInteger() {
        return this.type == 5;
    }

    @Override
    public boolean isNumeric() {
        return this.isInteger() || this.isNumber() || this.isBigNumber();
    }

    public static final boolean isNumeric(int t) {
        return t == 5 || t == 1 || t == 6;
    }

    public boolean isSortedAscending() {
        return !this.isSortedDescending();
    }

    @Override
    public String getTypeDesc() {
        return ValueMetaBase.getTypeDesc(this.type);
    }

    public String getStorageTypeDesc() {
        return storageTypeCodes[this.storageType];
    }

    public String toString() {
        return this.name + " " + this.toStringMeta();
    }

    @Override
    public String toStringMeta() {
        StringBuffer retval = new StringBuffer(this.getTypeDesc());
        switch (this.getType()) {
            case 2: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength()).append(')');
                break;
            }
            case 1: 
            case 6: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength());
                if (this.getPrecision() > 0) {
                    retval.append(", ").append(this.getPrecision());
                }
                retval.append(')');
                break;
            }
            case 5: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength()).append(')');
                break;
            }
        }
        if (!this.isStorageNormal()) {
            retval.append("<").append(this.getStorageTypeDesc()).append(">");
        }
        return retval.toString();
    }

    @Override
    public void writeData(DataOutputStream outputStream, Object object) throws KettleFileException {
        try {
            outputStream.writeBoolean(object == null);
            if (object != null) {
                block1 : switch (this.storageType) {
                    case 0: {
                        switch (this.getType()) {
                            case 2: {
                                this.writeString(outputStream, (String)object);
                                break block1;
                            }
                            case 1: {
                                this.writeNumber(outputStream, (Double)object);
                                break block1;
                            }
                            case 5: {
                                this.writeInteger(outputStream, (Long)object);
                                break block1;
                            }
                            case 3: {
                                this.writeDate(outputStream, (java.util.Date)object);
                                break block1;
                            }
                            case 6: {
                                this.writeBigNumber(outputStream, (BigDecimal)object);
                                break block1;
                            }
                            case 4: {
                                this.writeBoolean(outputStream, (Boolean)object);
                                break block1;
                            }
                            case 8: {
                                this.writeBinary(outputStream, (byte[])object);
                                break block1;
                            }
                        }
                        throw new KettleFileException(this.toString() + " : Unable to serialize data type " + this.getType());
                    }
                    case 1: {
                        this.writeBinaryString(outputStream, (byte[])object);
                        break;
                    }
                    case 2: {
                        this.writeInteger(outputStream, (Integer)object);
                        break;
                    }
                    default: {
                        throw new KettleFileException(this.toString() + " : Unknown storage type " + this.getStorageType());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to write value data to output stream", e);
        }
    }

    @Override
    public Object readData(DataInputStream inputStream) throws KettleFileException, KettleEOFException, SocketTimeoutException {
        try {
            if (inputStream.readBoolean()) {
                return null;
            }
            switch (this.storageType) {
                case 0: {
                    switch (this.getType()) {
                        case 2: {
                            return this.readString(inputStream);
                        }
                        case 1: {
                            return this.readNumber(inputStream);
                        }
                        case 5: {
                            return this.readInteger(inputStream);
                        }
                        case 3: {
                            return this.readDate(inputStream);
                        }
                        case 6: {
                            return this.readBigNumber(inputStream);
                        }
                        case 4: {
                            return this.readBoolean(inputStream);
                        }
                        case 8: {
                            return this.readBinary(inputStream);
                        }
                    }
                    throw new KettleFileException(this.toString() + " : Unable to de-serialize data of type " + this.getType());
                }
                case 1: {
                    return this.readBinaryString(inputStream);
                }
                case 2: {
                    return this.readSmallInteger(inputStream);
                }
            }
            throw new KettleFileException(this.toString() + " : Unknown storage type " + this.getStorageType());
        }
        catch (EOFException e) {
            throw new KettleEOFException(e);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to read value data from input stream", e);
        }
    }

    protected void writeString(DataOutputStream outputStream, String string) throws IOException {
        if (string == null) {
            outputStream.writeInt(-1);
        } else {
            byte[] chars = string.getBytes("UTF-8");
            outputStream.writeInt(chars.length);
            outputStream.write(chars);
        }
    }

    protected void writeBinaryString(DataOutputStream outputStream, byte[] binaryString) throws IOException {
        if (binaryString == null) {
            outputStream.writeInt(-1);
        } else {
            outputStream.writeInt(binaryString.length);
            outputStream.write(binaryString);
        }
    }

    protected String readString(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        if (length < 0) {
            return null;
        }
        byte[] chars = new byte[length];
        inputStream.readFully(chars);
        String string = new String(chars, "UTF-8");
        return string;
    }

    protected byte[] readBinaryString(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        if (length < 0) {
            return null;
        }
        byte[] chars = new byte[length];
        inputStream.readFully(chars);
        return chars;
    }

    protected void writeBigNumber(DataOutputStream outputStream, BigDecimal number) throws IOException {
        String string = number.toString();
        this.writeString(outputStream, string);
    }

    protected BigDecimal readBigNumber(DataInputStream inputStream) throws IOException {
        String string = this.readString(inputStream);
        return new BigDecimal(string);
    }

    protected void writeDate(DataOutputStream outputStream, java.util.Date date) throws IOException {
        outputStream.writeLong(date.getTime());
    }

    protected java.util.Date readDate(DataInputStream inputStream) throws IOException {
        long time = inputStream.readLong();
        return new java.util.Date(time);
    }

    protected void writeBoolean(DataOutputStream outputStream, Boolean bool) throws IOException {
        outputStream.writeBoolean(bool);
    }

    protected Boolean readBoolean(DataInputStream inputStream) throws IOException {
        Boolean bool = inputStream.readBoolean();
        return bool;
    }

    protected void writeNumber(DataOutputStream outputStream, Double number) throws IOException {
        outputStream.writeDouble(number);
    }

    protected Double readNumber(DataInputStream inputStream) throws IOException {
        Double d = new Double(inputStream.readDouble());
        return d;
    }

    protected void writeInteger(DataOutputStream outputStream, Long number) throws IOException {
        outputStream.writeLong(number);
    }

    protected Long readInteger(DataInputStream inputStream) throws IOException {
        Long l = new Long(inputStream.readLong());
        return l;
    }

    protected void writeInteger(DataOutputStream outputStream, Integer number) throws IOException {
        outputStream.writeInt(number);
    }

    protected Integer readSmallInteger(DataInputStream inputStream) throws IOException {
        Integer i = inputStream.readInt();
        return i;
    }

    protected void writeBinary(DataOutputStream outputStream, byte[] binary) throws IOException {
        outputStream.writeInt(binary.length);
        outputStream.write(binary);
    }

    protected byte[] readBinary(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        byte[] buffer = new byte[size];
        inputStream.readFully(buffer);
        return buffer;
    }

    @Override
    public void writeMeta(DataOutputStream outputStream) throws KettleFileException {
        try {
            int type = this.getType();
            outputStream.writeInt(type);
            outputStream.writeInt(this.storageType);
            switch (this.storageType) {
                case 2: {
                    if (this.index == null) {
                        outputStream.writeInt(-1);
                        break;
                    }
                    outputStream.writeInt(this.index.length);
                    for (int i = 0; i < this.index.length; ++i) {
                        try {
                            switch (type) {
                                case 2: {
                                    this.writeString(outputStream, (String)this.index[i]);
                                    break;
                                }
                                case 1: {
                                    this.writeNumber(outputStream, (Double)this.index[i]);
                                    break;
                                }
                                case 5: {
                                    this.writeInteger(outputStream, (Long)this.index[i]);
                                    break;
                                }
                                case 3: {
                                    this.writeDate(outputStream, (java.util.Date)this.index[i]);
                                    break;
                                }
                                case 6: {
                                    this.writeBigNumber(outputStream, (BigDecimal)this.index[i]);
                                    break;
                                }
                                case 4: {
                                    this.writeBoolean(outputStream, (Boolean)this.index[i]);
                                    break;
                                }
                                case 8: {
                                    this.writeBinary(outputStream, (byte[])this.index[i]);
                                    break;
                                }
                                default: {
                                    throw new KettleFileException(this.toString() + " : Unable to serialize indexe storage type for data type " + this.getType());
                                }
                            }
                            continue;
                        }
                        catch (ClassCastException e) {
                            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + this.index[i].getClass().getName() + " object [" + this.index[i] + "] does not correspond to value meta [" + this.toStringMeta() + "]");
                        }
                    }
                    break;
                }
                case 1: {
                    outputStream.writeBoolean(this.storageMetadata != null);
                    if (this.storageMetadata == null) break;
                    this.storageMetadata.writeMeta(outputStream);
                    break;
                }
            }
            this.writeString(outputStream, this.name);
            outputStream.writeInt(this.getLength());
            outputStream.writeInt(this.getPrecision());
            this.writeString(outputStream, this.origin);
            this.writeString(outputStream, this.comments);
            this.writeString(outputStream, this.conversionMask);
            this.writeString(outputStream, this.decimalSymbol);
            this.writeString(outputStream, this.groupingSymbol);
            this.writeString(outputStream, this.currencySymbol);
            outputStream.writeInt(this.trimType);
            outputStream.writeBoolean(this.caseInsensitive);
            outputStream.writeBoolean(this.sortedDescending);
            outputStream.writeBoolean(this.outputPaddingEnabled);
            outputStream.writeBoolean(this.dateFormatLenient);
            this.writeString(outputStream, this.dateFormatLocale != null ? this.dateFormatLocale.toString() : null);
            this.writeString(outputStream, this.dateFormatTimeZone != null ? this.dateFormatTimeZone.toString() : null);
            outputStream.writeBoolean(this.lenientStringToNumber);
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to write value metadata to output stream", e);
        }
    }

    @Deprecated
    public ValueMetaBase(DataInputStream inputStream) throws KettleFileException, KettleEOFException {
        this();
        try {
            this.type = inputStream.readInt();
        }
        catch (EOFException e) {
            throw new KettleEOFException(e);
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to read value metadata from input stream", e);
        }
        this.readMetaData(inputStream);
    }

    @Override
    public void readMetaData(DataInputStream inputStream) throws KettleFileException, KettleEOFException {
        try {
            this.storageType = inputStream.readInt();
            switch (this.storageType) {
                case 2: {
                    int indexSize = inputStream.readInt();
                    if (indexSize < 0) {
                        this.index = null;
                        break;
                    }
                    this.index = new Object[indexSize];
                    block16: for (int i = 0; i < indexSize; ++i) {
                        switch (this.type) {
                            case 2: {
                                this.index[i] = this.readString(inputStream);
                                continue block16;
                            }
                            case 1: {
                                this.index[i] = this.readNumber(inputStream);
                                continue block16;
                            }
                            case 5: {
                                this.index[i] = this.readInteger(inputStream);
                                continue block16;
                            }
                            case 3: {
                                this.index[i] = this.readDate(inputStream);
                                continue block16;
                            }
                            case 6: {
                                this.index[i] = this.readBigNumber(inputStream);
                                continue block16;
                            }
                            case 4: {
                                this.index[i] = this.readBoolean(inputStream);
                                continue block16;
                            }
                            case 8: {
                                this.index[i] = this.readBinary(inputStream);
                                continue block16;
                            }
                            default: {
                                throw new KettleFileException(this.toString() + " : Unable to de-serialize indexed storage type for data type " + this.getType());
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    if (!inputStream.readBoolean()) break;
                    this.storageMetadata = new ValueMetaBase(inputStream);
                    break;
                }
            }
            this.name = this.readString(inputStream);
            this.length = inputStream.readInt();
            this.precision = inputStream.readInt();
            this.origin = this.readString(inputStream);
            this.comments = this.readString(inputStream);
            this.conversionMask = this.readString(inputStream);
            this.decimalSymbol = this.readString(inputStream);
            this.groupingSymbol = this.readString(inputStream);
            this.currencySymbol = this.readString(inputStream);
            this.trimType = inputStream.readInt();
            this.caseInsensitive = inputStream.readBoolean();
            this.sortedDescending = inputStream.readBoolean();
            this.outputPaddingEnabled = inputStream.readBoolean();
            this.dateFormatLenient = inputStream.readBoolean();
            String strDateFormatLocale = this.readString(inputStream);
            this.dateFormatLocale = Const.isEmpty(strDateFormatLocale) ? null : EnvUtil.createLocale(strDateFormatLocale);
            String strTimeZone = this.readString(inputStream);
            this.dateFormatTimeZone = Const.isEmpty(strTimeZone) ? TimeZone.getDefault() : EnvUtil.createTimeZone(strTimeZone);
            this.lenientStringToNumber = inputStream.readBoolean();
        }
        catch (EOFException e) {
            throw new KettleEOFException(e);
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to read value metadata from input stream", e);
        }
    }

    @Override
    public String getMetaXML() throws IOException {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag(XML_META_TAG));
        xml.append(XMLHandler.addTagValue("type", this.getTypeDesc()));
        xml.append(XMLHandler.addTagValue("storagetype", ValueMetaBase.getStorageTypeCode(this.getStorageType())));
        switch (this.storageType) {
            case 2: {
                xml.append(XMLHandler.openTag("index"));
                if (this.index != null) {
                    for (int i = 0; i < this.index.length; ++i) {
                        try {
                            switch (this.type) {
                                case 2: {
                                    xml.append(XMLHandler.addTagValue("value", (String)this.index[i]));
                                    break;
                                }
                                case 1: {
                                    xml.append(XMLHandler.addTagValue("value", (Double)this.index[i]));
                                    break;
                                }
                                case 5: {
                                    xml.append(XMLHandler.addTagValue("value", (Long)this.index[i]));
                                    break;
                                }
                                case 3: {
                                    xml.append(XMLHandler.addTagValue("value", (java.util.Date)this.index[i]));
                                    break;
                                }
                                case 6: {
                                    xml.append(XMLHandler.addTagValue("value", (BigDecimal)this.index[i]));
                                    break;
                                }
                                case 4: {
                                    xml.append(XMLHandler.addTagValue("value", (boolean)((Boolean)this.index[i])));
                                    break;
                                }
                                case 8: {
                                    xml.append(XMLHandler.addTagValue("value", (byte[])this.index[i]));
                                    break;
                                }
                                default: {
                                    throw new IOException(this.toString() + " : Unable to serialize index storage type to XML for data type " + this.getType());
                                }
                            }
                            continue;
                        }
                        catch (ClassCastException e) {
                            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + this.index[i].getClass().getName() + " object [" + this.index[i] + "] does not correspond to value meta [" + this.toStringMeta() + "]");
                        }
                    }
                }
                xml.append(XMLHandler.closeTag("index"));
                break;
            }
            case 1: {
                if (this.storageMetadata == null) break;
                xml.append(XMLHandler.openTag("storage-meta"));
                xml.append(this.storageMetadata.getMetaXML());
                xml.append(XMLHandler.closeTag("storage-meta"));
                break;
            }
        }
        xml.append(XMLHandler.addTagValue("name", this.name));
        xml.append(XMLHandler.addTagValue("length", this.length));
        xml.append(XMLHandler.addTagValue("precision", this.precision));
        xml.append(XMLHandler.addTagValue("origin", this.origin));
        xml.append(XMLHandler.addTagValue("comments", this.comments));
        xml.append(XMLHandler.addTagValue("conversion_Mask", this.conversionMask));
        xml.append(XMLHandler.addTagValue("decimal_symbol", this.decimalSymbol));
        xml.append(XMLHandler.addTagValue("grouping_symbol", this.groupingSymbol));
        xml.append(XMLHandler.addTagValue("currency_symbol", this.currencySymbol));
        xml.append(XMLHandler.addTagValue("trim_type", ValueMetaBase.getTrimTypeCode(this.trimType)));
        xml.append(XMLHandler.addTagValue("case_insensitive", this.caseInsensitive));
        xml.append(XMLHandler.addTagValue("sort_descending", this.sortedDescending));
        xml.append(XMLHandler.addTagValue("output_padding", this.outputPaddingEnabled));
        xml.append(XMLHandler.addTagValue("date_format_lenient", this.dateFormatLenient));
        xml.append(XMLHandler.addTagValue("date_format_locale", this.dateFormatLocale != null ? this.dateFormatLocale.toString() : null));
        xml.append(XMLHandler.addTagValue("date_format_timezone", this.dateFormatTimeZone != null ? this.dateFormatTimeZone.getID() : null));
        xml.append(XMLHandler.addTagValue("lenient_string_to_number", this.lenientStringToNumber));
        xml.append(XMLHandler.closeTag(XML_META_TAG));
        return xml.toString();
    }

    public ValueMetaBase(Node node) throws KettleException {
        this();
        String dateTimeZoneString;
        this.type = ValueMetaBase.getType(XMLHandler.getTagValue(node, "type"));
        this.storageType = ValueMetaBase.getStorageType(XMLHandler.getTagValue(node, "storagetype"));
        switch (this.storageType) {
            case 2: {
                Node indexNode = XMLHandler.getSubNode(node, "index");
                int nrIndexes = XMLHandler.countNodes(indexNode, "value");
                this.index = new Object[nrIndexes];
                block13: for (int i = 0; i < this.index.length; ++i) {
                    Node valueNode = XMLHandler.getSubNodeByNr(indexNode, "value", i);
                    String valueString = XMLHandler.getNodeValue(valueNode);
                    if (Const.isEmpty(valueString)) {
                        this.index[i] = null;
                        continue;
                    }
                    switch (this.type) {
                        case 2: {
                            this.index[i] = valueString;
                            continue block13;
                        }
                        case 1: {
                            this.index[i] = Double.parseDouble(valueString);
                            continue block13;
                        }
                        case 5: {
                            this.index[i] = Long.parseLong(valueString);
                            continue block13;
                        }
                        case 3: {
                            this.index[i] = XMLHandler.stringToDate(valueString);
                            continue block13;
                        }
                        case 6: {
                            this.index[i] = new BigDecimal(valueString);
                            continue block13;
                        }
                        case 4: {
                            this.index[i] = "Y".equalsIgnoreCase(valueString);
                            continue block13;
                        }
                        case 8: {
                            this.index[i] = XMLHandler.stringToBinary(valueString);
                            continue block13;
                        }
                        default: {
                            throw new KettleException(this.toString() + " : Unable to de-serialize indexe storage type from XML for data type " + this.getType());
                        }
                    }
                }
                break;
            }
            case 1: {
                Node storageMetaNode = XMLHandler.getSubNode(node, "storage-meta");
                Node storageValueMetaNode = XMLHandler.getSubNode(storageMetaNode, XML_META_TAG);
                if (storageValueMetaNode == null) break;
                this.storageMetadata = new ValueMetaBase(storageValueMetaNode);
                break;
            }
        }
        this.name = XMLHandler.getTagValue(node, "name");
        this.length = Integer.parseInt(XMLHandler.getTagValue(node, "length"));
        this.precision = Integer.parseInt(XMLHandler.getTagValue(node, "precision"));
        this.origin = XMLHandler.getTagValue(node, "origin");
        this.comments = XMLHandler.getTagValue(node, "comments");
        this.conversionMask = XMLHandler.getTagValue(node, "conversion_Mask");
        this.decimalSymbol = XMLHandler.getTagValue(node, "decimal_symbol");
        this.groupingSymbol = XMLHandler.getTagValue(node, "grouping_symbol");
        this.currencySymbol = XMLHandler.getTagValue(node, "currency_symbol");
        this.trimType = ValueMetaBase.getTrimTypeByCode(XMLHandler.getTagValue(node, "trim_type"));
        this.caseInsensitive = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "case_insensitive"));
        this.sortedDescending = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "sort_descending"));
        this.outputPaddingEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "output_padding"));
        this.dateFormatLenient = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "date_format_lenient"));
        String dateFormatLocaleString = XMLHandler.getTagValue(node, "date_format_locale");
        if (!Const.isEmpty(dateFormatLocaleString)) {
            this.dateFormatLocale = EnvUtil.createLocale(dateFormatLocaleString);
        }
        this.dateFormatTimeZone = !Const.isEmpty(dateTimeZoneString = XMLHandler.getTagValue(node, "date_format_timezone")) ? EnvUtil.createTimeZone(dateTimeZoneString) : TimeZone.getDefault();
        this.lenientStringToNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "lenient_string_to_number"));
    }

    @Override
    public String getDataXML(Object object) throws IOException {
        String string;
        StringBuffer xml = new StringBuffer();
        if (object != null) {
            try {
                block1 : switch (this.storageType) {
                    case 0: {
                        switch (this.getType()) {
                            case 2: {
                                string = (String)object;
                                break block1;
                            }
                            case 1: {
                                string = Double.toString((Double)object);
                                break block1;
                            }
                            case 5: {
                                string = Long.toString((Long)object);
                                break block1;
                            }
                            case 3: {
                                string = XMLHandler.date2string((java.util.Date)object);
                                break block1;
                            }
                            case 6: {
                                string = ((BigDecimal)object).toString();
                                break block1;
                            }
                            case 4: {
                                string = Boolean.toString((Boolean)object);
                                break block1;
                            }
                            case 8: {
                                string = XMLHandler.encodeBinaryData((byte[])object);
                                break block1;
                            }
                        }
                        throw new IOException(this.toString() + " : Unable to serialize data type to XML " + this.getType());
                    }
                    case 1: {
                        string = XMLHandler.addTagValue("binary-string", (byte[])object);
                        break;
                    }
                    case 2: {
                        string = XMLHandler.addTagValue("index-value", (int)((Integer)object));
                        break;
                    }
                    default: {
                        throw new IOException(this.toString() + " : Unknown storage type " + this.getStorageType());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]", e);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " : there was a value XML encoding error", e);
            }
        } else {
            string = "";
        }
        xml.append(XMLHandler.addTagValue(XML_DATA_TAG, string));
        return xml.toString();
    }

    @Override
    public Object getValue(Node node) throws KettleException {
        switch (this.storageType) {
            case 0: {
                String valueString = XMLHandler.getNodeValue(node);
                if (Const.isEmpty(valueString)) {
                    return null;
                }
                switch (this.getType()) {
                    case 2: {
                        return valueString;
                    }
                    case 1: {
                        return Double.parseDouble(valueString);
                    }
                    case 5: {
                        return Long.parseLong(valueString);
                    }
                    case 3: {
                        return XMLHandler.stringToDate(valueString);
                    }
                    case 6: {
                        return new BigDecimal(valueString);
                    }
                    case 4: {
                        return "Y".equalsIgnoreCase(valueString);
                    }
                    case 8: {
                        return XMLHandler.stringToBinary(XMLHandler.getTagValue(node, "binary-value"));
                    }
                }
                throw new KettleException(this.toString() + " : Unable to de-serialize '" + valueString + "' from XML for data type " + this.getType());
            }
            case 1: {
                String binaryString = XMLHandler.getTagValue(node, "binary-string");
                if (Const.isEmpty(binaryString)) {
                    return null;
                }
                return XMLHandler.stringToBinary(binaryString);
            }
            case 2: {
                String indexString = XMLHandler.getTagValue(node, "index-value");
                if (Const.isEmpty(indexString)) {
                    return null;
                }
                return Integer.parseInt(indexString);
            }
        }
        throw new KettleException(this.toString() + " : Unknown storage type " + this.getStorageType());
    }

    public static final String[] getTypes() {
        return ValueMetaFactory.getValueMetaNames();
    }

    public static final String[] getAllTypes() {
        return ValueMetaFactory.getAllValueMetaNames();
    }

    public static final String getTypeDesc(int type) {
        return ValueMetaFactory.getValueMetaName(type);
    }

    public static final int getType(String desc) {
        return ValueMetaFactory.getIdForValueMeta(desc);
    }

    public static final int getStorageType(String desc) {
        for (int i = 0; i < storageTypeCodes.length; ++i) {
            if (!storageTypeCodes[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return -1;
    }

    public static final String getStorageTypeCode(int storageType) {
        if (storageType >= 0 && storageType <= 2) {
            return storageTypeCodes[storageType];
        }
        return null;
    }

    @Override
    public boolean isNull(Object data) throws KettleValueException {
        try {
            Object value = data;
            if (this.isStorageBinaryString()) {
                if (value == null || !EMPTY_STRING_AND_NULL_ARE_DIFFERENT && ((byte[])value).length == 0) {
                    return true;
                }
                value = this.convertBinaryStringToNativeType((byte[])data);
            }
            if (value == null) {
                return true;
            }
            if (EMPTY_STRING_AND_NULL_ARE_DIFFERENT) {
                return false;
            }
            return this.isString() && value.toString().length() == 0;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to verify if [" + this.toString() + "] is null or not because of an error:" + e.toString(), e);
        }
    }

    @Override
    public int compare(Object data1, Object data2) throws KettleValueException {
        boolean n1 = this.isNull(data1);
        boolean n2 = this.isNull(data2);
        if (n1 && !n2) {
            return -1;
        }
        if (!n1 && n2) {
            return 1;
        }
        if (n1 && n2) {
            return 0;
        }
        int cmp = 0;
        switch (this.getType()) {
            case 2: {
                String one = this.getString(data1);
                String two = this.getString(data2);
                if (this.caseInsensitive) {
                    cmp = one.compareToIgnoreCase(two);
                    break;
                }
                cmp = one.compareTo(two);
                break;
            }
            case 5: {
                cmp = this.getInteger(data1).compareTo(this.getInteger(data2));
                break;
            }
            case 1: {
                cmp = Double.compare(this.getNumber(data1), this.getNumber(data2));
                break;
            }
            case 3: {
                cmp = Long.valueOf(this.getDate(data1).getTime()).compareTo(this.getDate(data2).getTime());
                break;
            }
            case 6: {
                cmp = this.getBigNumber(data1).compareTo(this.getBigNumber(data2));
                break;
            }
            case 4: {
                if (this.getBoolean(data1).booleanValue() == this.getBoolean(data2).booleanValue()) {
                    cmp = 0;
                    break;
                }
                if (this.getBoolean(data1).booleanValue() && !this.getBoolean(data2).booleanValue()) {
                    cmp = 1;
                    break;
                }
                cmp = -1;
                break;
            }
            case 8: {
                byte[] b1 = (byte[])data1;
                byte[] b2 = (byte[])data2;
                int length = b1.length < b2.length ? b1.length : b2.length;
                for (int i = 0; i < length; ++i) {
                    cmp = b1[i] - b2[i];
                    if (cmp == 0) continue;
                    cmp = cmp < 0 ? -1 : 1;
                    break;
                }
                cmp = b1.length - b2.length;
                break;
            }
            default: {
                throw new KettleValueException(this.toString() + " : Comparing values can not be done with data type : " + this.getType());
            }
        }
        if (this.isSortedDescending()) {
            return -cmp;
        }
        return cmp;
    }

    @Override
    public int compare(Object data1, ValueMetaInterface meta2, Object data2) throws KettleValueException {
        if (meta2 == null) {
            throw new KettleValueException(this.toStringMeta() + " : Second meta data (meta2) is null, please check one of the previous steps.");
        }
        try {
            if (this.getType() == meta2.getType()) {
                if (this.getStorageType() == meta2.getStorageType()) {
                    return this.compare(data1, data2);
                }
                switch (this.getStorageType()) {
                    case 0: {
                        return this.compare(data1, meta2.convertToNormalStorageType(data2));
                    }
                    case 1: {
                        return this.compare(data1, meta2.convertToBinaryStringStorageType(data2));
                    }
                    case 2: {
                        switch (meta2.getStorageType()) {
                            case 2: {
                                return this.compare(data1, data2);
                            }
                            case 0: {
                                return -meta2.compare(data2, this.convertToNormalStorageType(data1));
                            }
                            case 1: {
                                return -meta2.compare(data2, this.convertToBinaryStringStorageType(data1));
                            }
                        }
                        throw new KettleValueException(meta2.toStringMeta() + " : Unknown storage type : " + meta2.getStorageType());
                    }
                }
                throw new KettleValueException(this.toStringMeta() + " : Unknown storage type : " + this.getStorageType());
            }
            return this.compare(data1, this.convertData(meta2, data2));
        }
        catch (Exception e) {
            throw new KettleValueException(this.toStringMeta() + " : Unable to compare with value [" + meta2.toStringMeta() + "]", e);
        }
    }

    @Override
    public Object convertData(ValueMetaInterface meta2, Object data2) throws KettleValueException {
        switch (this.getType()) {
            case 2: {
                return meta2.getString(data2);
            }
            case 1: {
                return meta2.getNumber(data2);
            }
            case 5: {
                return meta2.getInteger(data2);
            }
            case 3: {
                return meta2.getDate(data2);
            }
            case 6: {
                return meta2.getBigNumber(data2);
            }
            case 4: {
                return meta2.getBoolean(data2);
            }
            case 8: {
                return meta2.getBinary(data2);
            }
        }
        throw new KettleValueException(this.toString() + " : I can't convert the specified value to data type : " + this.getType());
    }

    @Override
    public Object convertDataCompatible(ValueMetaInterface meta2, Object data2) throws KettleValueException {
        switch (this.getType()) {
            case 2: {
                return meta2.getCompatibleString(data2);
            }
            case 1: {
                return meta2.getNumber(data2);
            }
            case 5: {
                return meta2.getInteger(data2);
            }
            case 3: {
                return meta2.getDate(data2);
            }
            case 6: {
                return meta2.getBigNumber(data2);
            }
            case 4: {
                return meta2.getBoolean(data2);
            }
            case 8: {
                return meta2.getBinary(data2);
            }
        }
        throw new KettleValueException(this.toString() + " : I can't convert the specified value to data type : " + this.getType());
    }

    @Override
    public Object convertDataUsingConversionMetaData(Object data) throws KettleValueException {
        if (this.conversionMetadata == null) {
            throw new KettleValueException("API coding error: please specify the conversion metadata before attempting to convert value " + this.name);
        }
        switch (this.conversionMetadata.getType()) {
            case 2: {
                return this.getString(data);
            }
            case 5: {
                return this.getInteger(data);
            }
            case 1: {
                return this.getNumber(data);
            }
            case 3: {
                return this.getDate(data);
            }
            case 6: {
                return this.getBigNumber(data);
            }
            case 4: {
                return this.getBoolean(data);
            }
            case 8: {
                return this.getBinary(data);
            }
        }
        throw new KettleValueException(this.toString() + " : I can't convert the specified value to data type : " + this.storageMetadata.getType());
    }

    @Override
    public Object convertDataFromString(String pol, ValueMetaInterface convertMeta, String nullIf, String ifNull, int trim_type) throws KettleValueException {
        String emptyValue;
        if (convertMeta == null) {
            throw new KettleValueException("API coding error: convertMeta input parameter should not be equals to null");
        }
        String null_value = nullIf;
        int inValueType = convertMeta.getType();
        int outValueType = this.getType();
        if (null_value == null) {
            switch (inValueType) {
                case 4: {
                    null_value = "";
                    break;
                }
                case 2: {
                    null_value = "";
                    break;
                }
                case 6: {
                    null_value = "";
                    break;
                }
                case 1: {
                    null_value = "";
                    break;
                }
                case 5: {
                    null_value = "";
                    break;
                }
                case 3: {
                    null_value = "";
                    break;
                }
                case 8: {
                    null_value = "";
                    break;
                }
                default: {
                    null_value = "";
                }
            }
        }
        if (!Const.isEmpty(ifNull) && (Const.isEmpty(pol) || pol.equalsIgnoreCase(Const.rightPad(new StringBuffer(null_value), pol.length())))) {
            pol = ifNull;
        }
        String string = emptyValue = outValueType == 2 ? "" : null;
        if (pol == null) {
            return null;
        }
        if (Const.isEmpty(pol) && outValueType != 2) {
            return null;
        }
        if (!Const.isEmpty(null_value) ? null_value.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad(new StringBuffer(null_value), pol.length())) : Const.onlySpaces(pol)) {
            return emptyValue;
        }
        switch (trim_type) {
            case 1: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    @Override
    public int hashCode(Object object) throws KettleValueException {
        int hash = 0;
        if (this.isNull(object)) {
            switch (this.getType()) {
                case 4: {
                    hash ^= 1;
                    break;
                }
                case 3: {
                    hash ^= 2;
                    break;
                }
                case 1: {
                    hash ^= 4;
                    break;
                }
                case 2: {
                    hash ^= 8;
                    break;
                }
                case 5: {
                    hash ^= 0x10;
                    break;
                }
                case 6: {
                    hash ^= 0x20;
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 4: {
                    hash ^= this.getBoolean(object).hashCode();
                    break;
                }
                case 3: {
                    hash ^= this.getDate(object).hashCode();
                    break;
                }
                case 5: {
                    hash ^= this.getInteger(object).hashCode();
                    break;
                }
                case 1: {
                    hash ^= this.getNumber(object).hashCode();
                    break;
                }
                case 2: {
                    hash ^= this.getString(object).hashCode();
                    break;
                }
                case 6: {
                    hash ^= this.getBigNumber(object).hashCode();
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
        return hash;
    }

    @Override
    public Value createOriginalValue(Object data) throws KettleValueException {
        Value value = new Value(this.name, this.type);
        value.setLength(this.length, this.precision);
        if (this.isNull(data)) {
            value.setNull();
        } else {
            switch (value.getType()) {
                case 2: {
                    value.setValue(this.getString(data));
                    break;
                }
                case 1: {
                    value.setValue(this.getNumber(data));
                    break;
                }
                case 5: {
                    value.setValue(this.getInteger(data));
                    break;
                }
                case 3: {
                    value.setValue(this.getDate(data));
                    break;
                }
                case 4: {
                    value.setValue((boolean)this.getBoolean(data));
                    break;
                }
                case 6: {
                    value.setValue(this.getBigNumber(data));
                    break;
                }
                case 8: {
                    value.setValue(this.getBinary(data));
                    break;
                }
                default: {
                    throw new KettleValueException(this.toString() + " : We can't convert data type " + this.getTypeDesc() + " to an original (V2) Value");
                }
            }
        }
        return value;
    }

    @Override
    public Object getValueData(Value value) throws KettleValueException {
        if (value == null || value.isNull()) {
            return null;
        }
        switch (this.getType()) {
            case 2: {
                return value.getString();
            }
            case 1: {
                return value.getNumber();
            }
            case 5: {
                return value.getInteger();
            }
            case 3: {
                return value.getDate();
            }
            case 4: {
                return value.getBoolean();
            }
            case 6: {
                return value.getBigNumber();
            }
            case 8: {
                return value.getBytes();
            }
        }
        throw new KettleValueException(this.toString() + " : We can't convert original data type " + value.getTypeDesc() + " to a primitive data type");
    }

    @Override
    public ValueMetaInterface getStorageMetadata() {
        return this.storageMetadata;
    }

    @Override
    public void setStorageMetadata(ValueMetaInterface storageMetadata) {
        this.storageMetadata = storageMetadata;
        this.compareStorageAndActualFormat();
    }

    protected void compareStorageAndActualFormat() {
        if (this.storageMetadata == null) {
            this.identicalFormat = true;
        } else if (this.trimType != 0) {
            this.identicalFormat = false;
        } else if (this.getStringEncoding() != null && this.getStringEncoding().equals(this.storageMetadata.getStringEncoding()) || this.getStringEncoding() == null && this.storageMetadata.getStringEncoding() == null) {
            if (this.isDate()) {
                this.identicalFormat = this.getConversionMask() != null && this.getConversionMask().equals(this.storageMetadata.getConversionMask()) || this.getConversionMask() == null && this.storageMetadata.getConversionMask() == null;
            } else if (this.isNumeric()) {
                this.identicalFormat = this.getLength() != this.storageMetadata.getLength() ? false : (this.getPrecision() != this.storageMetadata.getPrecision() ? false : (this.getConversionMask() != null && this.getConversionMask().equals(this.storageMetadata.getConversionMask()) || this.getConversionMask() == null && this.storageMetadata.getConversionMask() == null ? (this.getGroupingSymbol() != null && this.getGroupingSymbol().equals(this.storageMetadata.getGroupingSymbol()) || this.getConversionMask() == null && this.storageMetadata.getConversionMask() == null ? this.getDecimalFormat(false) != null && this.getDecimalFormat(false).equals(this.storageMetadata.getDecimalFormat(false)) || this.getDecimalFormat(false) == null && this.storageMetadata.getDecimalFormat(false) == null : false) : false));
            }
        }
    }

    @Override
    public int getTrimType() {
        return this.trimType;
    }

    @Override
    public void setTrimType(int trimType) {
        this.trimType = trimType;
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ValueMetaBase.getTrimTypeByCode(tt);
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    @Override
    public ValueMetaInterface getConversionMetadata() {
        return this.conversionMetadata;
    }

    @Override
    public void setConversionMetadata(ValueMetaInterface conversionMetadata) {
        this.conversionMetadata = conversionMetadata;
    }

    @Override
    public boolean isSingleByteEncoding() {
        return this.singleByteEncoding;
    }

    @Override
    public long getNumberOfBinaryStringConversions() {
        return this.numberOfBinaryStringConversions;
    }

    @Override
    public void setNumberOfBinaryStringConversions(long numberOfBinaryStringConversions) {
        this.numberOfBinaryStringConversions = numberOfBinaryStringConversions;
    }

    @Override
    public boolean isOriginalAutoIncrement() {
        return this.originalAutoIncrement;
    }

    @Override
    public void setOriginalAutoIncrement(boolean originalAutoIncrement) {
        this.originalAutoIncrement = originalAutoIncrement;
    }

    @Override
    public int getOriginalColumnType() {
        return this.originalColumnType;
    }

    @Override
    public void setOriginalColumnType(int originalColumnType) {
        this.originalColumnType = originalColumnType;
    }

    @Override
    public String getOriginalColumnTypeName() {
        return this.originalColumnTypeName;
    }

    @Override
    public void setOriginalColumnTypeName(String originalColumnTypeName) {
        this.originalColumnTypeName = originalColumnTypeName;
    }

    @Override
    public int isOriginalNullable() {
        return this.originalNullable;
    }

    @Override
    public void setOriginalNullable(int originalNullable) {
        this.originalNullable = originalNullable;
    }

    @Override
    public int getOriginalPrecision() {
        return this.originalPrecision;
    }

    @Override
    public void setOriginalPrecision(int originalPrecision) {
        this.originalPrecision = originalPrecision;
    }

    @Override
    public int getOriginalScale() {
        return this.originalScale;
    }

    @Override
    public void setOriginalScale(int originalScale) {
        this.originalScale = originalScale;
    }

    @Override
    public boolean isOriginalSigned() {
        return this.originalSigned;
    }

    @Override
    public void setOriginalSigned(boolean originalSigned) {
        this.originalSigned = originalSigned;
    }

    public boolean isBigNumberFormatting() {
        return this.bigNumberFormatting;
    }

    public void setBigNumberFormatting(boolean bigNumberFormatting) {
        this.bigNumberFormatting = bigNumberFormatting;
    }

    public static String[] getTrimTypeCodes() {
        return trimTypeCode;
    }

    public static String[] getTrimTypeDescriptions() {
        return trimTypeDesc;
    }

    @Override
    public boolean requiresRealClone() {
        return this.type == 8 || this.type == 7;
    }

    @Override
    public boolean isLenientStringToNumber() {
        return this.lenientStringToNumber;
    }

    @Override
    public void setLenientStringToNumber(boolean lenientStringToNumber) {
        this.lenientStringToNumber = lenientStringToNumber;
    }

    @Override
    public TimeZone getDateFormatTimeZone() {
        return this.dateFormatTimeZone;
    }

    @Override
    public void setDateFormatTimeZone(TimeZone dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
        this.dateFormatChanged = true;
    }

    @Override
    public void drawValue(PrimitiveGCInterface gc, Object value) throws KettleValueException {
        gc.drawText(this.getString(value), 0, 0);
    }

    @Override
    public ValueMetaInterface getValueFromSQLType(DatabaseMeta databaseMeta, String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException {
        try {
            int length = -1;
            int precision = -1;
            int valtype = 0;
            boolean isClob = false;
            int type = rm.getColumnType(index);
            boolean signed = rm.isSigned(index);
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    valtype = 2;
                    if (ignoreLength) break;
                    length = rm.getColumnDisplaySize(index);
                    break;
                }
                case 2005: {
                    valtype = 2;
                    length = 9999999;
                    isClob = true;
                    break;
                }
                case -5: {
                    if (signed) {
                        valtype = 5;
                        precision = 0;
                        length = 15;
                        break;
                    }
                    valtype = 6;
                    precision = 0;
                    length = 16;
                    break;
                }
                case 4: {
                    valtype = 5;
                    precision = 0;
                    length = 9;
                    break;
                }
                case 5: {
                    valtype = 5;
                    precision = 0;
                    length = 4;
                    break;
                }
                case -6: {
                    valtype = 5;
                    precision = 0;
                    length = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    valtype = 1;
                    length = rm.getPrecision(index);
                    precision = rm.getScale(index);
                    if (length >= 126) {
                        length = -1;
                    }
                    if (precision >= 126) {
                        precision = -1;
                    }
                    if (type == 8 || type == 6 || type == 7) {
                        if (precision == 0) {
                            precision = -1;
                        }
                        if (databaseMeta.getDatabaseInterface() instanceof PostgreSQLDatabaseMeta && type == 8 && precision >= 16 && length >= 16) {
                            precision = -1;
                            length = -1;
                        }
                        if (databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta && precision >= length) {
                            precision = -1;
                            length = -1;
                        }
                        if (length > 15 || precision > 15) {
                            valtype = 6;
                        }
                    } else if (precision == 0) {
                        if (length <= 18 && length > 0) {
                            valtype = 5;
                        } else if (length > 18) {
                            valtype = 6;
                        }
                    } else if (length > 15 || precision > 15) {
                        valtype = 6;
                    }
                    if ((databaseMeta.getDatabaseInterface() instanceof PostgreSQLDatabaseMeta || databaseMeta.getDatabaseInterface() instanceof GreenplumDatabaseMeta) && type == 2 && length == 0 && precision == 0) {
                        valtype = 6;
                        length = -1;
                        precision = -1;
                    }
                    if (!(databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta)) break;
                    if (precision == 0 && length == 38) {
                        valtype = 5;
                    }
                    if (precision > 0 || length > 0) break;
                    valtype = 6;
                    length = -1;
                    precision = -1;
                    break;
                }
                case 93: {
                    if (!databaseMeta.supportsTimestampDataType()) break;
                    valtype = 9;
                    length = rm.getScale(index);
                    break;
                }
                case 91: {
                    if (databaseMeta.getDatabaseInterface() instanceof TeradataDatabaseMeta) {
                        precision = 1;
                    }
                }
                case 92: {
                    String property;
                    valtype = 3;
                    if (!(databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta) || (property = databaseMeta.getConnectionProperties().getProperty("yearIsDateType")) == null || !property.equalsIgnoreCase("false") || !rm.getColumnTypeName(index).equalsIgnoreCase("YEAR")) break;
                    valtype = 5;
                    precision = 0;
                    length = 4;
                    break;
                }
                case -7: 
                case 16: {
                    valtype = 4;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    valtype = 8;
                    if (databaseMeta.isDisplaySizeTwiceThePrecision() && 2 * rm.getPrecision(index) == rm.getColumnDisplaySize(index)) {
                        length = rm.getPrecision(index);
                    } else if (databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta && (type == -3 || type == -4)) {
                        valtype = 2;
                        length = rm.getColumnDisplaySize(index);
                    } else if (databaseMeta.isMySQLVariant() && (type == -3 || type == -4)) {
                        valtype = 2;
                        length = -1;
                    } else if (databaseMeta.getDatabaseInterface() instanceof SQLiteDatabaseMeta) {
                        valtype = 2;
                    } else {
                        length = -1;
                    }
                    precision = -1;
                    break;
                }
                default: {
                    valtype = 2;
                    precision = rm.getScale(index);
                }
            }
            ValueMetaInterface v = ValueMetaFactory.createValueMeta(name, valtype);
            v.setLength(length);
            v.setPrecision(precision);
            v.setLargeTextField(isClob);
            this.getOriginalColumnMetadata(v, rm, index, ignoreLength);
            if (lazyConversion && valtype == 2) {
                v.setStorageType(1);
                try {
                    ValueMetaInterface storageMetaData = ValueMetaFactory.cloneValueMeta(v, 2);
                    storageMetaData.setStorageType(0);
                    v.setStorageMetadata(storageMetaData);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
            return v;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error determining value metadata from SQL resultset metadata", e);
        }
    }

    protected void getOriginalColumnMetadata(ValueMetaInterface v, ResultSetMetaData rm, int index, boolean ignoreLength) throws SQLException {
        String comments = rm.getColumnLabel(index);
        v.setComments(comments);
        int originalColumnType = rm.getColumnType(index);
        v.setOriginalColumnType(originalColumnType);
        String originalColumnTypeName = rm.getColumnTypeName(index);
        v.setOriginalColumnTypeName(originalColumnTypeName);
        int originalPrecision = -1;
        if (!ignoreLength) {
            originalPrecision = rm.getPrecision(index);
        }
        v.setOriginalPrecision(originalPrecision);
        int originalScale = rm.getScale(index);
        v.setOriginalScale(originalScale);
        boolean originalSigned = rm.isSigned(index);
        v.setOriginalSigned(originalSigned);
    }

    @Override
    public Object getValueFromResultSet(DatabaseInterface databaseInterface, ResultSet resultSet, int index) throws KettleDatabaseException {
        try {
            Object data = null;
            switch (this.getType()) {
                case 4: {
                    data = resultSet.getBoolean(index + 1);
                    break;
                }
                case 1: {
                    data = new Double(resultSet.getDouble(index + 1));
                    break;
                }
                case 6: {
                    data = resultSet.getBigDecimal(index + 1);
                    break;
                }
                case 5: {
                    data = resultSet.getLong(index + 1);
                    break;
                }
                case 2: {
                    if (this.isStorageBinaryString()) {
                        data = resultSet.getBytes(index + 1);
                        break;
                    }
                    data = resultSet.getString(index + 1);
                    break;
                }
                case 8: {
                    if (databaseInterface.supportsGetBlob()) {
                        Blob blob = resultSet.getBlob(index + 1);
                        if (blob != null) {
                            data = blob.getBytes(1L, (int)blob.length());
                            break;
                        }
                        data = null;
                        break;
                    }
                    data = resultSet.getBytes(index + 1);
                    break;
                }
                case 3: {
                    if (this.getPrecision() != 1 && databaseInterface.supportsTimeStampToDateConversion()) {
                        data = resultSet.getTimestamp(index + 1);
                        break;
                    }
                    if (databaseInterface instanceof NetezzaDatabaseMeta) {
                        data = this.getNetezzaDateValueWorkaround(databaseInterface, resultSet, index + 1);
                        break;
                    }
                    data = resultSet.getDate(index + 1);
                    break;
                }
            }
            if (resultSet.wasNull()) {
                data = null;
            }
            return data;
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get value '" + this.toStringMeta() + "' from database resultset, index " + index, e);
        }
    }

    private Object getNetezzaDateValueWorkaround(DatabaseInterface databaseInterface, ResultSet resultSet, int index) throws SQLException, KettleDatabaseException {
        java.util.Date data = null;
        int type = resultSet.getMetaData().getColumnType(index);
        switch (type) {
            case 92: {
                data = resultSet.getTime(index);
                break;
            }
            default: {
                data = resultSet.getDate(index);
            }
        }
        return data;
    }

    @Override
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws KettleDatabaseException {
        try {
            switch (this.getType()) {
                case 1: {
                    if (!this.isNull(data)) {
                        double num = this.getNumber(data);
                        if (databaseMeta.supportsFloatRoundingOnUpdate() && this.getPrecision() >= 0) {
                            num = Const.round(num, this.getPrecision());
                        }
                        preparedStatement.setDouble(index, num);
                        break;
                    }
                    preparedStatement.setNull(index, 8);
                    break;
                }
                case 5: {
                    if (!this.isNull(data)) {
                        if (databaseMeta.supportsSetLong()) {
                            preparedStatement.setLong(index, this.getInteger(data));
                            break;
                        }
                        double d = this.getNumber(data);
                        if (databaseMeta.supportsFloatRoundingOnUpdate() && this.getPrecision() >= 0) {
                            preparedStatement.setDouble(index, d);
                            break;
                        }
                        preparedStatement.setDouble(index, Const.round(d, this.getPrecision()));
                        break;
                    }
                    preparedStatement.setNull(index, 4);
                    break;
                }
                case 2: {
                    if (this.getLength() < databaseMeta.getMaxTextFieldLength()) {
                        if (!this.isNull(data)) {
                            preparedStatement.setString(index, this.getString(data));
                            break;
                        }
                        preparedStatement.setNull(index, 12);
                        break;
                    }
                    if (!this.isNull(data)) {
                        String string = this.getString(data);
                        int maxlen = databaseMeta.getMaxTextFieldLength();
                        int len = string.length();
                        int begin = len - maxlen;
                        if (begin < 0) {
                            begin = 0;
                        }
                        String logging = string.substring(begin);
                        if (databaseMeta.supportsSetCharacterStream()) {
                            StringReader sr = new StringReader(logging);
                            preparedStatement.setCharacterStream(index, (Reader)sr, logging.length());
                            break;
                        }
                        preparedStatement.setString(index, logging);
                        break;
                    }
                    preparedStatement.setNull(index, 12);
                    break;
                }
                case 3: {
                    if (!this.isNull(data)) {
                        if (this.getPrecision() == 1 || !databaseMeta.supportsTimeStampToDateConversion()) {
                            long dat = this.getInteger(data);
                            Date ddate = new Date(dat);
                            if (this.ignoreTimezone || this.getDateFormatTimeZone() == null) {
                                preparedStatement.setDate(index, ddate);
                                break;
                            }
                            preparedStatement.setDate(index, ddate, Calendar.getInstance(this.getDateFormatTimeZone()));
                            break;
                        }
                        if (data instanceof Timestamp) {
                            if (this.ignoreTimezone || this.getDateFormatTimeZone() == null) {
                                preparedStatement.setTimestamp(index, (Timestamp)data);
                                break;
                            }
                            preparedStatement.setTimestamp(index, (Timestamp)data, Calendar.getInstance(this.getDateFormatTimeZone()));
                            break;
                        }
                        long dat = this.getInteger(data);
                        Timestamp sdate = new Timestamp(dat);
                        if (this.ignoreTimezone || this.getDateFormatTimeZone() == null) {
                            preparedStatement.setTimestamp(index, sdate);
                            break;
                        }
                        preparedStatement.setTimestamp(index, sdate, Calendar.getInstance(this.getDateFormatTimeZone()));
                        break;
                    }
                    if (this.getPrecision() == 1 || !databaseMeta.supportsTimeStampToDateConversion()) {
                        preparedStatement.setNull(index, 91);
                        break;
                    }
                    preparedStatement.setNull(index, 93);
                    break;
                }
                case 4: {
                    if (databaseMeta.supportsBooleanDataType()) {
                        if (!this.isNull(data)) {
                            preparedStatement.setBoolean(index, this.getBoolean(data));
                            break;
                        }
                        preparedStatement.setNull(index, 16);
                        break;
                    }
                    if (!this.isNull(data)) {
                        preparedStatement.setString(index, this.getBoolean(data) != false ? "Y" : "N");
                        break;
                    }
                    preparedStatement.setNull(index, 1);
                    break;
                }
                case 6: {
                    if (!this.isNull(data)) {
                        preparedStatement.setBigDecimal(index, this.getBigNumber(data));
                        break;
                    }
                    preparedStatement.setNull(index, 3);
                    break;
                }
                case 8: {
                    if (!this.isNull(data)) {
                        preparedStatement.setBytes(index, this.getBinary(data));
                        break;
                    }
                    preparedStatement.setNull(index, -2);
                    break;
                }
                default: {
                    preparedStatement.setNull(index, 12);
                }
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error setting value #" + index + " [" + this.toStringMeta() + "] on prepared statement", e);
        }
    }

    @Override
    public Object getNativeDataType(Object object) throws KettleValueException {
        switch (this.getStorageType()) {
            case 1: {
                return this.convertBinaryStringToNativeType((byte[])object);
            }
            case 2: {
                return this.index[(Integer)object];
            }
        }
        return object;
    }

    @Override
    public String getDatabaseColumnTypeDefinition(DatabaseInterface databaseInterface, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        return null;
    }

    protected int getQuotesBeforeSymbol(String df, String symbols) {
        int quotes = 0;
        int stopPos = df.indexOf(symbols);
        if (stopPos > 0) {
            int curPos = -1;
            do {
                if ((curPos = df.indexOf("'", curPos + 1)) < 0 || curPos >= stopPos) continue;
                ++quotes;
            } while (curPos >= 0 && curPos < stopPos);
        }
        return quotes;
    }
}

