/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.sql.SQLField;
import org.pentaho.di.core.sql.SQLFields;

public class SQLCondition {
    private String tableAlias;
    RowMetaInterface serviceFields;
    private Condition condition;
    private String conditionClause;
    private SQLFields selectFields;

    public SQLCondition(String tableAlias, String conditionSql, RowMetaInterface serviceFields) throws KettleSQLException {
        this(tableAlias, conditionSql, serviceFields, null);
    }

    public SQLCondition(String tableAlias, String conditionSql, RowMetaInterface serviceFields, SQLFields selectFields) throws KettleSQLException {
        this.tableAlias = tableAlias;
        this.conditionClause = conditionSql;
        this.serviceFields = serviceFields;
        this.selectFields = selectFields;
        this.parse();
    }

    private void parse() throws KettleSQLException {
        this.condition = this.splitConditionByOperator(this.conditionClause, null, 0);
        for (int i = 0; i < 20 && this.condition.simplify(); ++i) {
        }
    }

    private int searchForString(String clause, String string, int startIndex) throws KettleSQLException {
        for (int index = startIndex; index < clause.length(); ++index) {
            if ((index = ThinUtil.skipChars(clause, index, '\'', '(')) + string.length() > clause.length()) {
                return -1;
            }
            if (!clause.substring(index).toUpperCase().startsWith(string.toUpperCase())) continue;
            return index;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Condition splitConditionByOperator(String clause, Condition parentCondition, int parentOperator) throws KettleSQLException {
        int andConditionOperator;
        String andOperatorString;
        if (parentCondition == null) {
            parentCondition = new Condition();
        } else {
            Condition c = new Condition();
            c.setOperator(parentOperator);
            parentCondition.addCondition(c);
            parentCondition = c;
        }
        String orOperatorString = " OR ";
        int orConditionOperator = 1;
        int lastIndex = this.splitByOperator(clause, parentCondition, orOperatorString, orConditionOperator);
        if (lastIndex != 0 || (lastIndex = this.splitByOperator(clause, parentCondition, andOperatorString = " AND ", andConditionOperator = 2)) != 0) return parentCondition;
        String cleaned = Const.trim(clause);
        boolean negation = false;
        if (Pattern.matches("^PARAMETER\\s*\\(.*\\)\\s*=\\s*'.*'$", cleaned)) {
            int endParamIndex;
            int startParamIndex = cleaned.indexOf(40) + 1;
            String quotedParameter = Const.trim(cleaned.substring(startParamIndex, endParamIndex = ThinUtil.skipChars(cleaned, startParamIndex, '(', '\'')));
            if (!quotedParameter.startsWith("'") || !quotedParameter.endsWith("'")) throw new KettleSQLException("Parameter name between single quotes expected in : " + clause);
            String parameterName = quotedParameter.substring(1, quotedParameter.length() - 1);
            int startValueIndex = cleaned.indexOf(61, endParamIndex + 1) + 1;
            String quotedValue = Const.trim(cleaned.substring(startValueIndex));
            if (!quotedValue.startsWith("'") || !quotedValue.endsWith("'")) throw new KettleSQLException("A parameter value has to always be a string between single quotes in : " + clause);
            String parameterValue = quotedValue.substring(1, quotedValue.length() - 1);
            Condition subCondition = new Condition(parameterName, 14, parameterName, new ValueMetaAndData(new ValueMeta("string", 2), (Object)Const.NVL(parameterValue, "")));
            subCondition.setOperator(orConditionOperator);
            parentCondition.addCondition(subCondition);
            if (!Const.isEmpty(parameterName)) return parentCondition;
            throw new KettleSQLException("A parameter name can not be empty in : " + clause);
        }
        if (Pattern.matches("^NOT\\s*\\(.*\\)$", cleaned.toUpperCase())) {
            negation = true;
            cleaned = Const.trim(cleaned.substring(3));
        }
        if (cleaned.startsWith("(") && cleaned.endsWith(")")) {
            cleaned = cleaned.substring(1, cleaned.length() - 1);
            Condition c = this.splitConditionByOperator(cleaned, parentCondition, 0);
            c.setNegated(negation);
            return parentCondition;
        } else {
            Condition subCondition = this.parseAtomicCondition(cleaned);
            subCondition.setOperator(orConditionOperator);
            parentCondition.addCondition(subCondition);
        }
        return parentCondition;
    }

    private int splitByOperator(String clause, Condition parentCondition, String operatorString, int conditionOperator) throws KettleSQLException {
        int lastIndex = 0;
        int index = 0;
        while (index < clause.length() && (index = this.searchForString(clause, operatorString, index)) >= 0) {
            String left = clause.substring(lastIndex, index);
            this.splitConditionByOperator(left, parentCondition, conditionOperator);
            lastIndex = index += operatorString.length();
        }
        if (lastIndex > 0) {
            String right = clause.substring(lastIndex);
            this.splitConditionByOperator(right, parentCondition, conditionOperator);
        }
        return lastIndex;
    }

    private Condition parseAtomicCondition(String clause) throws KettleSQLException {
        List<String> strings = this.splitConditionClause(clause);
        if (strings.size() > 3) {
            throw new KettleSQLException("Unfortunately support for conditions is still very rudimentary, only 1 simple condition is supported [" + clause + "]");
        }
        String left = strings.get(0);
        if (this.selectFields != null) {
            for (SQLField field : this.selectFields.getFields()) {
                if (!field.getExpression().equalsIgnoreCase(left)) continue;
                if (Const.isEmpty(field.getAlias())) break;
                left = field.getAlias();
                break;
            }
        }
        left = ThinUtil.stripQuoteTableAlias(left, this.tableAlias);
        String operatorString = strings.get(1);
        String right = strings.get(2);
        right = ThinUtil.stripQuoteTableAlias(right, this.tableAlias);
        ValueMetaAndData value = null;
        int function = Condition.getFunction(operatorString);
        if (function == 9) {
            String trimmed = Const.trim(right);
            String partClause = trimmed.substring(1, trimmed.length() - 1);
            List<String> parts = ThinUtil.splitClause(partClause, ',', '\'');
            StringBuilder valueString = new StringBuilder();
            for (String part : parts) {
                if (valueString.length() > 0) {
                    valueString.append(";");
                }
                if ((part = Const.trim(part)).startsWith("'") && part.endsWith("'")) {
                    part = part.substring(1, part.length() - 1);
                }
                part = part.replace("''", "'");
                part = part.replace(";", "\\;");
                valueString.append(part);
            }
            value = new ValueMetaAndData(new ValueMeta("constant-in-list", 2), (Object)valueString.toString());
        } else {
            String raw;
            int rightOrIndex;
            int leftOrIndex;
            String prefix = "'%'";
            String suffix = "'%'";
            if (right.startsWith(prefix) && right.endsWith(suffix) && (leftOrIndex = right.indexOf("||")) > 0 && (rightOrIndex = right.indexOf("||", leftOrIndex + 2)) > 0 && (raw = Const.trim(right.substring(leftOrIndex + 2, rightOrIndex))).startsWith("'") && raw.endsWith("'")) {
                right = "'%" + raw.substring(1, raw.length() - 1) + "%'";
            }
            value = ThinUtil.extractConstant(right);
        }
        if (value != null) {
            return new Condition(left, function, null, value);
        }
        return new Condition(left, function, right, null);
    }

    private List<String> splitConditionClause(String clause) throws KettleSQLException {
        ArrayList<String> strings = new ArrayList<String>();
        String[] operators = new String[]{"<>", ">=", "=>", "<=", "=<", "<", ">", "=", " REGEX ", " IN ", " IS NOT NULL", " IS NULL", " LIKE", "CONTAINS "};
        int[] functions = new int[]{1, 5, 5, 3, 3, 2, 4, 0, 6, 9, 8, 7, 13, 10};
        for (int index = 0; index < clause.length(); ++index) {
            index = ThinUtil.skipChars(clause, index, '\'', '\"');
            for (String operator : operators) {
                if (index > clause.length() - operator.length() || !clause.substring(index).toUpperCase().startsWith(operator)) continue;
                int functionIndex = Const.indexOfString(operator, operators);
                String left = Const.trim(clause.substring(0, index));
                String op = Condition.functions[functions[functionIndex]];
                String right = Const.trim(clause.substring(index + operator.length()));
                strings.add(left);
                strings.add(op);
                strings.add(right);
                return strings;
            }
        }
        return strings;
    }

    public RowMetaInterface getServiceFields() {
        return this.serviceFields;
    }

    public void setServiceFields(RowMetaInterface serviceFields) {
        this.serviceFields = serviceFields;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getConditionClause() {
        return this.conditionClause;
    }

    public void setConditionClause(String conditionClause) {
        this.conditionClause = conditionClause;
    }

    public boolean isEmpty() {
        return this.condition.isEmpty();
    }

    public SQLFields getSelectFields() {
        return this.selectFields;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public List<SQLField> extractHavingFields(List<SQLField> selectFields, List<SQLField> aggFields, RowMetaInterface rowMeta) throws KettleSQLException {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        ArrayList<String> expressions = new ArrayList<String>();
        this.addExpressions(this.condition, expressions);
        for (String expression : expressions) {
            SQLField field;
            SQLField aggField = SQLField.searchSQLFieldByFieldOrAlias(aggFields, expression);
            if (aggField != null || (field = new SQLField(this.tableAlias, expression, this.serviceFields)).getAggregation() == null) continue;
            field.setField(expression);
            list.add(field);
        }
        return list;
    }

    private void addExpressions(Condition condition, List<String> expressions) {
        if (condition.isAtomic()) {
            if (!expressions.contains(condition.getLeftValuename())) {
                expressions.add(condition.getLeftValuename());
            }
        } else {
            for (Condition child : condition.getChildren()) {
                this.addExpressions(child, expressions);
            }
        }
    }
}

