/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;

public class StringUtil {
    public static final String UNIX_OPEN = "${";
    public static final String UNIX_CLOSE = "}";
    public static final String WINDOWS_OPEN = "%%";
    public static final String WINDOWS_CLOSE = "%%";
    public static final String HEX_OPEN = "$[";
    public static final String HEX_CLOSE = "]";
    public static final String FIELD_OPEN = "?{";
    public static final String FIELD_CLOSE = "}";
    public static final String CRLF = "\r\n";
    public static final String INDENTCHARS = "                    ";
    public static final String EMPTY_STRING = "";
    public static final String[] SYSTEM_PROPERTIES = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir", "user.country", "user.language", "user.timezone", "org.apache.commons.logging.Log", "org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "org.apache.commons.logging.simplelog.showdatetime", "org.eclipse.swt.browser.XULRunnerInitialized", "org.eclipse.swt.browser.XULRunnerPath", "sun.arch.data.model", "sun.boot.class.path", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level"};

    public static String substitute(String aString, Map<String, String> variablesValues, String open, String close) {
        return StringUtil.substitute(aString, variablesValues, open, close, 0);
    }

    public static String substitute(String aString, Map<String, String> variablesValues, String open, String close, int recursion) {
        if (aString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String rest = aString;
        int i = rest.indexOf(open);
        while (i > -1) {
            int j = rest.indexOf(close, i + open.length());
            if (j > -1) {
                String varName = rest.substring(i + open.length(), j);
                String value = variablesValues.get(varName);
                if (value == null) {
                    value = open + varName + close;
                } else {
                    int another = value.indexOf(open);
                    if (another > -1) {
                        if (recursion > 50) {
                            throw new RuntimeException("Endless loop detected for substitution of variable: " + value);
                        }
                        value = StringUtil.substitute(value, variablesValues, open, close, ++recursion);
                    }
                }
                buffer.append(rest.substring(0, i));
                buffer.append((Object)value);
                rest = rest.substring(j + close.length());
            } else {
                buffer.append(rest);
                rest = EMPTY_STRING;
            }
            i = rest.indexOf(open);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    public static String substituteHex(String aString) {
        if (aString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String rest = aString;
        int i = rest.indexOf(HEX_OPEN);
        while (i > -1) {
            int j = rest.indexOf(HEX_CLOSE, i + HEX_OPEN.length());
            if (j > -1) {
                buffer.append(rest.substring(0, i));
                String hexString = rest.substring(i + HEX_OPEN.length(), j);
                String[] hexStringArray = hexString.split(",");
                byte[] hexByte = new byte[1];
                for (int pos = 0; pos < hexStringArray.length; ++pos) {
                    int hexInt;
                    try {
                        hexInt = Integer.parseInt(hexStringArray[pos], 16);
                    }
                    catch (NumberFormatException e) {
                        hexInt = 0;
                    }
                    hexByte[0] = (byte)hexInt;
                    buffer.append(new String(hexByte));
                }
                rest = rest.substring(j + HEX_CLOSE.length());
            } else {
                buffer.append(rest);
                rest = EMPTY_STRING;
            }
            i = rest.indexOf(HEX_OPEN);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized String environmentSubstitute(String aString, Map<String, String> systemProperties) {
        HashMap<String, String> sysMap;
        HashMap<String, String> hashMap = sysMap = new HashMap<String, String>();
        synchronized (hashMap) {
            sysMap.putAll(Collections.synchronizedMap(systemProperties));
            aString = StringUtil.substituteWindows(aString, sysMap);
            aString = StringUtil.substituteUnix(aString, sysMap);
            aString = StringUtil.substituteHex(aString);
            return aString;
        }
    }

    public static String substituteUnix(String aString, Map<String, String> variables) {
        return StringUtil.substitute(aString, variables, UNIX_OPEN, "}");
    }

    public static String substituteWindows(String aString, Map<String, String> variables) {
        return StringUtil.substitute(aString, variables, "%%", "%%");
    }

    public static String substituteField(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (int i = 0; i < rowMeta.size(); ++i) {
            variables.put(rowMeta.getValueMeta(i).getName(), rowMeta.getString(rowData, i));
        }
        return StringUtil.substitute(aString, variables, FIELD_OPEN, "}");
    }

    private static void getUsedVariables(String aString, String open, String close, List<String> list, boolean includeSystemVariables) {
        if (aString == null) {
            return;
        }
        for (int p = 0; p < aString.length(); ++p) {
            int from;
            int to;
            if (!aString.substring(p).startsWith(open) || (to = aString.indexOf(close, (from = p + open.length()) + 1)) < 0) continue;
            String variable = aString.substring(from, to);
            if (Const.indexOfString(variable, list) < 0 && (includeSystemVariables || !StringUtil.isSystemVariable(variable) || System.getProperty(variable) == null)) {
                list.add(variable);
            }
            p = to + close.length();
        }
    }

    public static boolean isSystemVariable(String aString) {
        return Const.indexOfString(aString, SYSTEM_PROPERTIES) >= 0;
    }

    public static void getUsedVariables(String aString, List<String> list, boolean includeSystemVariables) {
        StringUtil.getUsedVariables(aString, UNIX_OPEN, "}", list, includeSystemVariables);
        StringUtil.getUsedVariables(aString, "%%", "%%", list, includeSystemVariables);
    }

    public static final String generateRandomString(int length, String prefix, String postfix, boolean uppercase) {
        StringBuffer buffer = new StringBuffer();
        if (!Const.isEmpty(prefix)) {
            buffer.append(prefix);
        }
        for (int i = 0; i < length; ++i) {
            int c = 97 + (int)(Math.random() * 26.0);
            buffer.append((char)c);
        }
        if (!Const.isEmpty(postfix)) {
            buffer.append(postfix);
        }
        if (uppercase) {
            return buffer.toString().toUpperCase();
        }
        return buffer.toString();
    }

    public static String initCap(String st) {
        if (st == null || st.trim().length() == 0) {
            return EMPTY_STRING;
        }
        if (st.substring(0, 1).equals(st.substring(0, 1).toUpperCase())) {
            return st;
        }
        return st.substring(0, 1).toUpperCase() + st.substring(1);
    }

    public static double str2num(String pattern, String decimal, String grouping, String currency, String value) throws KettleValueException {
        NumberFormat nf = NumberFormat.getInstance();
        DecimalFormat df = (DecimalFormat)nf;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        if (!Const.isEmpty(pattern)) {
            df.applyPattern(pattern);
        }
        if (!Const.isEmpty(decimal)) {
            dfs.setDecimalSeparator(decimal.charAt(0));
        }
        if (!Const.isEmpty(grouping)) {
            dfs.setGroupingSeparator(grouping.charAt(0));
        }
        if (!Const.isEmpty(currency)) {
            dfs.setCurrencySymbol(currency);
        }
        try {
            df.setDecimalFormatSymbols(dfs);
            return df.parse(value).doubleValue();
        }
        catch (Exception e) {
            String message = "Couldn't convert string to number " + e.toString();
            if (!StringUtil.isEmpty(pattern)) {
                message = message + " pattern=" + pattern;
            }
            if (!StringUtil.isEmpty(decimal)) {
                message = message + " decimal=" + decimal;
            }
            if (!StringUtil.isEmpty(grouping)) {
                message = message + " grouping=" + grouping.charAt(0);
            }
            if (!StringUtil.isEmpty(currency)) {
                message = message + " currency=" + currency;
            }
            throw new KettleValueException(message);
        }
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(StringBuffer string) {
        return string == null || string.length() == 0;
    }

    public static Date str2dat(String arg0, String arg1, String val) throws KettleValueException {
        SimpleDateFormat df = new SimpleDateFormat();
        DateFormatSymbols dfs = new DateFormatSymbols();
        if (arg1 != null) {
            dfs.setLocalPatternChars(arg1);
        }
        if (arg0 != null) {
            df.applyPattern(arg0);
        }
        try {
            return df.parse(val);
        }
        catch (Exception e) {
            throw new KettleValueException("TO_DATE Couldn't convert String to Date " + e.toString());
        }
    }

    public static String getIndent(int indentLevel) {
        return INDENTCHARS.substring(0, indentLevel);
    }

    public static String getFormattedDateTime(Date date) {
        return StringUtil.getFormattedDateTime(date, false);
    }

    public static String getFormattedDateTime(Date date, boolean milliseconds) {
        SimpleDateFormat dateFormat = null;
        dateFormat = milliseconds ? new SimpleDateFormat("yyyyddMM_hhmmssSSS") : new SimpleDateFormat("yyyyddMM_hhmmss");
        return dateFormat.format(date);
    }

    public static String getFormattedDateTimeNow() {
        return StringUtil.getFormattedDateTime(new Date(), false);
    }

    public static String getFormattedDateTimeNow(boolean milliseconds) {
        return StringUtil.getFormattedDateTime(new Date(), milliseconds);
    }

    public static boolean IsInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean IsNumber(String str) {
        try {
            Double.valueOf(str).doubleValue();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean IsDate(String str) {
        return StringUtil.IsDate("yy-mm-dd");
    }

    public static boolean IsDate(String str, String mask) {
        try {
            SimpleDateFormat fdate = new SimpleDateFormat("yy-mm-dd");
            fdate.parse(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final String getVariableName(String variable) {
        if ((variable = variable.trim()).startsWith(UNIX_OPEN) || variable.startsWith("%%") || variable.startsWith(HEX_OPEN)) {
            variable = variable.substring(2, variable.length());
        }
        if (variable.endsWith("}") || variable.endsWith(HEX_CLOSE)) {
            variable = variable.substring(0, variable.length() - 1);
        }
        if (variable.endsWith("%%")) {
            variable = variable.substring(0, variable.length() - 2);
        }
        return variable;
    }
}

