/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.avatica;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.AvaticaFactory;
import net.hydromatic.avatica.ConnectStringParser;
import net.hydromatic.avatica.ConnectionProperty;
import net.hydromatic.avatica.DriverVersion;
import net.hydromatic.avatica.Handler;
import net.hydromatic.avatica.HandlerImpl;

public abstract class UnregisteredDriver
implements Driver {
    final DriverVersion version;
    protected final AvaticaFactory factory = this.createFactory();
    public final Handler handler;

    protected UnregisteredDriver() {
        this.version = this.createDriverVersion();
        this.handler = this.createHandler();
    }

    protected AvaticaFactory createFactory() {
        return UnregisteredDriver.instantiateFactory(this.getFactoryClassName(JdbcVersion.current()));
    }

    protected Handler createHandler() {
        return new HandlerImpl();
    }

    protected String getFactoryClassName(JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "net.hydromatic.avatica.AvaticaFactoryJdbc3Impl";
            }
            case JDBC_40: {
                return "net.hydromatic.avatica.AvaticaJdbc40Factory";
            }
        }
        return "net.hydromatic.avatica.AvaticaJdbc41Factory";
    }

    protected abstract DriverVersion createDriverVersion();

    protected static AvaticaFactory instantiateFactory(String factoryClassName) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            return (AvaticaFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String prefix = this.getConnectStringPrefix();
        assert (url.startsWith(prefix));
        String urlSuffix = url.substring(prefix.length());
        Properties info2 = ConnectStringParser.parse(urlSuffix, info);
        AvaticaConnection connection = this.factory.newConnection(this, this.factory, url, info2);
        this.handler.onConnectionInit(connection);
        return connection;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(this.getConnectStringPrefix());
    }

    protected abstract String getConnectStringPrefix();

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> list = new ArrayList<DriverPropertyInfo>();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            list.add(new DriverPropertyInfo((String)entry.getKey(), (String)entry.getValue()));
        }
        for (ConnectionProperty p : ConnectionProperty.values()) {
            if (info.containsKey(p.name())) continue;
            list.add(new DriverPropertyInfo(p.name(), null));
        }
        return list.toArray(new DriverPropertyInfo[list.size()]);
    }

    public Logger getParentLogger() {
        return Logger.getLogger("");
    }

    public DriverVersion getDriverVersion() {
        return this.version;
    }

    public final int getMajorVersion() {
        return this.version.majorVersion;
    }

    public final int getMinorVersion() {
        return this.version.minorVersion;
    }

    public boolean jdbcCompliant() {
        return this.version.jdbcCompliant;
    }

    protected void register() {
        try {
            DriverManager.registerDriver(this);
        }
        catch (SQLException e) {
            System.out.println("Error occurred while registering JDBC driver " + this + ": " + e.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum JdbcVersion {
        JDBC_UNKNOWN,
        JDBC_30,
        JDBC_40,
        JDBC_41;


        public static JdbcVersion current() {
            try {
                Class.forName("java.sql.PseudoColumnUsage");
                return JDBC_41;
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("java.sql.Wrapper");
                    return JDBC_40;
                }
                catch (ClassNotFoundException e2) {
                    return JDBC_30;
                }
            }
        }
    }
}

