/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.mime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.mime.MimeAttributesMap;
import org.apache.commons.vfs.provider.mime.MimeFileContentInfoFactory;
import org.apache.commons.vfs.provider.mime.MimeFileSystem;
import org.apache.commons.vfs.util.FileObjectUtils;

public class MimeFileObject
extends AbstractFileObject
implements FileObject {
    private Part part;
    private Map attributeMap;

    protected MimeFileObject(FileName fileName, Part part, AbstractFileSystem abstractFileSystem) throws FileSystemException {
        super(fileName, abstractFileSystem);
        this.setPart(part);
    }

    protected void doAttach() throws Exception {
        if (this.part == null) {
            if (!this.getName().equals(this.getFileSystem().getRootName())) {
                MimeFileObject mimeFileObject = (MimeFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
                this.setPart(mimeFileObject.findPart(this.getName().getBaseName()));
                return;
            }
            this.setPart(((MimeFileSystem)this.getFileSystem()).createCommunicationLink());
        }
    }

    private Part findPart(String string) throws Exception {
        if (this.getType() == FileType.IMAGINARY) {
            return null;
        }
        if (this.isMultipart()) {
            Multipart multipart = (Multipart)this.part.getContent();
            if (string.startsWith("_body_part_")) {
                int n = Integer.parseInt(string.substring("_body_part_".length()), 10);
                if (n < 0 || n + 1 > multipart.getCount()) {
                    return null;
                }
                return multipart.getBodyPart(n);
            }
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                if (!string.equals(bodyPart.getFileName())) continue;
                return bodyPart;
            }
        }
        return null;
    }

    protected void doDetach() throws Exception {
    }

    protected FileType doGetType() throws Exception {
        if (this.part == null) {
            return FileType.IMAGINARY;
        }
        if (this.isMultipart()) {
            return FileType.FILE_OR_FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        Object object;
        if (this.part == null) {
            return null;
        }
        ArrayList<MimeFileObject> arrayList = new ArrayList<MimeFileObject>();
        if (this.isMultipart() && (object = this.part.getContent()) instanceof Multipart) {
            Multipart multipart = (Multipart)object;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String string = UriParser.encode(bodyPart.getFileName());
                if (string == null) {
                    string = "_body_part_" + i;
                }
                MimeFileObject mimeFileObject = (MimeFileObject)FileObjectUtils.getAbstractFileObject(this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), string, NameScope.CHILD)));
                mimeFileObject.setPart((Part)bodyPart);
                arrayList.add(mimeFileObject);
            }
        }
        return arrayList.toArray(new MimeFileObject[arrayList.size()]);
    }

    private void setPart(Part part) {
        this.part = part;
        this.attributeMap = null;
    }

    protected long doGetContentSize() throws Exception {
        return this.part.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        Message message = this.getMessage();
        if (message == null) {
            return -1L;
        }
        if (message.getSentDate() != null) {
            return message.getSentDate().getTime();
        }
        if (message.getReceivedDate() != null) {
            message.getReceivedDate();
        }
        return 0L;
    }

    private Message getMessage() throws FileSystemException {
        if (this.part instanceof Message) {
            return (Message)this.part;
        }
        return ((MimeFileObject)FileObjectUtils.getAbstractFileObject(this.getParent())).getMessage();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (this.isMultipart()) {
            String string = ((MimeMultipart)this.part.getContent()).getPreamble();
            if (string == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        return this.part.getInputStream();
    }

    boolean isMultipart() throws MessagingException {
        return this.part.getContentType() != null && this.part.getContentType().startsWith("multipart/");
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new MimeFileContentInfoFactory();
    }

    protected Part getPart() {
        return this.part;
    }

    protected Map doGetAttributes() throws Exception {
        if (this.attributeMap == null) {
            this.attributeMap = this.part != null ? new MimeAttributesMap(this.part) : Collections.EMPTY_MAP;
        }
        return this.attributeMap;
    }

    protected Enumeration getAllHeaders() throws MessagingException {
        return this.part.getAllHeaders();
    }
}

