/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.SharedInputStream;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

public class SharedRandomContentInputStream
extends BufferedInputStream
implements SharedInputStream {
    private final Set createdStreams;
    private final FileObject fo;
    private final long fileStart;
    private final long fileEnd;
    private long pos;
    private long resetCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedRandomContentInputStream(Set set, FileObject fileObject, long l, long l2, InputStream inputStream) throws FileSystemException {
        super(inputStream);
        if (!fileObject.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ)) {
            throw new FileSystemException("vfs.util/missing-capability.error", Capability.RANDOM_ACCESS_READ);
        }
        this.fo = fileObject;
        this.fileStart = l;
        this.fileEnd = l2;
        this.createdStreams = set;
        Set set2 = set;
        synchronized (set2) {
            set.add(this);
        }
    }

    public SharedRandomContentInputStream(FileObject fileObject) throws FileSystemException {
        this(new HashSet(), fileObject, 0L, -1L, fileObject.getContent().getInputStream());
    }

    public synchronized int read() throws IOException {
        if (this.checkEnd()) {
            return -1;
        }
        int n = super.read();
        ++this.pos;
        ++this.resetCount;
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.checkEnd()) {
            return -1;
        }
        if (this.fileEnd > -1L && this.calcFilePosition(n2) > this.fileEnd) {
            n2 = (int)(this.fileEnd - this.getFilePosition());
        }
        int n3 = super.read(byArray, n, n2);
        this.pos += (long)n3;
        this.resetCount += (long)n3;
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        if (this.checkEnd()) {
            return -1L;
        }
        if (this.fileEnd > -1L && this.calcFilePosition(l) > this.fileEnd) {
            l = this.fileEnd - this.getFilePosition();
        }
        long l2 = super.skip(l);
        this.pos += l2;
        this.resetCount += l2;
        return l2;
    }

    private boolean checkEnd() {
        return this.fileEnd > -1L && this.getFilePosition() >= this.fileEnd;
    }

    protected long getFilePosition() {
        return this.fileStart + this.pos;
    }

    protected long calcFilePosition(long l) {
        return this.getFilePosition() + l;
    }

    public synchronized void mark(int n) {
        super.mark(n);
        this.resetCount = 0L;
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.pos -= this.resetCount;
        this.resetCount = 0L;
    }

    public long getPosition() {
        return this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        Set set = this.createdStreams;
        synchronized (set) {
            this.createdStreams.remove(this);
        }
    }

    public InputStream newStream(long l, long l2) {
        try {
            long l3 = this.fileStart + l;
            long l4 = l2 < 0L ? this.fileEnd : this.fileStart + l2;
            RandomAccessContent randomAccessContent = this.fo.getContent().getRandomAccessContent(RandomAccessMode.READ);
            randomAccessContent.seek(l3);
            return new SharedRandomContentInputStream(this.createdStreams, this.fo, l3, l4, randomAccessContent.getInputStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws IOException {
        Set set = this.createdStreams;
        synchronized (set) {
            SharedRandomContentInputStream[] sharedRandomContentInputStreamArray = new SharedRandomContentInputStream[this.createdStreams.size()];
            this.createdStreams.toArray(sharedRandomContentInputStreamArray);
            for (int i = 0; i < sharedRandomContentInputStreamArray.length; ++i) {
                sharedRandomContentInputStreamArray[i].close();
            }
        }
    }
}

