/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AccessPolicyResponseBase<T> {
    private boolean isParsed;
    private final HashMap<String, T> policies = new HashMap();
    private final InputStream streamRef;

    public AccessPolicyResponseBase(InputStream stream) {
        this.streamRef = stream;
    }

    public HashMap<String, T> getAccessIdentifiers() throws XMLStreamException, ParseException {
        if (!this.isParsed) {
            this.parseResponse();
        }
        return this.policies;
    }

    private void parseResponse() throws XMLStreamException, ParseException {
        XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream((InputStream)this.streamRef);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType != 1 || !name.equals("SignedIdentifiers")) continue;
            this.readPolicies(xmlr);
            break;
        }
        this.isParsed = true;
    }

    private void readPolicies(XMLStreamReader xmlr) throws XMLStreamException, ParseException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "SignedIdentifiers");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("SignedIdentifier")) {
                this.readSignedIdentifier(xmlr);
                continue;
            }
            if (eventType != 2 || !name.equals("SignedIdentifiers")) continue;
            break;
        }
        xmlr.require(2, null, "SignedIdentifiers");
    }

    private void readSignedIdentifier(XMLStreamReader xmlr) throws XMLStreamException, ParseException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "SignedIdentifier");
        String id = null;
        Object policy = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("Id")) {
                id = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Id");
                continue;
            }
            if (eventType == 1 && name.equals("AccessPolicy")) {
                policy = this.readPolicyFromXML(xmlr);
                continue;
            }
            if (eventType != 2 || !name.equals("SignedIdentifier")) continue;
            this.policies.put(id, policy);
            break;
        }
        xmlr.require(2, null, "SignedIdentifier");
    }

    protected abstract T readPolicyFromXML(XMLStreamReader var1) throws XMLStreamException, ParseException;
}

