/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class DefaultRoleUserDetailsServiceDecorator
implements UserDetailsService {
    private static final Log logger = LogFactory.getLog(DefaultRoleUserDetailsServiceDecorator.class);
    private UserDetailsService userDetailsService;
    private GrantedAuthority defaultRole;
    private IAuthenticationRoleMapper roleMapper;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"injecting proxy");
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        return this.getUserDetailsWithDefaultRole(userDetails);
    }

    protected UserDetails getUserDetailsWithDefaultRole(UserDetails userDetails) {
        if (this.defaultRole != null) {
            return new DefaultRoleUserDetailsProxy(userDetails, this.defaultRole, this.roleMapper);
        }
        return userDetails;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        Assert.notNull((Object)userDetailsService);
        this.userDetailsService = userDetailsService;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole);
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setRoleMapper(IAuthenticationRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public static class DefaultRoleUserDetailsProxy
    implements UserDetails {
        private static final long serialVersionUID = -4262518338443465424L;
        private UserDetails userDetails;
        private GrantedAuthority[] newRoles;
        private IAuthenticationRoleMapper roleMapper;

        public DefaultRoleUserDetailsProxy(UserDetails userDetails, GrantedAuthority defaultRole) {
            this(userDetails, defaultRole, null);
        }

        public DefaultRoleUserDetailsProxy(UserDetails userDetails, GrantedAuthority defaultRole, IAuthenticationRoleMapper roleMapper) {
            Assert.notNull((Object)userDetails);
            Assert.notNull((Object)defaultRole);
            this.userDetails = userDetails;
            this.roleMapper = roleMapper;
            this.newRoles = this.getNewRoles(defaultRole);
        }

        protected GrantedAuthority[] getNewRoles(GrantedAuthority defaultRole) {
            List<GrantedAuthority> origRoles = Arrays.asList(this.userDetails.getAuthorities());
            ArrayList<Object> newRoles1 = new ArrayList<Object>();
            if (this.roleMapper != null) {
                for (GrantedAuthority authority : origRoles) {
                    newRoles1.add(new GrantedAuthorityImpl(this.roleMapper.toPentahoRole(authority.getAuthority())));
                }
            }
            if (!origRoles.contains(defaultRole)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("adding defaultRole=" + defaultRole + " to list of roles for username=" + this.userDetails.getUsername()));
                }
                newRoles1.add(defaultRole);
            }
            return newRoles1.toArray(new GrantedAuthority[0]);
        }

        public GrantedAuthority[] getAuthorities() {
            return this.newRoles;
        }

        public String getPassword() {
            return this.userDetails.getPassword();
        }

        public String getUsername() {
            return this.userDetails.getUsername();
        }

        public boolean isAccountNonExpired() {
            return this.userDetails.isAccountNonExpired();
        }

        public boolean isAccountNonLocked() {
            return this.userDetails.isAccountNonLocked();
        }

        public boolean isCredentialsNonExpired() {
            return this.userDetails.isCredentialsNonExpired();
        }

        public boolean isEnabled() {
            return this.userDetails.isEnabled();
        }
    }
}

