/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLine3DRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.TableOrder;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.uifoundation.chart.BarLineChartDefinition;
import org.pentaho.platform.uifoundation.chart.BubbleRenderer;
import org.pentaho.platform.uifoundation.chart.CategoryDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.ChartDefinition;
import org.pentaho.platform.uifoundation.chart.DialWidgetDefinition;
import org.pentaho.platform.uifoundation.chart.PieDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.StandardBubbleURLGenerator;
import org.pentaho.platform.uifoundation.chart.TimeSeriesCollectionChartDefinition;
import org.pentaho.platform.uifoundation.chart.TimeTableXYDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.XYSeriesCollectionChartDefinition;
import org.pentaho.platform.uifoundation.chart.XYZSeriesCollectionChartDefinition;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class JFreeChartEngine {
    protected static final Log log = LogFactory.getLog(JFreeChartEngine.class);
    public static final int OUTPUT_CHART = 3;
    public static final int OUTPUT_PNG = 1;
    public static final int OUTPUT_SVG = 2;
    public static final int OUTPUT_PNG_BYTES = 4;
    private static final String X1_NODE_NAME = "x1";
    private static final String Y1_NODE_NAME = "y1";
    private static final String X2_NODE_NAME = "x2";
    private static final String Y2_NODE_NAME = "y2";
    private static final String COLOR1_NODE_NAME = "color1";
    private static final String COLOR2_NODE_NAME = "color2";
    private static final String CYCLIC_NODE_NAME = "cyclic";
    private static final String TEXTURE_IMAGE_NODE_NAME = "texture-image";
    private static final String FONT_FAMILY_NODE_NAME = "font-family";
    private static final String SIZE_NODE_NAME = "size";
    private static final String IS_ITALIC_NODE_NAME = "is-italic";
    private static final String IS_BOLD_NODE_NAME = "is-bold";
    public static final int UNDEFINED_CHART_TYPE = -1;
    public static final int DIAL_CHART_TYPE = 0;
    public static final int THERMOMETER_CHART_TYPE = 1;
    public static final int PIE_CHART_TYPE = 2;
    public static final int PIE_GRID_CHART_TYPE = 3;
    public static final int BAR_CHART_TYPE = 4;
    public static final int LINE_CHART_TYPE = 5;
    public static final int AREA_CHART_TYPE = 6;
    public static final int STEP_CHART_TYPE = 7;
    public static final int STEP_AREA_CHART_TYPE = 8;
    public static final int DIFFERENCE_CHART_TYPE = 9;
    public static final int DOT_CHART_TYPE = 10;
    public static final int BAR_LINE_CHART_TYPE = 11;
    public static final int BUBBLE_CHART_TYPE = 12;

    private static JFreeChart createDial(DialWidgetDefinition widget, String title, String units) {
        MeterPlot meter = new MeterPlot((ValueDataset)widget);
        JFreeChartEngine.updatePlot((Plot)meter, widget);
        meter.setUnits(units);
        meter.setValuePaint(widget.getValuePaint());
        meter.setTickPaint(widget.getTickPaint());
        int tickSize = widget.getTickSize();
        if (tickSize == 0) {
            meter.setTickLabelsVisible(false);
        } else {
            meter.setTickLabelsVisible(true);
            meter.setTickSize((double)tickSize);
        }
        if (widget.getValueFont() != null) {
            meter.setValueFont(widget.getValueFont());
        } else {
            meter.setValuePaint((Paint)JFreeChartEngine.getTransparent());
        }
        Font titleFont = widget.getTitleFont();
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)meter, false);
        return chart;
    }

    private static JFreeChart createXYZSeriesCollectionChart(XYZSeriesCollectionChartDefinition chartDefinition) {
        JFreeChart chart = null;
        String domainAxisLabel = null;
        String rangeAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        NumberAxis3D domainAxis = chartDefinition.isThreeD() ? new NumberAxis3D(domainAxisLabel) : new NumberAxis(domainAxisLabel);
        domainAxis.setAutoRangeIncludesZero(chartDefinition.isDomainIncludesZero());
        domainAxis.setAutoRangeStickyZero(chartDefinition.isDomainStickyZero());
        NumberAxis rangeAxis = new NumberAxis(rangeAxisLabel);
        rangeAxis.setAutoRangeIncludesZero(chartDefinition.isRangeIncludesZero());
        rangeAxis.setAutoRangeStickyZero(chartDefinition.isRangeStickyZero());
        BubbleRenderer renderer = null;
        switch (chartDefinition.getChartType()) {
            case 12: {
                renderer = new BubbleRenderer();
                break;
            }
            default: {
                return null;
            }
        }
        if (tooltips) {
            renderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYZToolTipGenerator(chartDefinition.getBubbleLabelContent(), chartDefinition.getXFormat(), chartDefinition.getYFormat(), chartDefinition.getZFormat()));
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardBubbleURLGenerator());
        }
        renderer.setMaxSize(chartDefinition.getMaxBubbleSize());
        renderer.setMaxZ(chartDefinition.getMaxZValue());
        XYPlot plot = new XYPlot((XYDataset)chartDefinition, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createXYSeriesCollectionChart(XYSeriesCollectionChartDefinition chartDefinition) {
        JFreeChart chart = null;
        String domainAxisLabel = null;
        String rangeAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        NumberAxis3D domainAxis = chartDefinition.isThreeD() ? new NumberAxis3D(domainAxisLabel) : new NumberAxis(domainAxisLabel);
        domainAxis.setAutoRangeIncludesZero(chartDefinition.isDomainIncludesZero());
        domainAxis.setAutoRangeStickyZero(chartDefinition.isDomainStickyZero());
        NumberAxis rangeAxis = new NumberAxis(rangeAxisLabel);
        XYAreaRenderer renderer = null;
        switch (chartDefinition.getChartType()) {
            case 5: {
                renderer = chartDefinition.isThreeD() ? new XYLine3DRenderer() : new XYLineAndShapeRenderer(true, false);
                ((XYLineAndShapeRenderer)renderer).setShapesVisible(chartDefinition.isMarkersVisible());
                ((XYLineAndShapeRenderer)renderer).setBaseShapesFilled(chartDefinition.isMarkersVisible());
                break;
            }
            case 6: {
                renderer = new XYAreaRenderer();
                break;
            }
            case 7: {
                renderer = new XYStepRenderer();
                break;
            }
            case 8: {
                renderer = new XYStepAreaRenderer();
                break;
            }
            case 9: {
                renderer = new XYDifferenceRenderer();
                break;
            }
            case 10: {
                renderer = new XYDotRenderer();
                ((XYDotRenderer)renderer).setDotHeight(chartDefinition.getDotHeight());
                ((XYDotRenderer)renderer).setDotWidth(chartDefinition.getDotWidth());
                break;
            }
            default: {
                return null;
            }
        }
        if (renderer != null && legend) {
            renderer.setLegendItemURLGenerator((XYSeriesLabelGenerator)new StandardXYSeriesLabelGenerator());
        }
        if (tooltips) {
            StandardXYToolTipGenerator generator = new StandardXYToolTipGenerator(chartDefinition.getTooltipContent(), (NumberFormat)new DecimalFormat(chartDefinition.getTooltipXFormat()), (NumberFormat)new DecimalFormat(chartDefinition.getTooltipYFormat()));
            renderer.setToolTipGenerator((XYToolTipGenerator)generator);
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        renderer.setStroke(JFreeChartEngine.getLineStyleStroke(chartDefinition.getLineStyle(), chartDefinition.getLineWidth()));
        XYPlot plot = new XYPlot((XYDataset)chartDefinition, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createTimeSeriesCollectionChart(TimeSeriesCollectionChartDefinition chartDefinition) {
        JFreeChart chart = null;
        String domainAxisLabel = null;
        String rangeAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        DateAxis domainAxis = new DateAxis(domainAxisLabel, TimeZone.getDefault());
        NumberAxis rangeAxis = new NumberAxis(rangeAxisLabel);
        XYAreaRenderer renderer = null;
        switch (chartDefinition.getChartType()) {
            case 5: {
                renderer = chartDefinition.isThreeD() ? new XYLine3DRenderer() : new XYLineAndShapeRenderer(true, false);
                ((XYLineAndShapeRenderer)renderer).setShapesVisible(chartDefinition.isMarkersVisible());
                ((XYLineAndShapeRenderer)renderer).setBaseShapesFilled(chartDefinition.isMarkersVisible());
                break;
            }
            case 6: {
                renderer = new XYAreaRenderer();
                break;
            }
            case 7: {
                renderer = new XYStepRenderer();
                break;
            }
            case 8: {
                renderer = new XYStepAreaRenderer();
                break;
            }
            case 9: {
                renderer = new XYDifferenceRenderer();
                break;
            }
            case 10: {
                renderer = new XYDotRenderer();
                ((XYDotRenderer)renderer).setDotHeight(chartDefinition.getDotHeight());
                ((XYDotRenderer)renderer).setDotWidth(chartDefinition.getDotWidth());
                break;
            }
            default: {
                return null;
            }
        }
        if (tooltips) {
            StandardXYToolTipGenerator generator = new StandardXYToolTipGenerator(chartDefinition.getTooltipContent(), (DateFormat)new SimpleDateFormat(chartDefinition.getTooltipXFormat()), (NumberFormat)new DecimalFormat(chartDefinition.getTooltipYFormat()));
            renderer.setToolTipGenerator((XYToolTipGenerator)generator);
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        renderer.setStroke(JFreeChartEngine.getLineStyleStroke(chartDefinition.getLineStyle(), chartDefinition.getLineWidth()));
        XYPlot plot = new XYPlot((XYDataset)chartDefinition, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createStackedTimeSeriesChart(TimeTableXYDatasetChartDefinition chartDefinition) {
        JFreeChart chart = null;
        String domainAxisLabel = null;
        String rangeAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        DateAxis domainAxis = new DateAxis(domainAxisLabel, TimeZone.getDefault());
        NumberAxis rangeAxis = new NumberAxis(rangeAxisLabel);
        StackedXYAreaRenderer2 renderer = null;
        switch (chartDefinition.getChartType()) {
            case 6: {
                renderer = chartDefinition.isStacked() ? new StackedXYAreaRenderer2() : new XYAreaRenderer();
                break;
            }
            default: {
                return null;
            }
        }
        if (tooltips) {
            StandardXYToolTipGenerator generator = new StandardXYToolTipGenerator(chartDefinition.getTooltipContent(), (DateFormat)new SimpleDateFormat(chartDefinition.getTooltipXFormat()), (NumberFormat)new DecimalFormat(chartDefinition.getTooltipYFormat()));
            renderer.setToolTipGenerator((XYToolTipGenerator)generator);
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        renderer.setStroke(JFreeChartEngine.getLineStyleStroke(chartDefinition.getLineStyle(), chartDefinition.getLineWidth()));
        XYPlot plot = new XYPlot((XYDataset)chartDefinition, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createCategoryDatasetChart(CategoryDatasetChartDefinition chartDefinition) {
        JFreeChart chart = null;
        switch (chartDefinition.getChartType()) {
            case 4: {
                chart = JFreeChartEngine.createBarChart(chartDefinition);
                break;
            }
            case 5: {
                chart = JFreeChartEngine.createLineChart(chartDefinition);
                break;
            }
            case 3: {
                chart = JFreeChartEngine.createMultiplePieChart(chartDefinition);
                break;
            }
            case 6: {
                chart = JFreeChartEngine.createAreaChart(chartDefinition);
                break;
            }
        }
        return chart;
    }

    private static JFreeChart createPieDatasetChart(PieDatasetChartDefinition chartDefinition) {
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        PiePlot3D plot = null;
        plot = chartDefinition.isThreeD() ? new PiePlot3D((PieDataset)chartDefinition) : new PiePlot((PieDataset)chartDefinition);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        JFreeChart pieChart = new JFreeChart(title, chartDefinition.getTitleFont(), (Plot)plot, legend);
        TextTitle seriesTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        seriesTitle.setPosition(RectangleEdge.BOTTOM);
        pieChart.setTitle(title);
        pieChart.setBackgroundPaint(chartDefinition.getChartBackgroundPaint());
        if (tooltips) {
            StandardPieToolTipGenerator tooltipGenerator = new StandardPieToolTipGenerator();
            plot.setToolTipGenerator((PieToolTipGenerator)tooltipGenerator);
        }
        if (urls) {
            StandardPieURLGenerator urlGenerator = new StandardPieURLGenerator();
            plot.setURLGenerator((PieURLGenerator)urlGenerator);
        }
        return pieChart;
    }

    private static void updatePlot(Plot plot, ChartDefinition chartDefinition) {
        CategoryAxis domainAxis;
        CategoryDatasetChartDefinition categoryDatasetChartDefintion;
        plot.setBackgroundPaint(chartDefinition.getPlotBackgroundPaint());
        plot.setBackgroundImage(chartDefinition.getPlotBackgroundImage());
        plot.setNoDataMessage(chartDefinition.getNoDataMessage());
        if (chartDefinition.getPaintSequence() != null) {
            DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier(chartDefinition.getPaintSequence(), DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
            plot.setDrawingSupplier((DrawingSupplier)drawingSupplier);
        }
        plot.setOutlineStroke(null);
        if (plot instanceof CategoryPlot) {
            NumberAxis numberAxis;
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryDatasetChartDefintion = (CategoryDatasetChartDefinition)chartDefinition;
            categoryPlot.setOrientation(categoryDatasetChartDefintion.getOrientation());
            domainAxis = categoryPlot.getDomainAxis();
            if (domainAxis != null) {
                domainAxis.setLabel(categoryDatasetChartDefintion.getDomainTitle());
                domainAxis.setLabelFont(categoryDatasetChartDefintion.getDomainTitleFont());
                if (categoryDatasetChartDefintion.getDomainTickFont() != null) {
                    domainAxis.setTickLabelFont(categoryDatasetChartDefintion.getDomainTickFont());
                }
                domainAxis.setCategoryLabelPositions(categoryDatasetChartDefintion.getCategoryLabelPositions());
            }
            if ((numberAxis = (NumberAxis)categoryPlot.getRangeAxis()) != null) {
                numberAxis.setLabel(categoryDatasetChartDefintion.getRangeTitle());
                numberAxis.setLabelFont(categoryDatasetChartDefintion.getRangeTitleFont());
                if (categoryDatasetChartDefintion.getRangeMinimum() != 0.0) {
                    numberAxis.setLowerBound(categoryDatasetChartDefintion.getRangeMinimum());
                }
                if (categoryDatasetChartDefintion.getRangeMaximum() != 1.0) {
                    numberAxis.setUpperBound(categoryDatasetChartDefintion.getRangeMaximum());
                }
                if (categoryDatasetChartDefintion.getRangeTickFormat() != null) {
                    numberAxis.setNumberFormatOverride(categoryDatasetChartDefintion.getRangeTickFormat());
                }
                if (categoryDatasetChartDefintion.getRangeTickFont() != null) {
                    numberAxis.setTickLabelFont(categoryDatasetChartDefintion.getRangeTickFont());
                }
                if (categoryDatasetChartDefintion.getRangeTickUnits() != null) {
                    numberAxis.setTickUnit(new NumberTickUnit(categoryDatasetChartDefintion.getRangeTickUnits().doubleValue()));
                }
            }
        }
        if (plot instanceof PiePlot) {
            StandardPieSectionLabelGenerator labelGen;
            PiePlot pie = (PiePlot)plot;
            PieDatasetChartDefinition pieDefinition = (PieDatasetChartDefinition)chartDefinition;
            pie.setInteriorGap(pieDefinition.getInteriorGap());
            pie.setStartAngle(pieDefinition.getStartAngle());
            pie.setLabelFont(pieDefinition.getLabelFont());
            if (pieDefinition.getLabelPaint() != null) {
                pie.setLabelPaint(pieDefinition.getLabelPaint());
            }
            pie.setLabelBackgroundPaint(pieDefinition.getLabelBackgroundPaint());
            if (pieDefinition.isLegendIncluded()) {
                labelGen = new StandardPieSectionLabelGenerator("{0}");
                pie.setLegendLabelGenerator((PieSectionLabelGenerator)labelGen);
            }
            if (pieDefinition.getExplodedSlices() != null) {
                Iterator iter = pieDefinition.getExplodedSlices().iterator();
                while (iter.hasNext()) {
                    pie.setExplodePercent((Comparable)iter.next(), 0.3);
                }
            }
            pie.setLabelGap(pieDefinition.getLabelGap());
            if (!pieDefinition.isDisplayLabels()) {
                pie.setLabelGenerator(null);
            } else if (pieDefinition.isLegendIncluded()) {
                labelGen = new StandardPieSectionLabelGenerator("{1} ({2})");
                pie.setLabelGenerator((PieSectionLabelGenerator)labelGen);
            } else {
                labelGen = new StandardPieSectionLabelGenerator("{0} = {1} ({2})");
                pie.setLabelGenerator((PieSectionLabelGenerator)labelGen);
            }
        }
        if (plot instanceof MultiplePiePlot) {
            MultiplePiePlot pies = (MultiplePiePlot)plot;
            categoryDatasetChartDefintion = (CategoryDatasetChartDefinition)chartDefinition;
            pies.setDataset((CategoryDataset)categoryDatasetChartDefintion);
        }
        if (plot instanceof MeterPlot) {
            MeterPlot meter = (MeterPlot)plot;
            DialWidgetDefinition widget = (DialWidgetDefinition)chartDefinition;
            List intervals = widget.getIntervals();
            for (MeterInterval interval : intervals) {
                meter.addInterval(interval);
            }
            meter.setNeedlePaint(widget.getNeedlePaint());
            meter.setDialShape(widget.getDialShape());
            meter.setDialBackgroundPaint(widget.getPlotBackgroundPaint());
            meter.setRange(new Range(widget.getMinimum(), widget.getMaximum()));
        }
        if (plot instanceof XYPlot) {
            ValueAxis rangeAxis;
            XYPlot xyPlot = (XYPlot)plot;
            if (chartDefinition instanceof XYSeriesCollectionChartDefinition) {
                XYSeriesCollectionChartDefinition xySeriesCollectionChartDefintion = (XYSeriesCollectionChartDefinition)chartDefinition;
                xyPlot.setOrientation(xySeriesCollectionChartDefintion.getOrientation());
                domainAxis = xyPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabel(xySeriesCollectionChartDefintion.getDomainTitle());
                    domainAxis.setLabelFont(xySeriesCollectionChartDefintion.getDomainTitleFont());
                    domainAxis.setVerticalTickLabels(xySeriesCollectionChartDefintion.isDomainVerticalTickLabels());
                    if (xySeriesCollectionChartDefintion.getDomainTickFormat() != null) {
                        ((NumberAxis)domainAxis).setNumberFormatOverride(xySeriesCollectionChartDefintion.getDomainTickFormat());
                    }
                    if (xySeriesCollectionChartDefintion.getDomainTickFont() != null) {
                        domainAxis.setTickLabelFont(xySeriesCollectionChartDefintion.getDomainTickFont());
                    }
                    if (xySeriesCollectionChartDefintion.getDomainMinimum() != 0.0) {
                        domainAxis.setLowerBound(xySeriesCollectionChartDefintion.getDomainMinimum());
                    }
                    if (xySeriesCollectionChartDefintion.getDomainMaximum() != 1.0) {
                        domainAxis.setUpperBound(xySeriesCollectionChartDefintion.getDomainMaximum());
                    }
                }
                if ((rangeAxis = xyPlot.getRangeAxis()) != null) {
                    rangeAxis.setLabel(xySeriesCollectionChartDefintion.getRangeTitle());
                    rangeAxis.setLabelFont(xySeriesCollectionChartDefintion.getRangeTitleFont());
                    if (xySeriesCollectionChartDefintion.getRangeMinimum() != 0.0) {
                        rangeAxis.setLowerBound(xySeriesCollectionChartDefintion.getRangeMinimum());
                    }
                    if (xySeriesCollectionChartDefintion.getRangeMaximum() != 1.0) {
                        rangeAxis.setUpperBound(xySeriesCollectionChartDefintion.getRangeMaximum());
                    }
                    if (xySeriesCollectionChartDefintion.getRangeMinimum() != 0.0) {
                        rangeAxis.setLowerBound(xySeriesCollectionChartDefintion.getRangeMinimum());
                    }
                    if (xySeriesCollectionChartDefintion.getRangeMaximum() != 1.0) {
                        rangeAxis.setUpperBound(xySeriesCollectionChartDefintion.getRangeMaximum());
                    }
                    if (xySeriesCollectionChartDefintion.getRangeTickFormat() != null) {
                        ((NumberAxis)rangeAxis).setNumberFormatOverride(xySeriesCollectionChartDefintion.getRangeTickFormat());
                    }
                    if (xySeriesCollectionChartDefintion.getRangeTickFont() != null) {
                        rangeAxis.setTickLabelFont(xySeriesCollectionChartDefintion.getRangeTickFont());
                    }
                }
            } else if (chartDefinition instanceof TimeSeriesCollectionChartDefinition) {
                TimeSeriesCollectionChartDefinition timeSeriesCollectionChartDefintion = (TimeSeriesCollectionChartDefinition)chartDefinition;
                xyPlot.setOrientation(timeSeriesCollectionChartDefintion.getOrientation());
                domainAxis = xyPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabel(timeSeriesCollectionChartDefintion.getDomainTitle());
                    domainAxis.setLabelFont(timeSeriesCollectionChartDefintion.getDomainTitleFont());
                    domainAxis.setVerticalTickLabels(timeSeriesCollectionChartDefintion.isDomainVerticalTickLabels());
                    if (domainAxis instanceof DateAxis) {
                        DateAxis da = (DateAxis)domainAxis;
                        if (timeSeriesCollectionChartDefintion.getDateMinimum() != null) {
                            da.setMinimumDate(timeSeriesCollectionChartDefintion.getDateMinimum());
                        }
                        if (timeSeriesCollectionChartDefintion.getDateMaximum() != null) {
                            da.setMaximumDate(timeSeriesCollectionChartDefintion.getDateMaximum());
                        }
                    }
                }
                if ((rangeAxis = xyPlot.getRangeAxis()) != null) {
                    rangeAxis.setLabel(timeSeriesCollectionChartDefintion.getRangeTitle());
                    rangeAxis.setLabelFont(timeSeriesCollectionChartDefintion.getRangeTitleFont());
                    if (timeSeriesCollectionChartDefintion.getRangeMinimum() != 0.0) {
                        rangeAxis.setLowerBound(timeSeriesCollectionChartDefintion.getRangeMinimum());
                    }
                    if (timeSeriesCollectionChartDefintion.getRangeMaximum() != 1.0) {
                        rangeAxis.setUpperBound(timeSeriesCollectionChartDefintion.getRangeMaximum());
                    }
                }
            } else if (chartDefinition instanceof XYZSeriesCollectionChartDefinition) {
                XYZSeriesCollectionChartDefinition xyzSeriesCollectionChartDefintion = (XYZSeriesCollectionChartDefinition)chartDefinition;
                xyPlot.setOrientation(xyzSeriesCollectionChartDefintion.getOrientation());
                domainAxis = xyPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabel(xyzSeriesCollectionChartDefintion.getDomainTitle());
                    domainAxis.setLabelFont(xyzSeriesCollectionChartDefintion.getDomainTitleFont());
                    domainAxis.setVerticalTickLabels(xyzSeriesCollectionChartDefintion.isDomainVerticalTickLabels());
                    if (xyzSeriesCollectionChartDefintion.getDomainMinimum() != 0.0) {
                        domainAxis.setLowerBound(xyzSeriesCollectionChartDefintion.getDomainMinimum());
                    }
                    if (xyzSeriesCollectionChartDefintion.getDomainMaximum() != 1.0) {
                        domainAxis.setUpperBound(xyzSeriesCollectionChartDefintion.getDomainMaximum());
                    }
                    if (xyzSeriesCollectionChartDefintion.getDomainTickFormat() != null) {
                        ((NumberAxis)domainAxis).setNumberFormatOverride(xyzSeriesCollectionChartDefintion.getDomainTickFormat());
                    }
                    if (xyzSeriesCollectionChartDefintion.getDomainTickFont() != null) {
                        domainAxis.setTickLabelFont(xyzSeriesCollectionChartDefintion.getDomainTickFont());
                    }
                }
                if ((rangeAxis = xyPlot.getRangeAxis()) != null) {
                    rangeAxis.setLabel(xyzSeriesCollectionChartDefintion.getRangeTitle());
                    rangeAxis.setLabelFont(xyzSeriesCollectionChartDefintion.getRangeTitleFont());
                    rangeAxis.setLowerBound(xyzSeriesCollectionChartDefintion.getRangeMinimum());
                    if (xyzSeriesCollectionChartDefintion.getRangeMinimum() != 0.0) {
                        rangeAxis.setLowerBound(xyzSeriesCollectionChartDefintion.getRangeMinimum());
                    }
                    if (xyzSeriesCollectionChartDefintion.getRangeMaximum() != 1.0) {
                        rangeAxis.setUpperBound(xyzSeriesCollectionChartDefintion.getRangeMaximum());
                    }
                    if (xyzSeriesCollectionChartDefintion.getRangeTickFormat() != null) {
                        ((NumberAxis)rangeAxis).setNumberFormatOverride(xyzSeriesCollectionChartDefintion.getRangeTickFormat());
                    }
                    if (xyzSeriesCollectionChartDefintion.getRangeTickFont() != null) {
                        rangeAxis.setTickLabelFont(xyzSeriesCollectionChartDefintion.getRangeTickFont());
                    }
                }
            }
        }
    }

    private static JFreeChart createMultiplePieChart(CategoryDatasetChartDefinition chartDefinition) {
        TableOrder order = TableOrder.BY_ROW;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        if (order == null) {
            throw new IllegalArgumentException(Messages.getInstance().getString("JFreeChartEngine.ERROR_0001_NULL_ORDER_ARGUMENT"));
        }
        MultiplePiePlot plot = new MultiplePiePlot((CategoryDataset)chartDefinition);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        plot.setDataExtractOrder(order);
        JFreeChart pieCharts = new JFreeChart(title, chartDefinition.getTitleFont(), (Plot)plot, legend);
        JFreeChart pieChart = plot.getPieChart();
        TextTitle seriesTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        seriesTitle.setPosition(RectangleEdge.BOTTOM);
        pieChart.setTitle(seriesTitle);
        pieChart.setBackgroundPaint(chartDefinition.getChartBackgroundPaint());
        plot.setPieChart(pieChart);
        return pieCharts;
    }

    private static JFreeChart createLineChart(CategoryDatasetChartDefinition chartDefinition) {
        LineRenderer3D renderer;
        String categoryAxisLabel = null;
        String valueAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        Object object = renderer = chartDefinition.isThreeD() ? new LineRenderer3D() : new LineAndShapeRenderer(true, false);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        renderer.setStroke(JFreeChartEngine.getLineStyleStroke(chartDefinition.getLineStyle(), chartDefinition.getLineWidth()));
        renderer.setShapesVisible(chartDefinition.isMarkersVisible());
        renderer.setBaseShapesFilled(chartDefinition.isMarkersVisible());
        CategoryPlot plot = new CategoryPlot((CategoryDataset)chartDefinition, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createBarChart(CategoryDatasetChartDefinition chartDefinition) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        String categoryAxisLabel = null;
        String valueAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        PlotOrientation orientation = chartDefinition.getOrientation();
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        Object renderer = null;
        renderer = chartDefinition.isStacked() || chartDefinition.isThreeD() ? (chartDefinition.isStacked() && chartDefinition.isThreeD() ? new StackedBarRenderer3D() : (chartDefinition.isStacked() ? new StackedBarRenderer() : new BarRenderer3D())) : new BarRenderer();
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setNegativeItemLabelPosition(position2);
        }
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        if (chartDefinition.getMaxBarWidth() != null) {
            renderer.setMaximumBarWidth(chartDefinition.getMaxBarWidth().doubleValue());
        }
        CategoryPlot plot = new CategoryPlot((CategoryDataset)chartDefinition, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createBarLineChart(BarLineChartDefinition chartDefinition) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        String categoryAxisLabel = null;
        String valueAxisLabel = null;
        String secondValueAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        PlotOrientation orientation = chartDefinition.getOrientation();
        CategoryDatasetChartDefinition barsDataset = new CategoryDatasetChartDefinition(chartDefinition.getSession(), chartDefinition.getChartAttributes());
        CategoryDatasetChartDefinition linesDataset = new CategoryDatasetChartDefinition(chartDefinition.getSession(), chartDefinition.getChartAttributes());
        int iColumnCount = chartDefinition.getColumnCount();
        int iRowCount = chartDefinition.getRowCount();
        if (iRowCount <= 0) {
            chartDefinition.setNoDataMessage(Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE"));
        }
        for (int r = 0; r < iRowCount; ++r) {
            String strMeasureName = (String)((Object)chartDefinition.getRowKey(r));
            boolean bIsBarColumn = JFreeChartEngine.isBarColumn(chartDefinition.getBarColumns(), strMeasureName);
            boolean bIsLineColumn = JFreeChartEngine.isLineColumn(chartDefinition.getLineColumns(), strMeasureName);
            for (int c = 0; c < iColumnCount; ++c) {
                Comparable compColumnName = chartDefinition.getColumnKey(c);
                Number nValue = chartDefinition.getValue((Comparable)((Object)strMeasureName), compColumnName);
                if (bIsBarColumn) {
                    barsDataset.addValue(nValue, (Comparable)((Object)strMeasureName), compColumnName);
                }
                if (!bIsLineColumn) continue;
                linesDataset.addValue(nValue, (Comparable)((Object)strMeasureName), compColumnName);
            }
        }
        if (iRowCount > 0 && barsDataset.getRowCount() <= 0 && linesDataset.getRowCount() <= 0) {
            chartDefinition.setNoDataMessage(Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT"));
        }
        CategoryAxis catAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis barsAxis = new NumberAxis(valueAxisLabel);
        NumberAxis linesAxis = new NumberAxis(secondValueAxisLabel);
        linesDataset.setRangeTitle(chartDefinition.getLinesRangeTitle());
        linesDataset.setRangeTitleFont(chartDefinition.getLinesRangeTitleFont());
        if (chartDefinition.getLinesRangeTickFormat() != null) {
            linesAxis.setNumberFormatOverride(chartDefinition.getLinesRangeTickFormat());
        }
        BarRenderer barRenderer = null;
        LineAndShapeRenderer lineRenderer = null;
        if (chartDefinition.isStacked() || chartDefinition.isThreeD()) {
            if (chartDefinition.isStacked() && chartDefinition.isThreeD()) {
                barRenderer = new StackedBarRenderer3D();
                lineRenderer = new LineRenderer3D();
            } else if (chartDefinition.isStacked()) {
                barRenderer = new StackedBarRenderer();
                lineRenderer = new LineAndShapeRenderer();
            } else {
                barRenderer = new BarRenderer3D();
                lineRenderer = new LineRenderer3D();
            }
        } else {
            barRenderer = new BarRenderer();
            lineRenderer = new LineAndShapeRenderer();
        }
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            barRenderer.setPositiveItemLabelPosition(position1);
            lineRenderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            barRenderer.setNegativeItemLabelPosition(position2);
            lineRenderer.setNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            barRenderer.setPositiveItemLabelPosition(position1);
            lineRenderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            barRenderer.setNegativeItemLabelPosition(position2);
            lineRenderer.setNegativeItemLabelPosition(position2);
        }
        if (tooltips) {
            barRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            lineRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            barRenderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
            lineRenderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        if (chartDefinition.getMaxBarWidth() != null) {
            barRenderer.setMaximumBarWidth(chartDefinition.getMaxBarWidth().doubleValue());
        }
        lineRenderer.setStroke(JFreeChartEngine.getLineStyleStroke(chartDefinition.getLineStyle(), chartDefinition.getLineWidth()));
        lineRenderer.setShapesVisible(chartDefinition.isMarkersVisible());
        lineRenderer.setBaseShapesFilled(chartDefinition.isMarkersVisible());
        CategoryPlot plot = new CategoryPlot((CategoryDataset)barsDataset, catAxis, (ValueAxis)barsAxis, (CategoryItemRenderer)barRenderer);
        plot.setRenderer(1, (CategoryItemRenderer)lineRenderer);
        plot.setDataset(1, (CategoryDataset)linesDataset);
        plot.setRangeAxis(1, (ValueAxis)linesAxis);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        JFreeChartEngine.updatePlot((Plot)plot, barsDataset);
        ValueAxis secondValueAxis = plot.getRangeAxis(1);
        if (secondValueAxis != null) {
            if (chartDefinition.getLinesRangeTitle() != null) {
                secondValueAxis.setLabel(chartDefinition.getLinesRangeTitle());
            }
            if (chartDefinition.getLinesRangeTitleFont() != null) {
                secondValueAxis.setLabelFont(chartDefinition.getLinesRangeTitleFont());
            }
            if (chartDefinition.getLinesRangeTickFont() != null) {
                secondValueAxis.setTickLabelFont(chartDefinition.getLinesRangeTickFont());
            }
            if (chartDefinition.getLinesRangeMinimum() != 0.0) {
                secondValueAxis.setLowerBound(chartDefinition.getLinesRangeMinimum());
            }
            if (chartDefinition.getLinesRangeMaximum() != 1.0) {
                secondValueAxis.setUpperBound(chartDefinition.getLinesRangeMaximum());
            }
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static JFreeChart createAreaChart(CategoryDatasetChartDefinition chartDefinition) {
        StackedAreaRenderer renderer;
        String categoryAxisLabel = null;
        String valueAxisLabel = null;
        boolean tooltips = true;
        boolean urls = true;
        String title = chartDefinition.getTitle();
        boolean legend = chartDefinition.isLegendIncluded();
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        Object object = renderer = chartDefinition.isStacked() ? new StackedAreaRenderer() : new AreaRenderer();
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot((CategoryDataset)chartDefinition, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        JFreeChartEngine.updatePlot((Plot)plot, chartDefinition);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        return chart;
    }

    private static void saveChartAsPNG(JFreeChart chart, String path, int width, int height, PrintWriter writer, ChartRenderingInfo info) throws IOException {
        File file = new File(path + ".png");
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
        if (writer != null) {
            ChartUtilities.writeImageMap((PrintWriter)writer, (String)"map-name", (ChartRenderingInfo)info, (boolean)true);
        }
    }

    private static void saveChartAsSVG(JFreeChart chart, String path, int width, int height, ChartRenderingInfo info) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.getGeneratorContext().setPrecision(6);
        chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height), info);
        boolean useCSS = true;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path + ".svg")), LocaleHelper.getSystemEncoding());
        svgGenerator.stream((Writer)out, useCSS);
    }

    private static void saveChart(JFreeChart chart, String path, int width, int height, int outputType, PrintWriter writer, ChartRenderingInfo info) throws IOException {
        if (outputType == 1) {
            JFreeChartEngine.saveChartAsPNG(chart, path, width, height, writer, info);
        } else if (outputType == 2) {
            JFreeChartEngine.saveChartAsSVG(chart, path, width, height, info);
        }
    }

    public static void saveChart(Dataset dataset, String title, String units, String fileName, int width, int height, int outputType, PrintWriter writer, ILogger logger) {
        ChartRenderingInfo info = new ChartRenderingInfo();
        JFreeChartEngine.saveChart(dataset, title, units, fileName, width, height, outputType, writer, info, logger);
    }

    public static void saveChart(Dataset dataset, String title, String units, String fileName, int width, int height, int outputType, PrintWriter writer, ChartRenderingInfo info, ILogger logger) {
        JFreeChart chart = JFreeChartEngine.getChart(dataset, title, units, width, height, logger);
        try {
            String filePath = PentahoSystem.getApplicationContext().getFileOutputPath(fileName);
            JFreeChartEngine.saveChart(chart, filePath, width, height, outputType, writer, info);
        }
        catch (IOException e) {
            logger.error(Messages.getInstance().getString("ChartEngine.ERROR_0001_COULD_NOT_CREATE_CHART"), (Throwable)e);
        }
    }

    public static JFreeChart getChart(Dataset dataset, String title, String units, int width, int height, ILogger logger) {
        JFreeChart chart = null;
        if (dataset instanceof DialWidgetDefinition) {
            chart = JFreeChartEngine.createDial((DialWidgetDefinition)dataset, title, units);
        } else if (dataset instanceof TimeSeriesCollectionChartDefinition) {
            chart = JFreeChartEngine.createTimeSeriesCollectionChart((TimeSeriesCollectionChartDefinition)dataset);
        } else if (dataset instanceof TimeTableXYDatasetChartDefinition) {
            chart = JFreeChartEngine.createStackedTimeSeriesChart((TimeTableXYDatasetChartDefinition)dataset);
        } else if (dataset instanceof XYSeriesCollectionChartDefinition) {
            chart = JFreeChartEngine.createXYSeriesCollectionChart((XYSeriesCollectionChartDefinition)dataset);
        } else if (dataset instanceof BarLineChartDefinition) {
            chart = JFreeChartEngine.createBarLineChart((BarLineChartDefinition)dataset);
        } else if (dataset instanceof CategoryDatasetChartDefinition) {
            chart = JFreeChartEngine.createCategoryDatasetChart((CategoryDatasetChartDefinition)dataset);
        } else if (dataset instanceof PieDatasetChartDefinition) {
            chart = JFreeChartEngine.createPieDatasetChart((PieDatasetChartDefinition)dataset);
        } else if (dataset instanceof XYZSeriesCollectionChartDefinition) {
            chart = JFreeChartEngine.createXYZSeriesCollectionChart((XYZSeriesCollectionChartDefinition)dataset);
        }
        if (chart == null) {
            logger.error(Messages.getInstance().getString("ChartEngine.ERROR_0002_COULD_NOT_CREATE_CHART"));
        } else {
            ChartDefinition chartDefinition = (ChartDefinition)dataset;
            Iterator iter = chartDefinition.getSubtitles().iterator();
            while (iter.hasNext()) {
                chart.addSubtitle((Title)new TextTitle(iter.next().toString()));
            }
            chart.setBackgroundPaint(chartDefinition.getChartBackgroundPaint());
            chart.setBackgroundImage(chartDefinition.getChartBackgroundImage());
            chart.setBorderVisible(chartDefinition.isBorderVisible());
            chart.setBorderPaint(chartDefinition.getBorderPaint());
            if (chart.getTitle() != null) {
                chart.getTitle().setPosition(chartDefinition.getTitlePosition());
                chart.getTitle().setFont(chartDefinition.getTitleFont());
            }
            if (chartDefinition.getLegendFont() != null && chart.getLegend() != null) {
                chart.getLegend().setItemFont(chartDefinition.getLegendFont());
            }
            if (!chartDefinition.isLegendBorderVisible() && chart.getLegend() != null) {
                chart.getLegend().setBorder(BlockBorder.NONE);
            }
            if (chartDefinition.getLegendPosition() != null && chart.getLegend() != null) {
                chart.getLegend().setPosition(chartDefinition.getLegendPosition());
            }
        }
        return chart;
    }

    public static int getChartType(String typeStr) {
        if (typeStr != null) {
            if ("PieChart".equalsIgnoreCase(typeStr)) {
                return 2;
            }
            if ("PieGrid".equalsIgnoreCase(typeStr)) {
                return 3;
            }
            if ("BarChart".equalsIgnoreCase(typeStr)) {
                return 4;
            }
            if ("LineChart".equalsIgnoreCase(typeStr)) {
                return 5;
            }
            if ("AreaChart".equalsIgnoreCase(typeStr)) {
                return 6;
            }
            if ("BarLineChart".equalsIgnoreCase(typeStr)) {
                return 11;
            }
            if ("BubbleChart".equalsIgnoreCase(typeStr)) {
                return 12;
            }
            if ("DialChart".equalsIgnoreCase(typeStr)) {
                return 0;
            }
            if ("DifferenceChart".equalsIgnoreCase(typeStr)) {
                return 9;
            }
            if ("DotChart".equalsIgnoreCase(typeStr)) {
                return 10;
            }
            if ("StepAreaChart".equalsIgnoreCase(typeStr)) {
                return 8;
            }
            if ("StepChart".equalsIgnoreCase(typeStr)) {
                return 7;
            }
        }
        return -1;
    }

    public static String getChartTypeName(int type) {
        String rtn = "";
        switch (type) {
            case 2: {
                rtn = "PieChart";
                break;
            }
            case 3: {
                rtn = "PieGrid";
                break;
            }
            case 4: {
                rtn = "BarChart";
                break;
            }
            case 5: {
                rtn = "LineChart";
                break;
            }
            case 11: {
                rtn = "BarLineChart";
                break;
            }
            case 12: {
                rtn = "BubbleChart";
                break;
            }
            case 0: {
                rtn = "DialChart";
                break;
            }
            case 9: {
                rtn = "DifferenceChart";
                break;
            }
            case 10: {
                rtn = "DotChart";
                break;
            }
            case 8: {
                rtn = "StepAreaChart";
                break;
            }
            case 7: {
                rtn = "StepChart";
                break;
            }
            case 6: {
                rtn = "AreaChart";
                break;
            }
        }
        return rtn;
    }

    public static Color getColor(String htmlColor) {
        return new Color(Integer.parseInt(htmlColor.substring(1, 3), 16), Integer.parseInt(htmlColor.substring(3, 5), 16), Integer.parseInt(htmlColor.substring(5), 16));
    }

    public static Color getTransparent() {
        return new Color(0, 0, 0, 0);
    }

    public static Paint getPaint(Node node, int width, int height, IPentahoSession session) {
        if (node == null) {
            return null;
        }
        if (null != node.selectSingleNode("gradient")) {
            return JFreeChartEngine.getGradientPaint(node.selectSingleNode("gradient"), width, height);
        }
        if (null != node.selectSingleNode("texture")) {
            return JFreeChartEngine.getTexturePaint(node.selectSingleNode("texture"), width, height, session);
        }
        String htmlColor = node.getText();
        return JFreeChartEngine.getPaint(htmlColor);
    }

    public static Font getFont(Node fontNode) {
        Font font = null;
        if (fontNode != null) {
            Node sizeNode;
            boolean italic;
            Node isItalicNode;
            boolean bold;
            Node isBoldNode;
            String fontFamily = TextTitle.DEFAULT_FONT.getFamily();
            int fontStyle = 0;
            int fontSize = TextTitle.DEFAULT_FONT.getSize();
            Node fontFamilyNode = fontNode.selectSingleNode(FONT_FAMILY_NODE_NAME);
            if (fontFamilyNode != null && fontFamilyNode.getText().length() > 0) {
                fontFamily = fontFamilyNode.getText();
            }
            if ((isBoldNode = fontNode.selectSingleNode(IS_BOLD_NODE_NAME)) != null && (bold = Boolean.valueOf(isBoldNode.getText()).booleanValue())) {
                ++fontStyle;
            }
            if ((isItalicNode = fontNode.selectSingleNode(IS_ITALIC_NODE_NAME)) != null && (italic = Boolean.valueOf(isItalicNode.getText()).booleanValue())) {
                fontStyle += 2;
            }
            if ((sizeNode = fontNode.selectSingleNode(SIZE_NODE_NAME)) != null && sizeNode.getText().length() > 0) {
                fontSize = Integer.parseInt(sizeNode.getText());
            }
            font = new Font(fontFamily, fontStyle, fontSize);
        }
        return font;
    }

    public static Paint getPaint(Node node) {
        if (node == null) {
            return null;
        }
        String htmlColor = node.getText();
        return JFreeChartEngine.getPaint(htmlColor);
    }

    public static Paint getPaint(String htmlColor) {
        Color color = JFreeChartEngine.getColor(htmlColor);
        return color;
    }

    public static Paint getGradientPaint(Node gradientNode, int width, int height) {
        if (gradientNode == null) {
            return null;
        }
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = width;
        float y2 = height;
        if (gradientNode.selectSingleNode(X1_NODE_NAME) != null) {
            x1 = Float.parseFloat(gradientNode.selectSingleNode(X1_NODE_NAME).getText());
        }
        if (gradientNode.selectSingleNode(Y1_NODE_NAME) != null) {
            y1 = Float.parseFloat(gradientNode.selectSingleNode(Y1_NODE_NAME).getText());
        }
        if (gradientNode.selectSingleNode(X2_NODE_NAME) != null) {
            x2 = Float.parseFloat(gradientNode.selectSingleNode(X2_NODE_NAME).getText());
        }
        if (gradientNode.selectSingleNode(Y2_NODE_NAME) != null) {
            y2 = Float.parseFloat(gradientNode.selectSingleNode(Y2_NODE_NAME).getText());
        }
        Color color1 = JFreeChartEngine.getColor(gradientNode.selectSingleNode(COLOR1_NODE_NAME).getText());
        Color color2 = JFreeChartEngine.getColor(gradientNode.selectSingleNode(COLOR2_NODE_NAME).getText());
        boolean cyclic = false;
        if (gradientNode.selectSingleNode(CYCLIC_NODE_NAME) != null) {
            cyclic = Boolean.valueOf(gradientNode.selectSingleNode(CYCLIC_NODE_NAME).getText());
        }
        GradientPaint paint = new GradientPaint(x1, y1, color1, x2, y2, color2, cyclic);
        return paint;
    }

    public static Paint getTexturePaint(Node textureNode, int width, int height, IPentahoSession session) {
        if (textureNode == null) {
            return null;
        }
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = width;
        double y2 = height;
        BufferedImage texture = (BufferedImage)JFreeChartEngine.getImage(textureNode.selectSingleNode(TEXTURE_IMAGE_NODE_NAME), session);
        if (textureNode.selectSingleNode(X1_NODE_NAME) != null) {
            x1 = Double.parseDouble(textureNode.selectSingleNode(X1_NODE_NAME).getText());
        }
        if (textureNode.selectSingleNode(Y1_NODE_NAME) != null) {
            y1 = Double.parseDouble(textureNode.selectSingleNode(Y1_NODE_NAME).getText());
        }
        if (textureNode.selectSingleNode(X2_NODE_NAME) != null) {
            x2 = Double.parseDouble(textureNode.selectSingleNode(X2_NODE_NAME).getText());
        }
        if (textureNode.selectSingleNode(Y2_NODE_NAME) != null) {
            y2 = Double.parseDouble(textureNode.selectSingleNode(Y2_NODE_NAME).getText());
        }
        Rectangle2D.Double anchor = new Rectangle2D.Double(x1, y1, x2, y2);
        TexturePaint paint = new TexturePaint(texture, anchor);
        return paint;
    }

    public static Stroke getLineStyleStroke(String lineStyle, float lineWidth) {
        BasicStroke stroke = null;
        float[] strokeSteps = null;
        if (lineWidth < 0.0f) {
            lineWidth = 1.0f;
        }
        if (lineStyle != null) {
            if (lineStyle.equals("dash")) {
                strokeSteps = new float[]{6.0f, 6.0f};
            } else if (lineStyle.equals("dot")) {
                strokeSteps = new float[]{2.0f, 6.0f};
            } else if (lineStyle.equals("dashdot")) {
                strokeSteps = new float[]{10.0f, 6.0f, 2.0f, 6.0f};
            } else if (lineStyle.equals("dashdotdot")) {
                strokeSteps = new float[]{10.0f, 6.0f, 2.0f, 6.0f, 2.0f, 6.0f};
            }
        }
        stroke = strokeSteps != null ? new BasicStroke(lineWidth, 1, 1, 1.0f, strokeSteps, 0.0f) : new BasicStroke(lineWidth);
        return stroke;
    }

    public static Image getImage(Node chartBackgroundImageNode, IPentahoSession session) {
        Image image = null;
        if (chartBackgroundImageNode != null && chartBackgroundImageNode.getText().length() > 0) {
            return JFreeChartEngine.getImage(chartBackgroundImageNode.getText(), session);
        }
        return image;
    }

    public static Image getImage(String imageName, IPentahoSession session) {
        BufferedImage image = null;
        try {
            ActionSequenceResource resource = new ActionSequenceResource("", 1, "", imageName);
            InputStream is = resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
            image = ImageIO.read(is);
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
        }
        return image;
    }

    public static boolean isBarColumn(String[] barColumns, String columnName) {
        String element;
        boolean bIsBarColumn = false;
        String[] arr$ = barColumns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(bIsBarColumn = columnName.equalsIgnoreCase(element = arr$[i$])); ++i$) {
        }
        return bIsBarColumn;
    }

    public static boolean isLineColumn(String[] lineColumns, String columnName) {
        String element;
        boolean bIsLineColumn = false;
        String[] arr$ = lineColumns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(bIsLineColumn = columnName.equalsIgnoreCase(element = arr$[i$])); ++i$) {
        }
        return bIsLineColumn;
    }
}

