/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionsGetPendingJPAExecutor
implements JPAExecutor<List<WorkflowActionBean>> {
    private long minimumPendingAgeSecs = 0L;

    public WorkflowActionsGetPendingJPAExecutor(long minimumPendingAgeSecs) {
        ParamChecker.notNull(minimumPendingAgeSecs, "minimumPendingAgeSecs");
        this.minimumPendingAgeSecs = minimumPendingAgeSecs;
    }

    @Override
    public String getName() {
        return "WorkflowActionsGetPendingJPAExecutor";
    }

    @Override
    public List<WorkflowActionBean> execute(EntityManager em) throws JPAExecutorException {
        Timestamp ts = new Timestamp(System.currentTimeMillis() - this.minimumPendingAgeSecs * 1000L);
        List actionList = null;
        try {
            Query q = em.createNamedQuery("GET_PENDING_ACTIONS");
            q.setParameter("pendingAge", (Object)ts);
            actionList = q.getResultList();
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
        return actionList;
    }
}

