/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowLib;

public class LiteWorkflowAppService
extends WorkflowAppService {
    @Override
    public WorkflowApp parseDef(Configuration jobConf, String authToken) throws WorkflowException {
        String appPath = ParamChecker.notEmpty(jobConf.get("oozie.wf.application.path"), "oozie.wf.application.path");
        String user = ParamChecker.notEmpty(jobConf.get("user.name"), "user.name");
        String group = ParamChecker.notEmpty(jobConf.get("group.name"), "group.name");
        String workflowXml = this.readDefinition(appPath, user, group, authToken);
        return this.parseDef(workflowXml);
    }

    @Override
    public WorkflowApp parseDef(String workflowXml) throws WorkflowException {
        WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
        return workflowLib.parseDef(workflowXml);
    }
}

