/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.command.bundle.BundlePauseXCommand;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.command.bundle.BundleUnpauseXCommand;
import org.apache.oozie.command.coord.CoordPauseXCommand;
import org.apache.oozie.command.coord.CoordUnpauseXCommand;
import org.apache.oozie.executor.jpa.BundleJobsGetNeedStartJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetPausedJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetUnpausedJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetPausedJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetUnpausedJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.MemoryLocks;
import org.apache.oozie.util.XLog;

public class PauseTransitService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.PauseTransitService.";
    public static final String CONF_BUNDLE_PAUSE_START_INTERVAL = "oozie.service.PauseTransitService.PauseTransit.interval";
    private static final XLog LOG = XLog.getLog(PauseTransitService.class);

    @Override
    public void init(Services services) {
        Configuration conf = services.getConf();
        PauseTransitRunnable bundlePauseStartRunnable = new PauseTransitRunnable();
        services.get(SchedulerService.class).schedule(bundlePauseStartRunnable, 10L, (long)conf.getInt(CONF_BUNDLE_PAUSE_START_INTERVAL, 60), SchedulerService.Unit.SEC);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return PauseTransitService.class;
    }

    static class PauseTransitRunnable
    implements Runnable {
        private JPAService jpaService = Services.get().get(JPAService.class);
        private MemoryLocks.LockToken lock;

        public PauseTransitRunnable() {
            if (this.jpaService == null) {
                LOG.error("Missing JPAService");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    this.lock = Services.get().get(MemoryLocksService.class).getWriteLock(PauseTransitService.class.getName(), Service.lockTimeout);
                    if (this.lock == null) {
                        LOG.info("This PauseTransitService instance willnot run since there is already an instance running");
                    } else {
                        LOG.info("Acquired lock for [{0}]", PauseTransitService.class.getName());
                        this.updateBundle();
                        this.updateCoord();
                    }
                    if (this.lock == null) break block7;
                    this.lock.release();
                }
                catch (Exception ex) {
                    try {
                        LOG.warn((Object)"Exception happened when pausing/unpausing/starting bundle/coord jobs", ex);
                        if (this.lock == null) break block7;
                        this.lock.release();
                    }
                    catch (Throwable throwable) {
                        if (this.lock != null) {
                            this.lock.release();
                            LOG.info("Released lock for [{0}]", PauseTransitService.class.getName());
                        }
                        throw throwable;
                    }
                    LOG.info("Released lock for [{0}]", PauseTransitService.class.getName());
                }
                LOG.info("Released lock for [{0}]", PauseTransitService.class.getName());
            }
        }

        private void updateBundle() {
            Date d = new Date();
            List<BundleJobBean> jobList = null;
            try {
                jobList = this.jpaService.execute(new BundleJobsGetUnpausedJPAExecutor(-1));
                if (jobList != null) {
                    for (BundleJobBean bundleJob : jobList) {
                        if (bundleJob.getPauseTime() == null || bundleJob.getPauseTime().after(d)) continue;
                        new BundlePauseXCommand(bundleJob).call();
                        LOG.debug("Calling BundlePauseXCommand for bundle job = " + bundleJob.getId());
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception happened when pausing/unpausing/starting Bundle jobs", ex);
            }
            try {
                jobList = this.jpaService.execute(new BundleJobsGetPausedJPAExecutor(-1));
                if (jobList != null) {
                    for (BundleJobBean bundleJob : jobList) {
                        if (bundleJob.getPauseTime() != null && !bundleJob.getPauseTime().after(d)) continue;
                        new BundleUnpauseXCommand(bundleJob).call();
                        LOG.debug("Calling BundleUnpauseXCommand for bundle job = " + bundleJob.getId());
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception happened when pausing/unpausing/starting Bundle jobs", ex);
            }
            try {
                jobList = this.jpaService.execute(new BundleJobsGetNeedStartJPAExecutor(d));
                if (jobList != null) {
                    for (BundleJobBean bundleJob : jobList) {
                        bundleJob.setKickoffTime(d);
                        new BundleStartXCommand(bundleJob.getId()).call();
                        LOG.debug("Calling BundleStartXCommand for bundle job = " + bundleJob.getId());
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception happened when pausing/unpausing/starting Bundle jobs", ex);
            }
        }

        private void updateCoord() {
            Date d = new Date();
            List<CoordinatorJobBean> jobList = null;
            Configuration conf = Services.get().getConf();
            boolean backwardSupportForCoordStatus = conf.getBoolean("oozie.service.StatusTransitService.backward.support.for.coord.status", false);
            try {
                jobList = this.jpaService.execute(new CoordJobsGetUnpausedJPAExecutor(-1));
                if (jobList != null) {
                    for (CoordinatorJobBean coordJob : jobList) {
                        if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1") || coordJob.getPauseTime() == null || coordJob.getPauseTime().after(d)) continue;
                        new CoordPauseXCommand(coordJob).call();
                        LOG.debug("Calling CoordPauseXCommand for coordinator job = " + coordJob.getId());
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception happened when pausing/unpausing Coordinator jobs", ex);
            }
            try {
                jobList = this.jpaService.execute(new CoordJobsGetPausedJPAExecutor(-1));
                if (jobList != null) {
                    for (CoordinatorJobBean coordJob : jobList) {
                        if (backwardSupportForCoordStatus && coordJob.getAppNamespace() != null && coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1") || coordJob.getPauseTime() != null && !coordJob.getPauseTime().after(d)) continue;
                        new CoordUnpauseXCommand(coordJob).call();
                        LOG.debug("Calling CoordUnpauseXCommand for coordinator job = " + coordJob.getId());
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception happened when pausing/unpausing Coordinator jobs", ex);
            }
        }
    }
}

