/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;

public class ForkNodeDef
extends NodeDef {
    public static final String FORK_COUNT_PREFIX = "workflow.fork.";

    ForkNodeDef() {
    }

    public ForkNodeDef(String name, List<String> transitions) {
        super(name, null, ForkNodeHandler.class, transitions);
    }

    public static class ForkNodeHandler
    extends NodeHandler {
        @Override
        public boolean enter(NodeHandler.Context context) {
            return true;
        }

        @Override
        public List<String> multiExit(NodeHandler.Context context) {
            List<String> transitions = context.getNodeDef().getTransitions();
            context.setVar(ForkNodeDef.FORK_COUNT_PREFIX + context.getExecutionPath(), "" + transitions.size());
            ArrayList<String> fullTransitions = new ArrayList<String>(transitions.size());
            for (String transition : transitions) {
                String childExecutionPath = context.createExecutionPath(transition);
                String fullTransition = context.createFullTransition(childExecutionPath, transition);
                fullTransitions.add(fullTransition);
            }
            return fullTransitions;
        }

        @Override
        public String exit(NodeHandler.Context context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void kill(NodeHandler.Context context) {
        }

        @Override
        public void fail(NodeHandler.Context context) {
        }
    }
}

