/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util.password;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.util.password.PasswordLoader;

public class FilePasswordLoader
extends PasswordLoader {
    public static final Log LOG = LogFactory.getLog((String)FilePasswordLoader.class.getName());

    protected void verifyPath(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            throw new IOException("The password file does not exist! " + path);
        }
        if (!fs.isFile(path)) {
            throw new IOException("The password file cannot be a directory! " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(FileSystem fs, Path path) throws IOException {
        FSDataInputStream is = fs.open(path);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Override
    public String loadPassword(String p, Configuration configuration) throws IOException {
        LOG.debug((Object)("Fetching password from specified path: " + p));
        Path path = new Path(p);
        FileSystem fs = path.getFileSystem(configuration);
        this.verifyPath(fs, path);
        return new String(this.readBytes(fs, path));
    }
}

