/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.hdp21;

import java.util.concurrent.Callable;
import org.pentaho.hadoop.shim.HadoopConfigurationClassLoader;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.common.CommonSqoopShim;

public class ClassPathModifyingSqoopShim
extends CommonSqoopShim {
    private static final String PROPERTY_JAVA_CLASS_PATH = "java.class.path";

    public int runWithModifiedClassPathProperty(Callable<Integer> callable) {
        String newClassPath = this.getClassPathString();
        String originalClassPath = System.getProperty(PROPERTY_JAVA_CLASS_PATH);
        if (newClassPath != null) {
            System.setProperty(PROPERTY_JAVA_CLASS_PATH, newClassPath);
        }
        try {
            Integer returnVal = callable.call();
            int n = returnVal == null ? Integer.MIN_VALUE : returnVal;
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (originalClassPath != null) {
                System.setProperty(PROPERTY_JAVA_CLASS_PATH, originalClassPath);
            }
        }
    }

    @Override
    public int runTool(final String[] args, final Configuration c) {
        return this.runWithModifiedClassPathProperty(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ClassPathModifyingSqoopShim.super.runTool(args, c);
            }
        });
    }

    protected String getClassPathString() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (HadoopConfigurationClassLoader.class.isAssignableFrom(cl.getClass())) {
            HadoopConfigurationClassLoader hccl = (HadoopConfigurationClassLoader)cl;
            return hccl.generateClassPathString();
        }
        return null;
    }
}

