/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.WebHCatJTShim23;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.util.HostUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class Hadoop23Shims
extends HadoopShimsSecure {
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;

    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return HostUtil.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContextImpl(conf, new org.apache.hadoop.mapreduce.TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new org.apache.hadoop.mapreduce.task.JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }

    @Override
    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    @Override
    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    @Override
    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.defaultFS");
        ret.put("HADOOPMAPFILENAME", "mapreduce.map.input.file");
        ret.put("HADOOPMAPREDINPUTDIR", "mapreduce.input.fileinputformat.inputdir");
        ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapreduce.input.fileinputformat.input.dir.recursive");
        ret.put("MAPREDMAXSPLITSIZE", "mapreduce.input.fileinputformat.split.maxsize");
        ret.put("MAPREDMINSPLITSIZE", "mapreduce.input.fileinputformat.split.minsize");
        ret.put("MAPREDMINSPLITSIZEPERNODE", "mapreduce.input.fileinputformat.split.minsize.per.rack");
        ret.put("MAPREDMINSPLITSIZEPERRACK", "mapreduce.input.fileinputformat.split.minsize.per.node");
        ret.put("HADOOPNUMREDUCERS", "mapreduce.job.reduces");
        ret.put("HADOOPJOBNAME", "mapreduce.job.name");
        ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapreduce.reduce.speculative");
        ret.put("MAPREDSETUPCLEANUPNEEDED", "mapreduce.job.committer.setup.cleanup.needed");
        ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        return ret;
    }

    @Override
    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    @Override
    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((Configuration)jobConf, (Path)partitionFile);
    }

    @Override
    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    @Override
    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims23();
        }
        return this.hcatShimInstance;
    }

    @Override
    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim23(conf, ugi);
    }

    public static class HCatHadoopShims23
    implements HadoopShims.HCatHadoopShims {
        @Override
        public TaskID createTaskID() {
            return new TaskID("", 0, TaskType.MAP, 0);
        }

        @Override
        public org.apache.hadoop.mapreduce.TaskAttemptID createTaskAttemptID() {
            return new org.apache.hadoop.mapreduce.TaskAttemptID("", 0, TaskType.MAP, 0, 0);
        }

        @Override
        public TaskAttemptContext createTaskAttemptContext(Configuration conf, org.apache.hadoop.mapreduce.TaskAttemptID taskId) {
            return new TaskAttemptContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), taskId);
        }

        @Override
        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContextImpl.class.getDeclaredConstructor(JobConf.class, TaskAttemptID.class, Reporter.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(new JobConf((Configuration)conf), taskId, (Reporter)progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        @Override
        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new org.apache.hadoop.mapreduce.task.JobContextImpl((Configuration)(conf instanceof JobConf ? new JobConf(conf) : conf), jobId);
        }

        @Override
        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            return new JobContextImpl(new JobConf((Configuration)conf), jobId, (Progressable)((Reporter)progressable));
        }

        @Override
        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        @Override
        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
        }

        @Override
        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            String addr = conf.get("yarn.resourcemanager.address", "localhost:8032");
            return NetUtils.createSocketAddr((String)addr);
        }

        @Override
        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapreduce.job.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapreduce.job.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapreduce.job.cache.symlink.create";
                }
            }
            return "";
        }

        @Override
        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.resolvePath(path).toUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank(address = StringUtils.substringAfterLast(address, ":"))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

