/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.File;
import java.io.IOException;
import mondrian.olap.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class SchemaResolver {
    private static final Log logger = LogFactory.getLog(SchemaResolver.class);

    private SchemaResolver() {
    }

    public static String resolveSchema(ResourceManager resourceManager, ResourceKey contextKey, String catalogUrl) throws FileSystemException {
        FileSystemManager fsManager = VFS.getManager();
        if (fsManager == null) {
            throw Util.newError((String)"Cannot get virtual file system manager");
        }
        if (catalogUrl.startsWith("file://localhost")) {
            catalogUrl = catalogUrl.substring("file://localhost".length());
        }
        if (catalogUrl.startsWith("file:")) {
            catalogUrl = catalogUrl.substring("file:".length());
        }
        try {
            File catalogFile = new File(catalogUrl).getCanonicalFile();
            FileObject file = fsManager.toFileObject(catalogFile);
            if (file.isReadable()) {
                return catalogFile.getPath();
            }
        }
        catch (FileSystemException fse) {
            logger.info((Object)("Failed to resolve schema file '" + catalogUrl + "' as local file. Treating file as non-readable."), (Throwable)fse);
        }
        catch (IOException e) {
            logger.info((Object)("Failed to resolve schema file '" + catalogUrl + "' as local file. Treating file as non-readable."), (Throwable)e);
        }
        if (contextKey == null) {
            return catalogUrl;
        }
        File contextAsFile = SchemaResolver.getContextAsFile(contextKey);
        if (contextAsFile == null) {
            return catalogUrl;
        }
        File resolvedFile = new File(contextAsFile.getParentFile(), catalogUrl);
        if (resolvedFile.isFile() && resolvedFile.canRead()) {
            return resolvedFile.getAbsolutePath();
        }
        return catalogUrl;
    }

    private static File getContextAsFile(ResourceKey key) {
        while (key != null) {
            Object identifier = key.getIdentifier();
            if (identifier instanceof File) {
                return (File)identifier;
            }
            key = key.getParent();
        }
        return null;
    }
}

